/*
 * Decompiled with CFR 0.152.
 */
package net.tigereye.chestcavity.items;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.tigereye.chestcavity.ChestCavity;
import net.tigereye.chestcavity.chestcavities.ChestCavityInventory;
import net.tigereye.chestcavity.chestcavities.instance.ChestCavityInstance;
import net.tigereye.chestcavity.interfaces.ChestCavityEntity;
import net.tigereye.chestcavity.registration.CCItems;
import net.tigereye.chestcavity.registration.CCOrganScores;
import net.tigereye.chestcavity.ui.ChestCavityScreenHandler;
import net.tigereye.chestcavity.util.ChestCavityUtil;

public class ChestOpener
extends Item {
    public ChestOpener() {
        super(CCItems.CHEST_OPENER_PROPERTIES);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ChestCavity.printOnDebug("ChestOpener.use() called!");
        PlayerEntity target = player;
        if (this.openChestCavity(player, (LivingEntity)target, false)) {
            return ActionResult.func_233538_a_((Object)player.func_184586_b(hand), (boolean)false);
        }
        return ActionResult.func_226250_c_((Object)player.func_184586_b(hand));
    }

    public boolean openChestCavity(PlayerEntity player, LivingEntity target) {
        return this.openChestCavity(player, target, true);
    }

    public boolean openChestCavity(PlayerEntity player, LivingEntity target, boolean shouldKnockback) {
        Optional<ChestCavityEntity> optional = ChestCavityEntity.of((Entity)target);
        ChestCavity.printOnDebug("ChestOpener.openChestCavity() called! Optional: " + optional.isPresent());
        ChestCavity.printOnDebug("Target Entity: " + target.toString());
        if (optional.isPresent()) {
            ChestCavityEntity chestCavityEntity = optional.get();
            ChestCavityInstance cc = chestCavityEntity.getChestCavityInstance();
            if (target == player || cc.getChestCavityType().isOpenable(cc)) {
                if (cc.getOrganScore(CCOrganScores.EASE_OF_ACCESS) > 0.0f) {
                    if (player.field_70170_p.field_72995_K) {
                        player.func_213823_a(SoundEvents.field_187657_V, SoundCategory.PLAYERS, 0.75f, 1.0f);
                    }
                } else if (!shouldKnockback) {
                    target.func_70097_a(DamageSource.field_76377_j, 4.0f);
                } else {
                    target.func_70097_a(DamageSource.func_76365_a((PlayerEntity)player), 4.0f);
                }
                if (target.func_70089_S()) {
                    String name;
                    try {
                        name = target.func_145748_c_().getString();
                        name = name.concat("'s ");
                    }
                    catch (Exception e) {
                        name = "";
                    }
                    ChestCavityInventory inv = ChestCavityUtil.openChestCavity(cc);
                    ((ChestCavityEntity)player).getChestCavityInstance().ccBeingOpened = cc;
                    player.func_213829_a((INamedContainerProvider)new SimpleNamedContainerProvider((i, playerInventory, playerEntity) -> new ChestCavityScreenHandler(i, playerInventory, inv), (ITextComponent)new TranslationTextComponent(name + "Chest Cavity")));
                }
                return true;
            }
            if (player.field_70170_p.field_72995_K) {
                if (!target.func_184582_a(EquipmentSlotType.CHEST).func_190926_b()) {
                    player.func_145747_a((ITextComponent)new StringTextComponent("Target's chest is obstructed"), new UUID(100L, 0L));
                    player.func_213823_a(SoundEvents.field_232694_bB_, SoundCategory.PLAYERS, 0.75f, 1.0f);
                } else {
                    player.func_145747_a((ITextComponent)new StringTextComponent("Target is too healthy to open"), new UUID(100L, 0L));
                    player.func_213823_a(SoundEvents.field_203254_u, SoundCategory.PLAYERS, 0.75f, 1.0f);
                }
            }
            return false;
        }
        return false;
    }
}

