/*
 * Decompiled with CFR 0.152.
 */
package net.tigereye.chestcavity.listeners;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.loot.BinomialRange;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.tigereye.chestcavity.chestcavities.instance.ChestCavityInstance;
import net.tigereye.chestcavity.chestcavities.organs.OrganManager;
import net.tigereye.chestcavity.interfaces.ChestCavityEntity;
import net.tigereye.chestcavity.recipes.SalvageRecipe;
import net.tigereye.chestcavity.registration.CCEnchantments;
import net.tigereye.chestcavity.registration.CCItems;
import net.tigereye.chestcavity.registration.CCTags;

@Mod.EventBusSubscriber(modid="chestcavity", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class LootRegister {
    private static final ResourceLocation DESERT_PYRAMID_LOOT_TABLE_ID = new ResourceLocation("minecraft", "chests/desert_pyramid");
    private static List<SalvageRecipe> salvageRecipeList;

    public static List<ItemStack> addLoot(LootContext lootContext) {
        ArrayList<ItemStack> loot = new ArrayList<ItemStack>();
        if (lootContext.func_216033_a(LootParameters.field_216282_b)) {
            Random random;
            int lootingLevel;
            Entity entity = (Entity)lootContext.func_216031_c(LootParameters.field_216281_a);
            Optional<ChestCavityEntity> chestCavityEntity = ChestCavityEntity.of(entity);
            if (!chestCavityEntity.isPresent()) {
                return loot;
            }
            ChestCavityInstance cc = chestCavityEntity.get().getChestCavityInstance();
            if (cc.opened) {
                return loot;
            }
            if (lootContext.func_216031_c(LootParameters.field_216284_d) instanceof LivingEntity) {
                LivingEntity killer = (LivingEntity)lootContext.func_216031_c(LootParameters.field_216284_d);
                if (EnchantmentHelper.func_185284_a((Enchantment)((Enchantment)CCEnchantments.TOMOPHOBIA.get()), (LivingEntity)killer) > 0) {
                    return loot;
                }
                lootingLevel = EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_185304_p, (LivingEntity)killer);
                lootingLevel += EnchantmentHelper.func_185284_a((Enchantment)((Enchantment)CCEnchantments.SURGICAL.get()), (LivingEntity)killer) * 2;
                if (killer.func_184586_b(killer.func_184600_cs()).func_77973_b().func_206844_a(CCTags.BUTCHERING_TOOL)) {
                    lootingLevel = 10 + 10 * lootingLevel;
                }
                random = lootContext.func_216032_b();
            } else {
                lootingLevel = 0;
                random = new Random();
            }
            loot.addAll(cc.getChestCavityType().generateLootDrops(random, lootingLevel));
        }
        return loot;
    }

    public static List<ItemStack> modifyLoot(List<ItemStack> loot, LootContext lootContext) {
        Entity killer_;
        if (lootContext.func_216033_a(LootParameters.field_216284_d) && (killer_ = (Entity)lootContext.func_216031_c(LootParameters.field_216284_d)) instanceof LivingEntity) {
            LivingEntity killer = (LivingEntity)killer_;
            if (killer.func_184586_b(killer.func_184600_cs()).func_77973_b().func_206844_a(CCTags.BUTCHERING_TOOL)) {
                HashMap<SalvageRecipe, Integer> salvageResults = new HashMap<SalvageRecipe, Integer>();
                Iterator<ItemStack> i = loot.iterator();
                if (salvageRecipeList == null) {
                    salvageRecipeList = new ArrayList<SalvageRecipe>();
                    List recipes = killer.field_70170_p.func_199532_z().func_241447_a_(IRecipeType.field_222149_a);
                    for (ICraftingRecipe iCraftingRecipe : recipes) {
                        if (!(iCraftingRecipe instanceof SalvageRecipe)) continue;
                        salvageRecipeList.add((SalvageRecipe)iCraftingRecipe);
                    }
                }
                block1: while (i.hasNext()) {
                    ItemStack stack = i.next();
                    if (!stack.func_77973_b().func_206844_a(CCTags.SALVAGEABLE)) continue;
                    for (SalvageRecipe salvageRecipe : salvageRecipeList) {
                        if (!salvageRecipe.getInput().test(stack)) continue;
                        salvageResults.put(salvageRecipe, salvageResults.getOrDefault(salvageRecipe, 0) + stack.func_190916_E());
                        i.remove();
                        continue block1;
                    }
                }
                salvageResults.forEach((recipe, count) -> {
                    ItemStack out = recipe.func_77571_b();
                    out.func_190920_e(out.func_190916_E() * (count / recipe.getRequired()));
                    loot.add(out);
                });
            }
            if (EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)CCEnchantments.MALPRACTICE.get()), (ItemStack)killer.func_184586_b(killer.func_184600_cs())) > 0) {
                for (ItemStack stack : loot) {
                    if (!OrganManager.isTrueOrgan(stack.func_77973_b())) continue;
                    stack.func_77966_a((Enchantment)CCEnchantments.MALPRACTICE.get(), 1);
                }
            }
        }
        return loot;
    }

    @SubscribeEvent
    public static void registerDesertPyramidLoot(LootTableLoadEvent event) {
        ResourceLocation id = event.getTable().getLootTableId();
        LootTable table = event.getTable();
        if (DESERT_PYRAMID_LOOT_TABLE_ID.equals((Object)id)) {
            LootPool.Builder poolBuilder = new LootPool.Builder().func_216046_a((IRandomRange)BinomialRange.func_215838_a((int)4, (float)0.25f)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)CCItems.ROTTEN_RIB.get())));
            table.addPool(poolBuilder.func_216044_b());
            poolBuilder = new LootPool.Builder().func_216046_a((IRandomRange)BinomialRange.func_215838_a((int)1, (float)0.3f)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)CCItems.ROTTEN_RIB.get())));
            table.addPool(poolBuilder.func_216044_b());
        }
    }
}

