/*
 * Decompiled with CFR 0.152.
 */
package net.tigereye.chestcavity.listeners;

import it.unimi.dsi.fastutil.ints.IntComparators;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.tigereye.chestcavity.ChestCavity;
import net.tigereye.chestcavity.chestcavities.instance.ChestCavityInstance;
import net.tigereye.chestcavity.registration.CCOrganScores;
import net.tigereye.chestcavity.registration.CCStatusEffects;
import net.tigereye.chestcavity.registration.CCTags;
import net.tigereye.chestcavity.util.CCMixinThing;
import net.tigereye.chestcavity.util.ChestCavityUtil;
import net.tigereye.chestcavity.util.OrganUtil;

public class OrganActivationListeners {
    private static Map<ResourceLocation, BiConsumer<LivingEntity, ChestCavityInstance>> abilityIDMap = new HashMap<ResourceLocation, BiConsumer<LivingEntity, ChestCavityInstance>>();

    public static void register() {
        OrganActivationListeners.register(CCOrganScores.CREEPY, OrganActivationListeners::ActivateCreepy);
        OrganActivationListeners.register(CCOrganScores.DRAGON_BREATH, OrganActivationListeners::ActivateDragonBreath);
        OrganActivationListeners.register(CCOrganScores.DRAGON_BOMBS, OrganActivationListeners::ActivateDragonBombs);
        OrganActivationListeners.register(CCOrganScores.FORCEFUL_SPIT, OrganActivationListeners::ActivateForcefulSpit);
        OrganActivationListeners.register(CCOrganScores.FURNACE_POWERED, OrganActivationListeners::ActivateFurnacePowered);
        OrganActivationListeners.register(CCOrganScores.IRON_REPAIR, OrganActivationListeners::ActivateIronRepair);
        OrganActivationListeners.register(CCOrganScores.PYROMANCY, OrganActivationListeners::ActivatePyromancy);
        OrganActivationListeners.register(CCOrganScores.GHASTLY, OrganActivationListeners::ActivateGhastly);
        OrganActivationListeners.register(CCOrganScores.GRAZING, OrganActivationListeners::ActivateGrazing);
        OrganActivationListeners.register(CCOrganScores.SHULKER_BULLETS, OrganActivationListeners::ActivateShulkerBullets);
        OrganActivationListeners.register(CCOrganScores.SILK, OrganActivationListeners::ActivateSilk);
    }

    public static void register(ResourceLocation id, BiConsumer<LivingEntity, ChestCavityInstance> ability) {
        abilityIDMap.put(id, ability);
    }

    public static boolean activate(ResourceLocation id, ChestCavityInstance cc) {
        if (abilityIDMap.containsKey(id)) {
            abilityIDMap.get(id).accept(cc.owner, cc);
            return true;
        }
        return false;
    }

    public static void ActivateCreepy(LivingEntity entity, ChestCavityInstance cc) {
        if (cc.getOrganScore(CCOrganScores.CREEPY) < 1.0f) {
            return;
        }
        if (entity.func_70644_a((Effect)CCStatusEffects.EXPLOSION_COOLDOWN.get())) {
            return;
        }
        float explosion_yield = cc.getOrganScore(CCOrganScores.EXPLOSIVE);
        ChestCavityUtil.destroyOrgansWithKey(cc, CCOrganScores.EXPLOSIVE);
        OrganUtil.explode(entity, explosion_yield);
        if (entity.func_70089_S()) {
            entity.func_195064_c(new EffectInstance((Effect)CCStatusEffects.EXPLOSION_COOLDOWN.get(), ChestCavity.config.EXPLOSION_COOLDOWN, 0, false, false, true));
        }
    }

    public static void ActivateDragonBreath(LivingEntity entity, ChestCavityInstance cc) {
        float breath = cc.getOrganScore(CCOrganScores.DRAGON_BREATH);
        if (entity instanceof PlayerEntity) {
            ((PlayerEntity)entity).func_71020_j(breath * 0.6f);
        }
        if (breath <= 0.0f) {
            return;
        }
        if (!entity.func_70644_a((Effect)CCStatusEffects.DRAGON_BREATH_COOLDOWN.get())) {
            entity.func_195064_c(new EffectInstance((Effect)CCStatusEffects.DRAGON_BREATH_COOLDOWN.get(), ChestCavity.config.DRAGON_BREATH_COOLDOWN, 0, false, false, true));
            cc.projectileQueue.add(OrganUtil::spawnDragonBreath);
        }
    }

    public static void ActivateDragonBombs(LivingEntity entity, ChestCavityInstance cc) {
        float projectiles = cc.getOrganScore(CCOrganScores.DRAGON_BOMBS);
        if (projectiles < 1.0f) {
            return;
        }
        if (!entity.func_70644_a((Effect)CCStatusEffects.DRAGON_BOMB_COOLDOWN.get())) {
            OrganUtil.queueDragonBombs(entity, cc, (int)projectiles);
        }
    }

    public static void ActivateForcefulSpit(LivingEntity entity, ChestCavityInstance cc) {
        float projectiles = cc.getOrganScore(CCOrganScores.FORCEFUL_SPIT);
        if (projectiles < 1.0f) {
            return;
        }
        if (!entity.func_70644_a((Effect)CCStatusEffects.FORCEFUL_SPIT_COOLDOWN.get())) {
            OrganUtil.queueForcefulSpit(entity, cc, (int)projectiles);
        }
    }

    public static void ActivateFurnacePowered(LivingEntity entity, ChestCavityInstance cc) {
        int furnacePowered = Math.round(cc.getOrganScore(CCOrganScores.FURNACE_POWERED));
        if (furnacePowered < 1) {
            return;
        }
        int fuelValue = 0;
        ItemStack itemStack = cc.owner.func_184582_a(EquipmentSlotType.MAINHAND);
        if (itemStack != null && itemStack != ItemStack.field_190927_a) {
            try {
                fuelValue = 10;
            }
            catch (Exception e) {
                fuelValue = 0;
            }
        }
        if (fuelValue == 0 && (itemStack = cc.owner.func_184582_a(EquipmentSlotType.OFFHAND)) != null && itemStack != ItemStack.field_190927_a) {
            try {
                fuelValue = 10;
            }
            catch (Exception e) {
                fuelValue = 0;
            }
        }
        if (fuelValue == 0) {
            return;
        }
        EffectInstance newSEI = null;
        if (cc.owner.func_70644_a((Effect)CCStatusEffects.FURNACE_POWER.get())) {
            EffectInstance oldPower = cc.owner.func_70660_b((Effect)CCStatusEffects.FURNACE_POWER.get());
            if (oldPower.func_76458_c() >= furnacePowered - 1) {
                return;
            }
            CompoundNBT oldTag = new CompoundNBT();
            ArrayList<Integer> durations = new ArrayList<Integer>();
            durations.add(fuelValue);
            oldPower.func_82719_a(oldTag);
            while (true) {
                durations.add(oldTag.func_74762_e("Duration"));
                if (!oldTag.func_74764_b("HiddenEffect")) break;
                oldTag = oldTag.func_74775_l("HiddenEffect");
            }
            durations.sort((Comparator<Integer>)IntComparators.OPPOSITE_COMPARATOR);
            int amplifier = 0;
            for (Integer duration : durations) {
                newSEI = new EffectInstance((Effect)CCStatusEffects.FURNACE_POWER.get(), duration.intValue(), amplifier, false, false, true, newSEI);
                ++amplifier;
            }
        } else {
            newSEI = new EffectInstance((Effect)CCStatusEffects.FURNACE_POWER.get(), fuelValue, 0, false, false, true);
        }
        entity.func_195063_d((Effect)CCStatusEffects.FURNACE_POWER.get());
        entity.func_195064_c(newSEI);
        itemStack.func_190918_g(1);
    }

    public static void ActivateIronRepair(LivingEntity entity, ChestCavityInstance cc) {
        float ironRepair = cc.getOrganScore(CCOrganScores.IRON_REPAIR) - cc.getChestCavityType().getDefaultOrganScore(CCOrganScores.IRON_REPAIR);
        if (ironRepair <= 0.0f) {
            return;
        }
        if (cc.owner.func_70644_a((Effect)CCStatusEffects.IRON_REPAIR_COOLDOWN.get())) {
            return;
        }
        if (cc.owner.func_110143_aJ() >= cc.owner.func_110138_aP()) {
            return;
        }
        ItemStack itemStack = cc.owner.func_184582_a(EquipmentSlotType.MAINHAND);
        if (!(itemStack != null && itemStack.func_77973_b().func_206844_a(CCTags.IRON_REPAIR_MATERIAL) || (itemStack = cc.owner.func_184582_a(EquipmentSlotType.OFFHAND)) != null && itemStack.func_77973_b().func_206844_a(CCTags.IRON_REPAIR_MATERIAL))) {
            return;
        }
        cc.owner.func_70691_i(cc.owner.func_110138_aP() * ChestCavity.config.IRON_REPAIR_PERCENT);
        entity.func_184185_a(SoundEvents.field_226143_fP_, 0.75f, 1.0f);
        cc.owner.func_195064_c(new EffectInstance((Effect)CCStatusEffects.IRON_REPAIR_COOLDOWN.get(), (int)((float)ChestCavity.config.IRON_REPAIR_COOLDOWN / ironRepair), 0, false, false, true));
        itemStack.func_190918_g(1);
    }

    public static void ActivateGhastly(LivingEntity entity, ChestCavityInstance cc) {
        float ghastly = cc.getOrganScore(CCOrganScores.GHASTLY);
        if (ghastly < 1.0f) {
            return;
        }
        if (!entity.func_70644_a((Effect)CCStatusEffects.GHASTLY_COOLDOWN.get())) {
            OrganUtil.queueGhastlyFireballs(entity, cc, (int)ghastly);
        }
    }

    private static void ActivateGrazing(LivingEntity entity, ChestCavityInstance cc) {
        float grazing = cc.getOrganScore(CCOrganScores.GRAZING);
        if (grazing <= 0.0f) {
            return;
        }
        BlockPos blockPos = ((CCMixinThing)entity).getMixinBlockPos().func_177977_b();
        boolean ateGrass = false;
        if (entity.field_70170_p.func_180495_p(blockPos).func_203425_a(Blocks.field_196658_i) || entity.field_70170_p.func_180495_p(blockPos).func_203425_a(Blocks.field_150391_bh)) {
            entity.field_70170_p.func_180501_a(blockPos, Blocks.field_150346_d.func_176223_P(), 2);
            ateGrass = true;
        } else if (entity.field_70170_p.func_180495_p(blockPos).func_203425_a(Blocks.field_235381_mu_) || entity.field_70170_p.func_180495_p(blockPos).func_203425_a(Blocks.field_235372_ml_)) {
            entity.field_70170_p.func_180501_a(blockPos, Blocks.field_150424_aL.func_176223_P(), 2);
            ateGrass = true;
        }
        if (ateGrass) {
            int duration;
            if (entity.func_70644_a((Effect)CCStatusEffects.RUMINATING.get())) {
                EffectInstance ruminating = entity.func_70660_b((Effect)CCStatusEffects.RUMINATING.get());
                duration = (int)Math.min((float)(ChestCavity.config.RUMINATION_TIME * ChestCavity.config.RUMINATION_GRASS_PER_SQUARE * ChestCavity.config.RUMINATION_SQUARES_PER_STOMACH) * grazing, (float)(ruminating.func_76459_b() + ChestCavity.config.RUMINATION_TIME * ChestCavity.config.RUMINATION_GRASS_PER_SQUARE));
            } else {
                duration = ChestCavity.config.RUMINATION_TIME * ChestCavity.config.RUMINATION_GRASS_PER_SQUARE;
            }
            entity.func_195064_c(new EffectInstance((Effect)CCStatusEffects.RUMINATING.get(), duration, 0, false, false, true));
        }
    }

    public static void ActivatePyromancy(LivingEntity entity, ChestCavityInstance cc) {
        float pyromancy = cc.getOrganScore(CCOrganScores.PYROMANCY);
        if (pyromancy < 1.0f) {
            return;
        }
        if (!entity.func_70644_a((Effect)CCStatusEffects.PYROMANCY_COOLDOWN.get())) {
            OrganUtil.queuePyromancyFireballs(entity, cc, (int)pyromancy);
        }
    }

    public static void ActivateShulkerBullets(LivingEntity entity, ChestCavityInstance cc) {
        float projectiles = cc.getOrganScore(CCOrganScores.SHULKER_BULLETS);
        if (projectiles < 1.0f) {
            return;
        }
        if (!entity.func_70644_a((Effect)CCStatusEffects.SHULKER_BULLET_COOLDOWN.get())) {
            OrganUtil.queueShulkerBullets(entity, cc, (int)projectiles);
        }
    }

    public static void ActivateSilk(LivingEntity entity, ChestCavityInstance cc) {
        if (cc.getOrganScore(CCOrganScores.SILK) == 0.0f) {
            return;
        }
        if (entity.func_70644_a((Effect)CCStatusEffects.SILK_COOLDOWN.get())) {
            return;
        }
        if (OrganUtil.spinWeb(entity, cc, cc.getOrganScore(CCOrganScores.SILK))) {
            entity.func_195064_c(new EffectInstance((Effect)CCStatusEffects.SILK_COOLDOWN.get(), ChestCavity.config.SILK_COOLDOWN, 0, false, false, true));
        }
    }
}

