/*
 * Decompiled with CFR 0.152.
 */
package net.tigereye.chestcavity.listeners;

import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.potion.Effect;
import net.tigereye.chestcavity.interfaces.ChestCavityEntity;
import net.tigereye.chestcavity.listeners.EffectiveFoodScores;
import net.tigereye.chestcavity.registration.CCItems;
import net.tigereye.chestcavity.registration.CCOrganScores;
import net.tigereye.chestcavity.registration.CCStatusEffects;
import net.tigereye.chestcavity.registration.CCTags;

public class OrganFoodListeners {
    public static EffectiveFoodScores callMethods(Item food, Food foodComponent, ChestCavityEntity cce, EffectiveFoodScores efs) {
        OrganFoodListeners.applyHerbivorousCarnivorous(food, foodComponent, cce, efs);
        OrganFoodListeners.applyRot(food, foodComponent, cce, efs);
        OrganFoodListeners.applyFurnacePower(food, foodComponent, cce, efs);
        return efs;
    }

    private static EffectiveFoodScores applyHerbivorousCarnivorous(Item food, Food foodComponent, ChestCavityEntity cce, EffectiveFoodScores efs) {
        if (foodComponent.func_221467_c() || food.func_190903_i().func_77973_b().func_206844_a(CCTags.CARNIVORE_FOOD)) {
            efs.digestion += cce.getChestCavityInstance().getOrganScore(CCOrganScores.CARNIVOROUS_DIGESTION);
            efs.nutrition += cce.getChestCavityInstance().getOrganScore(CCOrganScores.CARNIVOROUS_NUTRITION);
        } else {
            efs.digestion += cce.getChestCavityInstance().getOrganScore(CCOrganScores.HERBIVOROUS_DIGESTION);
            efs.nutrition += cce.getChestCavityInstance().getOrganScore(CCOrganScores.HERBIVOROUS_NUTRITION);
        }
        return efs;
    }

    private static EffectiveFoodScores applyRot(Item food, Food foodComponent, ChestCavityEntity cce, EffectiveFoodScores efs) {
        if (food.func_190903_i().func_77973_b().func_206844_a(CCTags.ROTTEN_FOOD)) {
            efs.digestion += cce.getChestCavityInstance().getOrganScore(CCOrganScores.ROT_DIGESTION);
            efs.nutrition += cce.getChestCavityInstance().getOrganScore(CCOrganScores.ROTGUT);
        }
        return efs;
    }

    private static EffectiveFoodScores applyFurnacePower(Item food, Food foodComponent, ChestCavityEntity cce, EffectiveFoodScores efs) {
        if (food == CCItems.FURNACE_POWER.get()) {
            int power = 0;
            if (cce.getChestCavityInstance().owner.func_70644_a((Effect)CCStatusEffects.FURNACE_POWER.get())) {
                power = cce.getChestCavityInstance().owner.func_70660_b((Effect)CCStatusEffects.FURNACE_POWER.get()).func_76458_c() + 1;
            }
            efs.digestion -= cce.getChestCavityInstance().getOrganScore(CCOrganScores.HERBIVOROUS_DIGESTION);
            efs.nutrition -= cce.getChestCavityInstance().getOrganScore(CCOrganScores.HERBIVOROUS_NUTRITION);
            efs.nutrition += (float)power;
        }
        return efs;
    }
}

