/*
 * Decompiled with CFR 0.152.
 */
package net.tigereye.chestcavity.listeners;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.item.EnderCrystalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.FoodStats;
import net.tigereye.chestcavity.ChestCavity;
import net.tigereye.chestcavity.chestcavities.instance.ChestCavityInstance;
import net.tigereye.chestcavity.registration.CCDamageSource;
import net.tigereye.chestcavity.registration.CCOrganScores;
import net.tigereye.chestcavity.registration.CCStatusEffects;
import net.tigereye.chestcavity.util.CCMixinThing;
import net.tigereye.chestcavity.util.OrganUtil;

public class OrganTickListeners {
    public static void callMethods(LivingEntity entity, ChestCavityInstance cc) {
        OrganTickListeners.TickIncompatibility(entity, cc);
        OrganTickListeners.TickProjectileQueue(entity, cc);
        OrganTickListeners.TickHealth(entity, cc);
        OrganTickListeners.TickFiltration(entity, cc);
        OrganTickListeners.TickBuoyant(entity, cc);
        OrganTickListeners.TickCrystalsynthesis(entity, cc);
        OrganTickListeners.TickPhotosynthesis(entity, cc);
        OrganTickListeners.TickHydroallergenic(entity, cc);
        OrganTickListeners.TickHydrophobia(entity, cc);
        OrganTickListeners.TickGlowing(entity, cc);
    }

    public static void TickBuoyant(LivingEntity entity, ChestCavityInstance chestCavity) {
        if (entity.func_233570_aj_() || entity.func_189652_ae()) {
            return;
        }
        float buoyancy = chestCavity.getOrganScore(CCOrganScores.BUOYANT) - chestCavity.getChestCavityType().getDefaultOrganScore(CCOrganScores.BUOYANT);
        if (buoyancy != 0.0f) {
            entity.func_70024_g(0.0, (double)buoyancy * 0.02, 0.0);
        }
    }

    public static void TickCrystalsynthesis(LivingEntity entity, ChestCavityInstance cc) {
        float crystalsynthesis = cc.getOrganScore(CCOrganScores.CRYSTALSYNTHESIS);
        if (cc.connectedCrystal != null) {
            if (cc.connectedCrystal.func_70067_L()) {
                entity.func_70097_a(DamageSource.field_76366_f, crystalsynthesis * 2.0f);
                cc.connectedCrystal = null;
            } else if (crystalsynthesis != 0.0f) {
                cc.connectedCrystal.func_184516_a(((CCMixinThing)entity).getMixinBlockPos().func_177979_c(2));
            } else {
                cc.connectedCrystal.func_184516_a(null);
                cc.connectedCrystal = null;
            }
        }
        if (crystalsynthesis != 0.0f && entity.field_70170_p.func_72820_D() % (long)ChestCavity.config.CRYSTALSYNTHESIS_FREQUENCY == 0L && !(entity instanceof EnderDragonEntity)) {
            EnderCrystalEntity oldcrystal = cc.connectedCrystal;
            List list = entity.field_70170_p.func_217357_a(EnderCrystalEntity.class, entity.func_174813_aQ().func_186662_g((double)ChestCavity.config.CRYSTALSYNTHESIS_RANGE));
            EnderCrystalEntity endCrystalEntity = null;
            double d = Double.MAX_VALUE;
            for (EnderCrystalEntity endCrystalEntity2 : list) {
                double e = endCrystalEntity2.func_70068_e((Entity)entity);
                if (!(e < d)) continue;
                d = e;
                endCrystalEntity = endCrystalEntity2;
            }
            cc.connectedCrystal = endCrystalEntity;
            if (oldcrystal != null && oldcrystal != cc.connectedCrystal) {
                oldcrystal.func_184516_a(null);
            }
            if (cc.connectedCrystal != null) {
                if (entity instanceof PlayerEntity) {
                    PlayerEntity playerEntity = (PlayerEntity)entity;
                    FoodStats hungerManager = playerEntity.func_71024_bL();
                    if (hungerManager.func_75121_c()) {
                        if (crystalsynthesis >= 5.0f || (float)(entity.field_70170_p.func_72820_D() % (long)(ChestCavity.config.CRYSTALSYNTHESIS_FREQUENCY * 5)) < (float)ChestCavity.config.CRYSTALSYNTHESIS_FREQUENCY * crystalsynthesis) {
                            hungerManager.func_75122_a(1, 0.0f);
                        }
                    } else if (hungerManager.func_75115_e() < (float)hungerManager.func_75116_a()) {
                        hungerManager.func_75122_a(1, crystalsynthesis / 10.0f);
                    } else {
                        playerEntity.func_70691_i(crystalsynthesis / 5.0f);
                    }
                } else {
                    entity.func_70691_i(crystalsynthesis / 5.0f);
                }
            }
        }
    }

    public static void TickPhotosynthesis(LivingEntity entity, ChestCavityInstance cc) {
        if (entity.field_70170_p.func_201670_d()) {
            return;
        }
        float photosynthesis = cc.getOrganScore(CCOrganScores.PHOTOSYNTHESIS) - cc.getChestCavityType().getDefaultOrganScore(CCOrganScores.PHOTOSYNTHESIS);
        if (photosynthesis > 0.0f) {
            cc.photosynthesisProgress = (int)((float)cc.photosynthesisProgress + photosynthesis * (float)entity.field_70170_p.func_217298_h(((CCMixinThing)entity).getMixinBlockPos()));
            if (cc.photosynthesisProgress > ChestCavity.config.PHOTOSYNTHESIS_FREQUENCY * 8 * 15) {
                cc.photosynthesisProgress = 0;
                if (entity instanceof PlayerEntity) {
                    PlayerEntity playerEntity = (PlayerEntity)entity;
                    FoodStats hungerManager = playerEntity.func_71024_bL();
                    if (hungerManager.func_75121_c()) {
                        hungerManager.func_75122_a(1, 0.0f);
                    } else if (hungerManager.func_75115_e() < (float)hungerManager.func_75116_a()) {
                        hungerManager.func_75122_a(1, 0.5f);
                    } else {
                        playerEntity.func_70691_i(1.0f);
                    }
                } else {
                    entity.func_70691_i(1.0f);
                }
            }
        }
    }

    public static void TickHealth(LivingEntity entity, ChestCavityInstance cc) {
        if (cc.getOrganScore(CCOrganScores.HEALTH) <= 0.0f && cc.getChestCavityType().getDefaultOrganScore(CCOrganScores.HEALTH) != 0.0f) {
            if (entity.field_70170_p.func_72820_D() % (long)ChestCavity.config.HEARTBLEED_RATE == 0L) {
                ++cc.heartBleedTimer;
                entity.func_70097_a(CCDamageSource.HEARTBLEED, Math.min((float)cc.heartBleedTimer, cc.getChestCavityType().getHeartBleedCap()));
            }
        } else {
            cc.heartBleedTimer = 0;
        }
    }

    public static void TickFiltration(LivingEntity entity, ChestCavityInstance cc) {
        if (entity.field_70170_p.func_201670_d()) {
            return;
        }
        if (cc.getChestCavityType().getDefaultOrganScore(CCOrganScores.FILTRATION) <= 0.0f) {
            return;
        }
        float KidneyRatio = cc.getOrganScore(CCOrganScores.FILTRATION) / cc.getChestCavityType().getDefaultOrganScore(CCOrganScores.FILTRATION);
        if (KidneyRatio < 1.0f) {
            ++cc.bloodPoisonTimer;
            if (cc.bloodPoisonTimer >= ChestCavity.config.KIDNEY_RATE) {
                entity.func_195064_c(new EffectInstance(Effects.field_76436_u, (int)Math.max(1.0f, 48.0f * (1.0f - KidneyRatio))));
                cc.bloodPoisonTimer = 0;
            }
        }
    }

    private static void TickProjectileQueue(LivingEntity entity, ChestCavityInstance cc) {
        if (cc.projectileCooldown > 0) {
            --cc.projectileCooldown;
            return;
        }
        if (!cc.projectileQueue.isEmpty()) {
            cc.projectileCooldown = 5;
            cc.projectileQueue.pop().accept(entity);
        }
    }

    private static void TickHydroallergenic(LivingEntity entity, ChestCavityInstance cc) {
        if (entity.field_70170_p.func_201670_d()) {
            return;
        }
        float Hydroallergy = cc.getOrganScore(CCOrganScores.HYDROALLERGENIC);
        if (Hydroallergy <= 0.0f) {
            return;
        }
        if (entity.func_70090_H()) {
            if (!entity.func_70644_a((Effect)CCStatusEffects.WATER_VULNERABILITY.get())) {
                entity.func_70097_a(DamageSource.field_76376_m, 10.0f);
                entity.func_195064_c(new EffectInstance((Effect)CCStatusEffects.WATER_VULNERABILITY.get(), (int)(260.0f / Hydroallergy), 0, false, false, true));
            }
        } else if (entity.func_70026_G() && !entity.func_70644_a((Effect)CCStatusEffects.WATER_VULNERABILITY.get())) {
            entity.func_70097_a(DamageSource.field_76376_m, 1.0f);
            entity.func_195064_c(new EffectInstance((Effect)CCStatusEffects.WATER_VULNERABILITY.get(), (int)(260.0f / Hydroallergy), 0, false, false, true));
        }
    }

    public static void TickHydrophobia(LivingEntity entity, ChestCavityInstance cc) {
        float hydrophobia = cc.getOrganScore(CCOrganScores.HYDROPHOBIA);
        if (hydrophobia <= 0.0f || cc.getChestCavityType().getDefaultOrganScore(CCOrganScores.HYDROPHOBIA) != 0.0f) {
            return;
        }
        if (entity.func_70026_G()) {
            OrganUtil.teleportRandomly(entity, hydrophobia * 32.0f);
        }
    }

    public static void TickIncompatibility(LivingEntity entity, ChestCavityInstance chestCavity) {
        if (entity.field_70170_p.func_201670_d() || ChestCavity.config.DISABLE_ORGAN_REJECTION) {
            return;
        }
        float incompatibility = chestCavity.getOrganScore(CCOrganScores.INCOMPATIBILITY);
        if (incompatibility > 0.0f && !entity.func_70644_a((Effect)CCStatusEffects.ORGAN_REJECTION.get())) {
            entity.func_195064_c(new EffectInstance((Effect)CCStatusEffects.ORGAN_REJECTION.get(), (int)((float)ChestCavity.config.ORGAN_REJECTION_RATE / incompatibility), 0, false, true, true));
        }
    }

    public static void TickGlowing(LivingEntity entity, ChestCavityInstance chestCavity) {
        if (entity.field_70170_p.func_201670_d()) {
            return;
        }
        float glowing = chestCavity.getOrganScore(CCOrganScores.GLOWING);
        if (glowing > 0.0f && !entity.func_70644_a(Effects.field_188423_x)) {
            entity.func_195064_c(new EffectInstance(Effects.field_188423_x, 200, 0, false, true, true));
        }
    }
}

