/*
 * Decompiled with CFR 0.152.
 */
package net.tigereye.chestcavity.mixin;

import java.util.Optional;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.boss.dragon.EnderDragonPartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.tigereye.chestcavity.ChestCavity;
import net.tigereye.chestcavity.interfaces.ChestCavityEntity;
import net.tigereye.chestcavity.registration.CCOrganScores;
import net.tigereye.chestcavity.util.CCMixinThing;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class MixinEntity
implements CCMixinThing {
    @Shadow
    protected abstract BlockPos func_226268_ag_();

    @Override
    public BlockPos getMixinBlockPos() {
        return this.func_226268_ag_();
    }

    @ModifyVariable(at=@At(value="HEAD"), ordinal=0, method={"checkFallDamage"})
    public double chestCavityEntityFallMixin(double finalHeightDifference, double heightDifference, boolean onGround, BlockState landedState, BlockPos landedPosition) {
        Optional<ChestCavityEntity> cce;
        if (heightDifference < 0.0 && (cce = ChestCavityEntity.of((Entity)this)).isPresent()) {
            finalHeightDifference = heightDifference * (double)(1.0f - cce.get().getChestCavityInstance().getOrganScore(CCOrganScores.BUOYANT) / 3.0f);
        }
        return finalHeightDifference;
    }

    @Inject(at={@At(value="RETURN")}, method={"interact"}, cancellable=true)
    public void chestCavityEntityInteractMixin(PlayerEntity player, Hand hand, CallbackInfoReturnable<ActionResultType> info) {
        if (info.getReturnValue() == ActionResultType.PASS && (Entity)this instanceof EnderDragonPartEntity) {
            ChestCavity.LOGGER.info("Attempting to open dragon's " + ((EnderDragonPartEntity)this).field_213853_c);
            EnderDragonEntity dragon = ((EnderDragonPartEntity)this).field_213852_b;
            if (dragon != null) {
                ChestCavity.LOGGER.info("Dragon was not null");
                info.setReturnValue((Object)dragon.func_184230_a(player, hand));
            }
        }
    }
}

