/*
 * Decompiled with CFR 0.152.
 */
package net.tigereye.chestcavity.mixin;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.tigereye.chestcavity.interfaces.ChestCavityEntity;
import net.tigereye.chestcavity.listeners.EffectiveFoodScores;
import net.tigereye.chestcavity.listeners.OrganFoodCallback;
import net.tigereye.chestcavity.registration.CCOrganScores;
import net.tigereye.chestcavity.util.ChestCavityUtil;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.invoke.arg.Args;

public class MixinHungerManager {
    private int tickTimer;
    private int foodLevel;
    private float saturationLevel;
    private float exhaustionLevel;
    private ChestCavityEntity CC_player = null;

    public void chestCavityUpdateMixin(PlayerEntity player, CallbackInfo ci) {
        System.out.println("CHESTCAVITY TEST UPDATE MIXIN CALLED");
        if (this.CC_player == null) {
            System.out.println("PLAYER WAS NULL");
            ChestCavityEntity.of((Entity)player).ifPresent(ccPlayerEntityInterface -> {
                this.CC_player = ccPlayerEntityInterface;
            });
        }
        this.tickTimer = ChestCavityUtil.applySpleenMetabolism(this.CC_player.getChestCavityInstance(), this.tickTimer);
        System.out.println("CHESTCAVITY ENDED");
    }

    public void chestCavityEatMixin(Args args, Item item, ItemStack stack) {
        Food itemFoodComponent;
        if (item.func_219971_r() && this.CC_player != null && (itemFoodComponent = item.func_219967_s()) != null) {
            EffectiveFoodScores efs = new EffectiveFoodScores(this.CC_player.getChestCavityInstance().getOrganScore(CCOrganScores.DIGESTION), this.CC_player.getChestCavityInstance().getOrganScore(CCOrganScores.NUTRITION));
            efs = OrganFoodCallback.addFoodListener(item, itemFoodComponent, this.CC_player, efs);
            float saturationGain = ChestCavityUtil.applyNutrition(this.CC_player.getChestCavityInstance(), efs.nutrition, item.func_219967_s().func_221469_b()) * (float)item.func_219967_s().func_221466_a() * 2.0f;
            int hungerGain = ChestCavityUtil.applyDigestion(this.CC_player.getChestCavityInstance(), efs.digestion, item.func_219967_s().func_221466_a());
            float newSaturation = saturationGain / (float)(hungerGain * 2);
            args.set(0, (Object)hungerGain);
            args.set(1, (Object)Float.valueOf(newSaturation));
        }
    }

    public float chestCavityAddExhaustionMixin(float exhaustion) {
        if (this.CC_player != null) {
            float enduranceDif;
            if (this.exhaustionLevel != this.exhaustionLevel) {
                this.exhaustionLevel = 0.0f;
            }
            float out = (enduranceDif = this.CC_player.getChestCavityInstance().getOrganScore(CCOrganScores.ENDURANCE) - this.CC_player.getChestCavityInstance().getChestCavityType().getDefaultOrganScore(CCOrganScores.ENDURANCE)) > 0.0f ? exhaustion / (1.0f + enduranceDif / 2.0f) : exhaustion * (1.0f - enduranceDif / 2.0f);
            return out;
        }
        return exhaustion;
    }
}

