/*
 * Decompiled with CFR 0.152.
 */
package net.tigereye.chestcavity.mixin;

import com.mojang.authlib.GameProfile;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.boss.WitherEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.CowEntity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.ITeleporter;
import net.tigereye.chestcavity.ChestCavity;
import net.tigereye.chestcavity.chestcavities.instance.ChestCavityInstance;
import net.tigereye.chestcavity.chestcavities.instance.ChestCavityInstanceFactory;
import net.tigereye.chestcavity.interfaces.ChestCavityEntity;
import net.tigereye.chestcavity.items.ChestOpener;
import net.tigereye.chestcavity.listeners.LootRegister;
import net.tigereye.chestcavity.registration.CCItems;
import net.tigereye.chestcavity.registration.CCOrganScores;
import net.tigereye.chestcavity.util.ChestCavityUtil;
import net.tigereye.chestcavity.util.NetworkUtil;
import net.tigereye.chestcavity.util.OrganUtil;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class}, priority=900)
public class MixinLivingEntity
extends Entity
implements ChestCavityEntity {
    private ChestCavityInstance chestCavityInstance;

    protected MixinLivingEntity(EntityType<? extends LivingEntity> entityType, World world) {
        super(entityType, world);
    }

    @Inject(at={@At(value="TAIL")}, method={"<init>"})
    public void chestCavityLivingEntityConstructorMixin(EntityType<? extends LivingEntity> entityType, World world, CallbackInfo info) {
        this.chestCavityInstance = ChestCavityInstanceFactory.newChestCavityInstance(entityType, (LivingEntity)this);
        ChestCavity.printOnDebug("CHESTCAVITY LIVINGENTITY MIXIN <init> RAN!");
    }

    @Inject(at={@At(value="HEAD")}, method={"baseTick"})
    public void chestCavityLivingEntityBaseTickMixin(CallbackInfo info) {
        ChestCavityUtil.onTick(this.chestCavityInstance);
    }

    @Inject(at={@At(value="TAIL")}, method={"baseTick"})
    protected void chestCavityLivingEntityBaseTickBreathAirMixin(CallbackInfo info) {
        if (!this.func_208600_a((ITag)FluidTags.field_206959_a) || this.field_70170_p.func_180495_p(new BlockPos(this.func_226277_ct_(), this.func_226280_cw_(), this.func_226281_cx_())).func_203425_a(Blocks.field_203203_C)) {
            this.func_70050_g(ChestCavityUtil.applyBreathOnLand(this.chestCavityInstance, this.func_70086_ai(), this.func_207300_l(0)));
        }
    }

    @ModifyVariable(at=@At(value="CONSTANT", args={"floatValue=0.0F"}, ordinal=0), ordinal=0, method={"actuallyHurt"})
    public float chestCavityLivingEntityOnHitMixin(float amount, DamageSource source) {
        Optional<ChestCavityEntity> cce;
        if (source.func_76346_g() instanceof LivingEntity && (cce = ChestCavityEntity.of(source.func_76346_g())).isPresent()) {
            amount = ChestCavityUtil.onHit(cce.get().getChestCavityInstance(), source, (LivingEntity)this, amount);
        }
        return amount;
    }

    @Inject(at={@At(value="RETURN")}, method={"createLootContext"})
    protected void addCustomLootFromEntity(boolean p_21105_, DamageSource p_21106_, CallbackInfoReturnable<LootContext.Builder> cir) {
        LootContext lootContext = ((LootContext.Builder)cir.getReturnValue()).func_216022_a(LootParameterSets.field_216263_d);
        List<ItemStack> list = LootRegister.addLoot(lootContext);
        list = LootRegister.modifyLoot(list, lootContext);
        list.forEach(arg_0 -> ((MixinLivingEntity)this).func_199701_a_(arg_0));
    }

    @Inject(at={@At(value="RETURN")}, method={"decreaseAirSupply"}, cancellable=true)
    protected void chestCavityLivingEntityGetNextAirUnderwaterMixin(int air, CallbackInfoReturnable<Integer> info) {
        info.setReturnValue((Object)ChestCavityUtil.applyBreathInWater(this.chestCavityInstance, air, info.getReturnValueI()));
    }

    @Inject(at={@At(value="RETURN")}, method={"getDamageAfterArmorAbsorb"}, cancellable=true)
    public void chestCavityLivingEntityDamageMixin(DamageSource source, float amount, CallbackInfoReturnable<Float> info) {
        info.setReturnValue((Object)Float.valueOf(ChestCavityUtil.applyDefenses(this.chestCavityInstance, source, info.getReturnValueF())));
    }

    @Inject(at={@At(value="HEAD")}, method={"dropEquipment"})
    public void chestCavityLivingEntityDropInventoryMixin(CallbackInfo info) {
        ChestCavityUtil.onDeath(this);
    }

    @ModifyVariable(at=@At(value="HEAD"), method={"addEffect"}, ordinal=0)
    public EffectInstance chestCavityLivingEntityAddStatusEffectMixin(EffectInstance effect) {
        return ChestCavityUtil.onAddStatusEffect(this.chestCavityInstance, effect);
    }

    @ModifyArg(at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;moveRelative(FLnet/minecraft/util/math/vector/Vector3d;)V"), method={"travel"}, index=0, require=0)
    protected float chestCavityLivingEntityWaterTravelMixin(float g) {
        return g * ChestCavityUtil.applySwimSpeedInWater(this.chestCavityInstance);
    }

    @Inject(at={@At(value="RETURN")}, method={"getJumpPower"}, cancellable=true)
    public void chestCavityLivingEntityJumpVelocityMixin(CallbackInfoReturnable<Float> info) {
        info.setReturnValue((Object)ChestCavityUtil.applyLeaping(this.chestCavityInstance, info.getReturnValueF()));
    }

    @Override
    public ChestCavityInstance getChestCavityInstance() {
        return this.chestCavityInstance;
    }

    @Override
    public void setChestCavityInstance(ChestCavityInstance chestCavityInstance) {
        this.chestCavityInstance = chestCavityInstance;
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void readCustomDataFromNbt(CompoundNBT tag, CallbackInfo callbackInfo) {
        this.chestCavityInstance.fromTag(tag, (LivingEntity)this);
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void writeCustomDataToNbt(CompoundNBT tag, CallbackInfo callbackInfo) {
        this.chestCavityInstance.toTag(tag);
    }

    @Shadow
    protected void func_70088_a() {
    }

    @Shadow
    protected void func_70037_a(CompoundNBT tag) {
    }

    @Shadow
    protected void func_213281_b(CompoundNBT tag) {
    }

    @Shadow
    public IPacket<?> func_213297_N() {
        return null;
    }

    @Shadow
    protected int func_207300_l(int air) {
        return 0;
    }

    @Mixin(value={WitherEntity.class})
    private static abstract class MixinWitherEntity
    extends MonsterEntity {
        protected MixinWitherEntity(EntityType<? extends MonsterEntity> entityType, World world) {
            super(entityType, world);
        }

        @Inject(method={"dropCustomDeathLoot"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/boss/WitherEntity;spawnAtLocation(Lnet/minecraft/util/IItemProvider;)Lnet/minecraft/entity/item/ItemEntity;")}, cancellable=true)
        protected void chestCavityPreventNetherStarDrop(DamageSource source, int lootingMultiplier, boolean allowDrops, CallbackInfo info) {
            Optional<ChestCavityEntity> chestCavityEntity = ChestCavityEntity.of((Entity)this);
            if (chestCavityEntity.isPresent()) {
                ChestCavityInstance cc = chestCavityEntity.get().getChestCavityInstance();
                if (cc.opened && cc.inventory.func_213901_a(Items.field_151156_bN) == 0) {
                    info.cancel();
                }
            }
        }
    }

    @Mixin(value={SheepEntity.class})
    private static abstract class MixinSheepEntity
    extends AnimalEntity {
        protected MixinSheepEntity(EntityType<? extends AnimalEntity> entityType, World world) {
            super(entityType, world);
        }

        @Inject(method={"shear"}, at={@At(value="HEAD")})
        protected void chestCavitySheared(SoundCategory shearedSoundCategory, CallbackInfo info) {
            OrganUtil.shearSilk((LivingEntity)this);
        }
    }

    @Mixin(value={ServerPlayerEntity.class})
    private static abstract class MixinServerPlayerEntity
    extends PlayerEntity {
        public MixinServerPlayerEntity(World world, BlockPos pos, float yaw, GameProfile profile) {
            super(world, pos, yaw, profile);
        }

        @Inject(method={"restoreFrom"}, at={@At(value="TAIL")})
        public void copyFrom(ServerPlayerEntity oldPlayer, boolean alive, CallbackInfo callbackInfo) {
            ChestCavity.printOnDebug("Attempting to load ChestCavityInstance");
            ChestCavityEntity.of((Entity)this).ifPresent(chestCavityEntity -> ChestCavityEntity.of((Entity)oldPlayer).ifPresent(oldCCPlayerEntityInterface -> {
                ChestCavity.printOnDebug("Copying ChestCavityInstance");
                chestCavityEntity.getChestCavityInstance().clone(oldCCPlayerEntityInterface.getChestCavityInstance());
            }));
        }

        @Inject(at={@At(value="RETURN")}, method={"changeDimension"}, cancellable=true, remap=false)
        public void chestCavityEntityMoveToWorldMixin(ServerWorld level, ITeleporter teleporter, CallbackInfoReturnable<Entity> info) {
            Entity entity = (Entity)info.getReturnValue();
            if (entity instanceof ChestCavityEntity && !entity.field_70170_p.field_72995_K) {
                NetworkUtil.SendS2CChestCavityUpdatePacket(((ChestCavityEntity)entity).getChestCavityInstance());
            }
        }
    }

    @Mixin(value={CreeperEntity.class})
    private static abstract class MixinCreeperEntity
    extends MonsterEntity {
        @Shadow
        private int field_70833_d;

        protected MixinCreeperEntity(EntityType<? extends MonsterEntity> entityType, World world) {
            super(entityType, world);
        }

        @Inject(at={@At(value="HEAD")}, method={"tick"})
        protected void chestCavityCreeperTickMixin(CallbackInfo info) {
            if (this.func_70089_S() && this.field_70833_d > 1) {
                ChestCavityEntity.of((Entity)this).ifPresent(cce -> {
                    if (cce.getChestCavityInstance().opened && cce.getChestCavityInstance().getOrganScore(CCOrganScores.CREEPY) <= 0.0f) {
                        this.field_70833_d = 1;
                    }
                });
            }
        }
    }

    @Mixin(value={CowEntity.class})
    private static abstract class MixinCowEntity
    extends AnimalEntity {
        protected MixinCowEntity(EntityType<? extends AnimalEntity> entityType, World world) {
            super(entityType, world);
        }

        @Inject(method={"mobInteract"}, at={@At(value="RETURN", ordinal=0)})
        protected void interactMob(PlayerEntity player, Hand hand, CallbackInfoReturnable<ActionResultType> info) {
            OrganUtil.milkSilk((LivingEntity)this);
        }
    }

    @Mixin(value={PlayerEntity.class})
    public static abstract class MixinPlayerEntity
    extends LivingEntity {
        protected MixinPlayerEntity(EntityType<? extends LivingEntity> entityType, World world) {
            super(entityType, world);
        }

        @ModifyVariable(at=@At(value="CONSTANT", args={"floatValue=0.0F"}, ordinal=0), ordinal=0, method={"actuallyHurt"})
        public float chestCavityPlayerEntityOnHitMixin(float amount, DamageSource source) {
            Optional<ChestCavityEntity> cce;
            if (source.func_76346_g() instanceof LivingEntity && (cce = ChestCavityEntity.of(source.func_76346_g())).isPresent()) {
                amount = ChestCavityUtil.onHit(cce.get().getChestCavityInstance(), source, this, amount);
            }
            return amount;
        }

        @Inject(at={@At(value="HEAD")}, method={"interactOn"}, cancellable=true)
        void chestCavityPlayerEntityInteractPlayerMixin(Entity entity, Hand hand, CallbackInfoReturnable<ActionResultType> info) {
            PlayerEntity player;
            ItemStack stack;
            ChestCavity.printOnDebug("InteractOn Mixin Called! entity instanceof LivingEntity: " + (entity instanceof LivingEntity) + ". Entity.toString(): " + entity.toString());
            if (entity instanceof LivingEntity && ChestCavity.config.CAN_OPEN_OTHER_PLAYERS && (stack = (player = (PlayerEntity)this).func_184586_b(hand)).func_77973_b() == CCItems.CHEST_OPENER.get()) {
                ((ChestOpener)stack.func_77973_b()).openChestCavity(player, (LivingEntity)entity);
                info.setReturnValue((Object)ActionResultType.SUCCESS);
                info.cancel();
            }
        }

        @Inject(at={@At(value="RETURN")}, method={"getDigSpeed"}, cancellable=true, remap=false)
        void chestCavityPlayerEntityGetBlockBreakingSpeedMixin(BlockState block, @Nullable BlockPos pos, CallbackInfoReturnable<Float> cir) {
            cir.setReturnValue((Object)Float.valueOf(ChestCavityUtil.applyNervesToMining(((ChestCavityEntity)((Object)this)).getChestCavityInstance(), ((Float)cir.getReturnValue()).floatValue())));
        }
    }

    @Mixin(value={MobEntity.class})
    private static abstract class MixinMobEntity
    extends LivingEntity {
        protected MixinMobEntity(EntityType<? extends LivingEntity> entityType, World world) {
            super(entityType, world);
        }

        @Inject(at={@At(value="HEAD")}, method={"checkAndHandleImportantInteractions"}, cancellable=true)
        protected void chestCavityLivingEntityInteractMobMixin(PlayerEntity player, Hand hand, CallbackInfoReturnable<ActionResultType> info) {
            ChestCavity.printOnDebug("checkAndHandleImportantInteractions called for: " + this.toString());
            if (player.func_184586_b(hand).func_77973_b() == CCItems.CHEST_OPENER.get() && !((LivingEntity)this instanceof PlayerEntity)) {
                ((ChestOpener)player.func_184586_b(hand).func_77973_b()).openChestCavity(player, this);
                ChestCavity.printOnDebug("Opened Cavity from checkAndHandleImportantInteractions. this: " + ((LivingEntity)this).toString());
                info.setReturnValue((Object)ActionResultType.SUCCESS);
            }
        }
    }
}

