/*
 * Decompiled with CFR 0.152.
 */
package net.tigereye.chestcavity.network.packets;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;
import net.tigereye.chestcavity.interfaces.ChestCavityEntity;
import net.tigereye.chestcavity.listeners.OrganActivationListeners;

public class ChestCavityHotkeyPacket {
    ResourceLocation location;

    public ChestCavityHotkeyPacket(ResourceLocation location) {
        this.location = location;
    }

    public ChestCavityHotkeyPacket(PacketBuffer buf) {
        this(buf.func_192575_l());
    }

    public void encode(PacketBuffer buf) {
        buf.func_192572_a(this.location);
    }

    public boolean handle(Supplier<NetworkEvent.Context> contextSupplier) {
        AtomicBoolean success = new AtomicBoolean(false);
        contextSupplier.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)contextSupplier.get()).getSender();
            Optional<ChestCavityEntity> optional = ChestCavityEntity.of((Entity)player);
            optional.ifPresent(chestCavityEntity -> {
                OrganActivationListeners.activate(this.location, chestCavityEntity.getChestCavityInstance());
                success.set(true);
            });
        });
        contextSupplier.get().setPacketHandled(true);
        return success.get();
    }
}

