/*
 * Decompiled with CFR 0.152.
 */
package net.tigereye.chestcavity.network.packets;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;
import net.tigereye.chestcavity.chestcavities.instance.ChestCavityInstance;
import net.tigereye.chestcavity.interfaces.ChestCavityEntity;

public class ChestCavityUpdatePacket {
    private final boolean open;
    private final int size;
    private final Map<ResourceLocation, Float> organScoresMap;

    public ChestCavityUpdatePacket(boolean open, int size, Map<ResourceLocation, Float> organScoresMap) {
        this.open = open;
        this.size = size;
        this.organScoresMap = organScoresMap;
    }

    public static ChestCavityUpdatePacket decode(PacketBuffer buf) {
        boolean open = buf.readBoolean();
        int size = buf.readInt();
        HashMap<ResourceLocation, Float> organScores = new HashMap<ResourceLocation, Float>();
        for (int i = 0; i < size; ++i) {
            organScores.put(new ResourceLocation(buf.func_218666_n()), Float.valueOf(buf.readFloat()));
        }
        return new ChestCavityUpdatePacket(open, size, organScores);
    }

    public void encode(PacketBuffer buf) {
        buf.writeBoolean(this.open);
        buf.writeInt(this.size);
        this.organScoresMap.forEach((id, value) -> {
            buf.func_180714_a(id.toString());
            buf.writeFloat(value.floatValue());
        });
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        AtomicBoolean success = new AtomicBoolean(false);
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            Optional<ChestCavityEntity> optional = ChestCavityEntity.of(Minecraft.func_71410_x().field_175622_Z);
            optional.ifPresent(chestCavityEntity -> {
                ChestCavityInstance instance = chestCavityEntity.getChestCavityInstance();
                instance.opened = this.open;
                instance.setOrganScores(this.organScoresMap);
                success.set(true);
            });
        }));
        ctx.get().setPacketHandled(true);
        return success.get();
    }
}

