/*
 * Decompiled with CFR 0.152.
 */
package net.tigereye.chestcavity.recipes;

import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.tigereye.chestcavity.registration.CCRecipes;

public class SalvageRecipe
implements ICraftingRecipe {
    private final Ingredient input;
    private int required;
    private final ItemStack outputStack;
    private final ResourceLocation id;

    public SalvageRecipe(Ingredient input, int required, ItemStack outputStack, ResourceLocation id) {
        this.input = input;
        this.required = required;
        this.outputStack = outputStack;
        this.id = id;
    }

    public Ingredient getInput() {
        return this.input;
    }

    public int getRequired() {
        return this.required;
    }

    public NonNullList<Ingredient> func_192400_c() {
        return NonNullList.func_191197_a((int)this.required, (Object)this.input);
    }

    public boolean matches(CraftingInventory inv, World world) {
        int count = 0;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack target = inv.func_70301_a(i);
            if (target == null || target == ItemStack.field_190927_a || target.func_77973_b() == Items.field_190931_a) continue;
            if (this.input.test(inv.func_70301_a(i))) {
                ++count;
                continue;
            }
            return false;
        }
        return count > 0 && count % this.required == 0;
    }

    public ItemStack assemble(CraftingInventory inv) {
        int count = 0;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack target = inv.func_70301_a(i);
            if (target == null || target == ItemStack.field_190927_a || target.func_77973_b() == Items.field_190931_a) continue;
            if (this.input.test(inv.func_70301_a(i))) {
                ++count;
                continue;
            }
            return ItemStack.field_190927_a;
        }
        if (count == 0 || count % this.required != 0) {
            return ItemStack.field_190927_a;
        }
        if ((count = count / this.required * this.outputStack.func_190916_E()) > this.outputStack.func_77976_d()) {
            return ItemStack.field_190927_a;
        }
        ItemStack out = this.func_77571_b();
        out.func_190920_e(count);
        return out;
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public ItemStack func_77571_b() {
        return this.outputStack.func_77946_l();
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)CCRecipes.SALVAGE_RECIPE_SERIALIZER.get();
    }
}

