/*
 * Decompiled with CFR 0.152.
 */
package net.tigereye.chestcavity.recipes.json;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.tigereye.chestcavity.recipes.SalvageRecipe;
import net.tigereye.chestcavity.recipes.json.SalvageRecipeJsonFormat;
import net.tigereye.chestcavity.registration.CCRecipes;

public class SalvageRecipeSerializer
implements IRecipeSerializer<SalvageRecipe> {
    public SalvageRecipe fromJson(ResourceLocation id, JsonObject json) {
        SalvageRecipeJsonFormat recipeJson = (SalvageRecipeJsonFormat)new Gson().fromJson((JsonElement)json, SalvageRecipeJsonFormat.class);
        if (recipeJson.ingredient == null || recipeJson.result == null) {
            throw new JsonSyntaxException("A required attribute is missing!");
        }
        if (recipeJson.required == 0) {
            recipeJson.required = 1;
        }
        if (recipeJson.count == 0) {
            recipeJson.count = 1;
        }
        Ingredient input = Ingredient.func_199802_a((JsonElement)recipeJson.ingredient);
        Item outputItem = (Item)Registry.field_212630_s.func_241873_b(new ResourceLocation(recipeJson.result)).orElseThrow(() -> new JsonSyntaxException("No such item " + recipeJson.result));
        ItemStack output = new ItemStack((IItemProvider)outputItem, recipeJson.count);
        return new SalvageRecipe(input, recipeJson.required, output, id);
    }

    public SalvageRecipe fromNetwork(ResourceLocation id, PacketBuffer buf) {
        Ingredient input = Ingredient.func_199566_b((PacketBuffer)buf);
        int required = buf.readInt();
        ItemStack output = buf.func_150791_c();
        return new SalvageRecipe(input, required, output, id);
    }

    public void toNetwork(PacketBuffer buf, SalvageRecipe recipe) {
        recipe.getInput().func_199564_a(buf);
        buf.writeInt(recipe.getRequired());
        buf.func_150788_a(recipe.func_77571_b());
    }

    public IRecipeSerializer<?> setRegistryName(ResourceLocation name) {
        return this;
    }

    public ResourceLocation getRegistryName() {
        return CCRecipes.SALVAGE_RECIPE_ID;
    }

    public Class<IRecipeSerializer<?>> getRegistryType() {
        return SalvageRecipeSerializer.castClass(IRecipeSerializer.class);
    }

    private static <G> Class<G> castClass(Class<?> cls) {
        return cls;
    }
}

