/*
 * Decompiled with CFR 0.152.
 */
package net.tigereye.chestcavity.registration;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Optional;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.Entity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.tigereye.chestcavity.interfaces.ChestCavityEntity;
import net.tigereye.chestcavity.util.ChestCavityUtil;

@Mod.EventBusSubscriber(modid="chestcavity")
public class CCCommands {
    @SubscribeEvent
    public static void registerCommand(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)Commands.func_197057_a((String)"chestcavity").then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"getscores").executes(CCCommands::getScoresNoArgs)).then(Commands.func_197056_a((String)"entity", (ArgumentType)EntityArgument.func_197086_a()).executes(CCCommands::getScores))));
        dispatcher.register((LiteralArgumentBuilder)Commands.func_197057_a((String)"chestcavity").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"resetChestCavity").requires(source -> source.func_197034_c(2))).executes(CCCommands::resetChestCavityNoArgs)).then(Commands.func_197056_a((String)"entity", (ArgumentType)EntityArgument.func_197086_a()).executes(CCCommands::resetChestCavity))));
    }

    private static int getScoresNoArgs(CommandContext<CommandSource> context) {
        Entity entity;
        try {
            entity = ((CommandSource)context.getSource()).func_197027_g();
        }
        catch (Exception e) {
            ((CommandSource)context.getSource()).func_197021_a((ITextComponent)new StringTextComponent("getScores failed to get entity"));
            return -1;
        }
        Optional<ChestCavityEntity> optional = ChestCavityEntity.of(entity);
        if (optional.isPresent()) {
            ChestCavityUtil.outputOrganScoresString(string -> ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent(string), false), optional.get().getChestCavityInstance());
            return 1;
        }
        return 0;
    }

    private static int getScores(CommandContext<CommandSource> context) {
        Entity entity;
        try {
            entity = EntityArgument.func_197088_a(context, (String)"entity");
        }
        catch (Exception e) {
            ((CommandSource)context.getSource()).func_197021_a((ITextComponent)new StringTextComponent("getScores failed to get entity"));
            return -1;
        }
        Optional<ChestCavityEntity> optional = ChestCavityEntity.of(entity);
        if (optional.isPresent()) {
            ChestCavityUtil.outputOrganScoresString(string -> ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent(string), false), optional.get().getChestCavityInstance());
            return 1;
        }
        return 0;
    }

    private static int resetChestCavityNoArgs(CommandContext<CommandSource> context) {
        Entity entity;
        try {
            entity = ((CommandSource)context.getSource()).func_197027_g();
        }
        catch (Exception e) {
            ((CommandSource)context.getSource()).func_197021_a((ITextComponent)new StringTextComponent("resetChestCavity failed to get entity"));
            return -1;
        }
        Optional<ChestCavityEntity> optional = ChestCavityEntity.of(entity);
        if (optional.isPresent()) {
            ChestCavityUtil.generateChestCavityIfOpened(optional.get().getChestCavityInstance());
            return 1;
        }
        return 0;
    }

    private static int resetChestCavity(CommandContext<CommandSource> context) {
        Entity entity;
        try {
            entity = EntityArgument.func_197088_a(context, (String)"entity");
        }
        catch (Exception e) {
            ((CommandSource)context.getSource()).func_197021_a((ITextComponent)new StringTextComponent("getChestCavity failed to get entity"));
            return -1;
        }
        Optional<ChestCavityEntity> optional = ChestCavityEntity.of(entity);
        if (optional.isPresent()) {
            ChestCavityUtil.generateChestCavityIfOpened(optional.get().getChestCavityInstance());
            return 1;
        }
        return 0;
    }
}

