/*
 * Decompiled with CFR 0.152.
 */
package net.tigereye.chestcavity.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.PotionEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.GameRules;
import net.tigereye.chestcavity.ChestCavity;
import net.tigereye.chestcavity.chestcavities.ChestCavityInventory;
import net.tigereye.chestcavity.chestcavities.ChestCavityType;
import net.tigereye.chestcavity.chestcavities.instance.ChestCavityInstance;
import net.tigereye.chestcavity.chestcavities.organs.OrganData;
import net.tigereye.chestcavity.chestcavities.organs.OrganManager;
import net.tigereye.chestcavity.interfaces.ChestCavityEntity;
import net.tigereye.chestcavity.listeners.OrganAddStatusEffectCallback;
import net.tigereye.chestcavity.listeners.OrganOnHitContext;
import net.tigereye.chestcavity.listeners.OrganOnHitListener;
import net.tigereye.chestcavity.listeners.OrganTickCallback;
import net.tigereye.chestcavity.listeners.OrganUpdateCallback;
import net.tigereye.chestcavity.registration.CCEnchantments;
import net.tigereye.chestcavity.registration.CCItems;
import net.tigereye.chestcavity.registration.CCOrganScores;
import net.tigereye.chestcavity.registration.CCStatusEffects;
import net.tigereye.chestcavity.registration.CCTagOrgans;
import net.tigereye.chestcavity.util.NetworkUtil;
import net.tigereye.chestcavity.util.OrganUtil;

public class ChestCavityUtil {
    public static void addOrganScore(ResourceLocation id, float value, Map<ResourceLocation, Float> organScores) {
        organScores.put(id, Float.valueOf(organScores.getOrDefault(id, Float.valueOf(0.0f)).floatValue() + value));
    }

    public static float applyBoneDefense(ChestCavityInstance cc, float damage) {
        float boneDiff = (cc.getOrganScore(CCOrganScores.DEFENSE) - cc.getChestCavityType().getDefaultOrganScore(CCOrganScores.DEFENSE)) / 4.0f;
        return (float)((double)damage * Math.pow(1.0f - ChestCavity.config.BONE_DEFENSE, boneDiff));
    }

    public static int applyBreathInWater(ChestCavityInstance cc, int oldAir, int newAir) {
        if (!cc.opened || cc.getChestCavityType().getDefaultOrganScore(CCOrganScores.BREATH_CAPACITY) == cc.getOrganScore(CCOrganScores.BREATH_CAPACITY) && cc.getChestCavityType().getDefaultOrganScore(CCOrganScores.WATERBREATH) == cc.getOrganScore(CCOrganScores.WATERBREATH)) {
            return newAir;
        }
        float airLoss = 1.0f;
        float waterBreath = cc.getOrganScore(CCOrganScores.WATERBREATH);
        if (cc.owner.func_70051_ag()) {
            waterBreath /= 4.0f;
        }
        if (waterBreath > 0.0f) {
            airLoss += -2.0f * waterBreath;
        }
        if (airLoss > 0.0f) {
            if (oldAir == newAir) {
                airLoss = 0.0f;
            } else {
                float capacity = cc.getOrganScore(CCOrganScores.BREATH_CAPACITY);
                if ((airLoss *= (float)(oldAir - newAir)) > 0.0f) {
                    float lungRatio = 20.0f;
                    if (capacity != 0.0f) {
                        lungRatio = Math.min(2.0f / capacity, 20.0f);
                    }
                    airLoss = airLoss * lungRatio + cc.lungRemainder;
                }
            }
        }
        cc.lungRemainder = airLoss % 1.0f;
        int airResult = Math.min(oldAir - (int)airLoss, cc.owner.func_205010_bg());
        if (airResult <= -20) {
            airResult = 0;
            cc.lungRemainder = 0.0f;
            cc.owner.func_70097_a(DamageSource.field_76369_e, 2.0f);
        }
        return airResult;
    }

    public static int applyBreathOnLand(ChestCavityInstance cc, int oldAir, int airGain) {
        if (!cc.opened || cc.getChestCavityType().getDefaultOrganScore(CCOrganScores.BREATH_RECOVERY) == cc.getOrganScore(CCOrganScores.BREATH_RECOVERY) && cc.getChestCavityType().getDefaultOrganScore(CCOrganScores.BREATH_CAPACITY) == cc.getOrganScore(CCOrganScores.BREATH_CAPACITY) && cc.getChestCavityType().getDefaultOrganScore(CCOrganScores.WATERBREATH) == cc.getOrganScore(CCOrganScores.WATERBREATH)) {
            return oldAir;
        }
        float airLoss = cc.owner.func_70644_a(Effects.field_76427_o) || cc.owner.func_70644_a(Effects.field_205136_C) ? 0.0f : 1.0f;
        float breath = cc.getOrganScore(CCOrganScores.BREATH_RECOVERY);
        if (cc.owner.func_70051_ag()) {
            breath /= 4.0f;
        }
        if (cc.owner.func_70026_G()) {
            breath += cc.getOrganScore(CCOrganScores.WATERBREATH) / 4.0f;
        }
        if (breath > 0.0f) {
            airLoss += (float)(-airGain) * breath / 2.0f;
        }
        if (airLoss > 0.0f) {
            int resperation = EnchantmentHelper.func_185292_c((LivingEntity)cc.owner);
            if (cc.owner.func_70681_au().nextInt(resperation + 1) != 0) {
                airLoss = 0.0f;
            } else {
                float capacity = cc.getOrganScore(CCOrganScores.BREATH_CAPACITY);
                float breathRatio = 20.0f;
                if (capacity != 0.0f) {
                    breathRatio = Math.min(2.0f / capacity, 20.0f);
                }
                airLoss = airLoss * breathRatio + cc.lungRemainder;
            }
        } else if (oldAir == cc.owner.func_205010_bg()) {
            return oldAir;
        }
        cc.lungRemainder = airLoss % 1.0f;
        int airResult = Math.min(oldAir - (int)airLoss - airGain, cc.owner.func_205010_bg());
        if (airResult <= -20) {
            airResult = 0;
            cc.lungRemainder = 0.0f;
            cc.owner.func_70097_a(DamageSource.field_76369_e, 2.0f);
        }
        return airResult;
    }

    public static float applyDefenses(ChestCavityInstance cc, DamageSource source, float damage) {
        if (!cc.opened) {
            return damage;
        }
        if (ChestCavityUtil.attemptArrowDodging(cc, source)) {
            return 0.0f;
        }
        if (!source.func_76363_c()) {
            damage = ChestCavityUtil.applyBoneDefense(cc, damage);
        }
        if (source == DamageSource.field_76379_h) {
            damage = ChestCavityUtil.applyLeapingToFallDamage(cc, damage);
        }
        if (source == DamageSource.field_76379_h || source == DamageSource.field_188406_j) {
            damage = ChestCavityUtil.applyImpactResistant(cc, damage);
        }
        if (source.func_76347_k()) {
            damage = ChestCavityUtil.applyFireResistant(cc, damage);
        }
        return damage;
    }

    public static int applyDigestion(ChestCavityInstance cc, float digestion, int hunger) {
        if (digestion == 1.0f) {
            return hunger;
        }
        if (digestion < 0.0f) {
            cc.owner.func_195064_c(new EffectInstance(Effects.field_76431_k, (int)((float)(-hunger) * digestion * 400.0f)));
            return 0;
        }
        return Math.max((int)((float)hunger * digestion), 1);
    }

    public static float applyFireResistant(ChestCavityInstance cc, float damage) {
        float fireproof = cc.getOrganScore(CCOrganScores.FIRE_RESISTANT);
        if (fireproof > 0.0f) {
            return (float)((double)damage * Math.pow(1.0f - ChestCavity.config.FIREPROOF_DEFENSE, fireproof / 4.0f));
        }
        return damage;
    }

    public static float applyImpactResistant(ChestCavityInstance cc, float damage) {
        float impactResistant = cc.getOrganScore(CCOrganScores.IMPACT_RESISTANT);
        if (impactResistant > 0.0f) {
            return (float)((double)damage * Math.pow(1.0f - ChestCavity.config.IMPACT_DEFENSE, impactResistant / 4.0f));
        }
        return damage;
    }

    public static Float applyLeaping(ChestCavityInstance cc, float velocity) {
        float leaping = cc.getOrganScore(CCOrganScores.LEAPING);
        float defaultLeaping = cc.getChestCavityType().getDefaultOrganScore(CCOrganScores.LEAPING);
        return Float.valueOf(velocity * Math.max(0.0f, 1.0f + (leaping - defaultLeaping) * 0.25f));
    }

    public static float applyLeapingToFallDamage(ChestCavityInstance cc, float damage) {
        float leapingDiff = cc.getOrganScore(CCOrganScores.LEAPING) - cc.getChestCavityType().getDefaultOrganScore(CCOrganScores.LEAPING);
        if (leapingDiff > 0.0f) {
            return Math.max(0.0f, damage - leapingDiff * leapingDiff / 4.0f);
        }
        return damage;
    }

    public static float applyNutrition(ChestCavityInstance cc, float nutrition, float saturation) {
        if (nutrition == 4.0f) {
            return saturation;
        }
        if (nutrition < 0.0f) {
            cc.owner.func_195064_c(new EffectInstance(Effects.field_76438_s, (int)(saturation * nutrition * 800.0f)));
            return 0.0f;
        }
        return saturation * nutrition / 4.0f;
    }

    public static float applyNervesToMining(ChestCavityInstance cc, float miningProgress) {
        float defaultNerves = cc.getChestCavityType().getDefaultOrganScore(CCOrganScores.NERVES);
        if (defaultNerves == 0.0f) {
            return miningProgress;
        }
        float NervesDiff = cc.getOrganScore(CCOrganScores.NERVES) - cc.getChestCavityType().getDefaultOrganScore(CCOrganScores.NERVES);
        return miningProgress * (1.0f + ChestCavity.config.NERVES_HASTE * NervesDiff);
    }

    public static int applySpleenMetabolism(ChestCavityInstance cc, int foodStarvationTimer) {
        if (!cc.opened) {
            return foodStarvationTimer;
        }
        float metabolismDiff = cc.getOrganScore(CCOrganScores.METABOLISM) - cc.getChestCavityType().getDefaultOrganScore(CCOrganScores.METABOLISM);
        if (metabolismDiff == 0.0f) {
            return foodStarvationTimer;
        }
        if (metabolismDiff > 0.0f) {
            cc.metabolismRemainder += metabolismDiff;
            foodStarvationTimer += (int)cc.metabolismRemainder;
        } else {
            cc.metabolismRemainder += 1.0f - 1.0f / (-metabolismDiff + 1.0f);
            foodStarvationTimer -= (int)cc.metabolismRemainder;
        }
        cc.metabolismRemainder %= 1.0f;
        return foodStarvationTimer;
    }

    public static float applySwimSpeedInWater(ChestCavityInstance cc) {
        if (!cc.opened || !cc.owner.func_70090_H()) {
            return 1.0f;
        }
        float speedDiff = cc.getOrganScore(CCOrganScores.SWIM_SPEED) - cc.getChestCavityType().getDefaultOrganScore(CCOrganScores.SWIM_SPEED);
        if (speedDiff == 0.0f) {
            return 1.0f;
        }
        return Math.max(0.0f, 1.0f + speedDiff * ChestCavity.config.SWIMSPEED_FACTOR / 8.0f);
    }

    public static boolean attemptArrowDodging(ChestCavityInstance cc, DamageSource source) {
        float dodge = cc.getOrganScore(CCOrganScores.ARROW_DODGING);
        if (dodge == 0.0f) {
            return false;
        }
        if (cc.owner.func_70644_a((Effect)CCStatusEffects.ARROW_DODGE_COOLDOWN.get())) {
            return false;
        }
        if (!(source instanceof IndirectEntityDamageSource)) {
            return false;
        }
        if (!OrganUtil.teleportRandomly(cc.owner, (float)ChestCavity.config.ARROW_DODGE_DISTANCE / dodge)) {
            return false;
        }
        cc.owner.func_195064_c(new EffectInstance((Effect)CCStatusEffects.ARROW_DODGE_COOLDOWN.get(), (int)((float)ChestCavity.config.ARROW_DODGE_COOLDOWN / dodge), 0, false, false, true));
        return true;
    }

    public static void clearForbiddenSlots(ChestCavityInstance cc) {
        try {
            cc.inventory.func_110132_b(cc);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        for (int i = 0; i < cc.inventory.func_70302_i_(); ++i) {
            if (!cc.getChestCavityType().isSlotForbidden(i)) continue;
            cc.owner.func_199701_a_(cc.inventory.func_70304_b(i));
        }
        cc.inventory.func_110134_a(cc);
    }

    public static void destroyOrgansWithKey(ChestCavityInstance cc, ResourceLocation organ) {
        for (int i = 0; i < cc.inventory.func_70302_i_(); ++i) {
            OrganData organData;
            ItemStack slot = cc.inventory.func_70301_a(i);
            if (slot == null || slot == ItemStack.field_190927_a || (organData = ChestCavityUtil.lookupOrgan(slot, cc.getChestCavityType())) == null || !organData.organScores.containsKey(organ)) continue;
            cc.inventory.func_70304_b(i);
        }
        cc.inventory.func_70296_d();
    }

    public static boolean determineDefaultOrganScores(ChestCavityType chestCavityType) {
        Map<ResourceLocation, Float> organScores = chestCavityType.getDefaultOrganScores();
        chestCavityType.loadBaseOrganScores(organScores);
        try {
            for (int i = 0; i < chestCavityType.getDefaultChestCavity().func_70302_i_(); ++i) {
                ItemStack itemStack = chestCavityType.getDefaultChestCavity().func_70301_a(i);
                if (itemStack == null || itemStack == ItemStack.field_190927_a) continue;
                Item slotitem = itemStack.func_77973_b();
                OrganData data = ChestCavityUtil.lookupOrgan(itemStack, chestCavityType);
                if (data == null) continue;
                data.organScores.forEach((key, value) -> ChestCavityUtil.addOrganScore(key, value.floatValue() * Math.min((float)itemStack.func_190916_E() / (float)itemStack.func_77976_d(), 1.0f), organScores));
            }
        }
        catch (IllegalStateException e) {
            ChestCavity.LOGGER.warn(e.getMessage() + ". Chest Cavity will attempt to calculate this default organ score later.");
            return false;
        }
        return true;
    }

    public static void drawOrgansFromPile(List<ItemStack> organPile, int rolls, Random random, List<ItemStack> loot) {
        for (int i = 0; i < rolls && !organPile.isEmpty(); ++i) {
            int roll = random.nextInt(organPile.size());
            int count = 1;
            ItemStack rolledItem = organPile.remove(roll).func_77946_l();
            if (rolledItem.func_190916_E() > 1) {
                count += random.nextInt(rolledItem.func_77976_d());
            }
            rolledItem.func_190920_e(count);
            loot.add(rolledItem);
        }
    }

    public static void dropUnboundOrgans(ChestCavityInstance cc) {
        try {
            cc.inventory.func_110132_b(cc);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        for (int i = 0; i < cc.inventory.func_70302_i_(); ++i) {
            int compatibility;
            ItemStack itemStack = cc.inventory.func_70301_a(i);
            if (itemStack == null || itemStack == ItemStack.field_190927_a || (compatibility = ChestCavityUtil.getCompatibilityLevel(cc, itemStack)) >= 2) continue;
            cc.owner.func_199701_a_(cc.inventory.func_70304_b(i));
        }
        cc.inventory.func_110134_a(cc);
        ChestCavityUtil.evaluateChestCavity(cc);
    }

    public static void evaluateChestCavity(ChestCavityInstance cc) {
        Map<ResourceLocation, Float> organScores = cc.getOrganScores();
        if (!cc.opened) {
            organScores.clear();
            if (cc.getChestCavityType().getDefaultOrganScores() != null) {
                organScores.putAll(cc.getChestCavityType().getDefaultOrganScores());
            }
        } else {
            cc.onHitListeners.clear();
            cc.getChestCavityType().loadBaseOrganScores(organScores);
            for (int i = 0; i < cc.inventory.func_70302_i_(); ++i) {
                int compatibility;
                ItemStack itemStack = cc.inventory.func_70301_a(i);
                if (itemStack == null || itemStack == ItemStack.field_190927_a) continue;
                Item slotitem = itemStack.func_77973_b();
                OrganData data = ChestCavityUtil.lookupOrgan(itemStack, cc.getChestCavityType());
                if (data == null) continue;
                data.organScores.forEach((key, value) -> ChestCavityUtil.addOrganScore(key, value.floatValue() * Math.min((float)itemStack.func_190916_E() / (float)itemStack.func_77976_d(), 1.0f), organScores));
                if (slotitem instanceof OrganOnHitListener) {
                    cc.onHitListeners.add(new OrganOnHitContext(itemStack, (OrganOnHitListener)slotitem));
                }
                if (data.pseudoOrgan || (compatibility = ChestCavityUtil.getCompatibilityLevel(cc, itemStack)) >= 1) continue;
                ChestCavityUtil.addOrganScore(CCOrganScores.INCOMPATIBILITY, 1.0f, organScores);
            }
        }
        ChestCavityUtil.organUpdate(cc);
    }

    public static void forcefullyAddStack(ChestCavityInstance cc, ItemStack stack, int slot) {
        if (!cc.inventory.func_233541_b_(stack)) {
            if (cc.owner.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223600_c) && cc.owner instanceof PlayerEntity) {
                if (!((PlayerEntity)cc.owner).field_71071_by.func_70441_a(stack)) {
                    cc.owner.func_199701_a_(cc.inventory.func_70304_b(slot));
                }
            } else {
                cc.owner.func_199701_a_(cc.inventory.func_70304_b(slot));
            }
        }
        cc.inventory.func_174894_a(stack);
    }

    public static void generateChestCavityIfOpened(ChestCavityInstance cc) {
        if (cc.opened) {
            cc.inventory.readTags(cc.getChestCavityType().getDefaultChestCavity().getTags());
            cc.getChestCavityType().setOrganCompatibility(cc);
        }
    }

    public static int getCompatibilityLevel(ChestCavityInstance cc, ItemStack itemStack) {
        if (itemStack != null && itemStack != ItemStack.field_190927_a) {
            if (EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)CCEnchantments.MALPRACTICE.get()), (ItemStack)itemStack) > 0) {
                return 0;
            }
            int oNegative = EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)CCEnchantments.O_NEGATIVE.get()), (ItemStack)itemStack);
            int ownership = 0;
            CompoundNBT tag = itemStack.func_77978_p();
            if (tag != null && tag.func_74764_b(ChestCavity.COMPATIBILITY_TAG.toString())) {
                if ((tag = tag.func_74775_l(ChestCavity.COMPATIBILITY_TAG.toString())).func_186857_a("owner").equals(cc.compatibility_id)) {
                    ownership = 2;
                }
            } else {
                ownership = 1;
            }
            return Math.max(oNegative, ownership);
        }
        return 1;
    }

    public static void insertWelfareOrgans(ChestCavityInstance cc) {
        if (cc.getOrganScore(CCOrganScores.HEALTH) <= 0.0f) {
            ChestCavityUtil.forcefullyAddStack(cc, new ItemStack((IItemProvider)CCItems.ROTTEN_HEART.get()), 4);
        }
        if (cc.getOrganScore(CCOrganScores.BREATH_RECOVERY) <= 0.0f) {
            ChestCavityUtil.forcefullyAddStack(cc, new ItemStack((IItemProvider)CCItems.ROTTEN_LUNG.get()), 3);
        }
        if (cc.getOrganScore(CCOrganScores.NERVES) <= 0.0f) {
            ChestCavityUtil.forcefullyAddStack(cc, new ItemStack((IItemProvider)CCItems.ROTTEN_SPINE.get()), 13);
        }
        if (cc.getOrganScore(CCOrganScores.STRENGTH) <= 0.0f) {
            ChestCavityUtil.forcefullyAddStack(cc, new ItemStack((IItemProvider)Items.field_151078_bh, 16), 0);
        }
    }

    public static boolean isHydroPhobicOrAllergic(LivingEntity entity) {
        Optional<ChestCavityEntity> optional = ChestCavityEntity.of((Entity)entity);
        if (optional.isPresent()) {
            ChestCavityInstance cc = optional.get().getChestCavityInstance();
            return cc.getOrganScore(CCOrganScores.HYDROALLERGENIC) > 0.0f || cc.getOrganScore(CCOrganScores.HYDROPHOBIA) > 0.0f;
        }
        return false;
    }

    protected static OrganData lookupOrgan(ItemStack itemStack, ChestCavityType cct) {
        OrganData organData = cct.catchExceptionalOrgan(itemStack);
        if (organData != null) {
            return organData;
        }
        if (OrganManager.hasEntry(itemStack.func_77973_b())) {
            return OrganManager.getEntry(itemStack.func_77973_b());
        }
        for (ITag.INamedTag<Item> itemTag : CCTagOrgans.tagMap.keySet()) {
            if (!itemTag.func_230235_a_((Object)itemStack.func_77973_b())) continue;
            organData = new OrganData();
            organData.pseudoOrgan = true;
            organData.organScores = CCTagOrgans.tagMap.get(itemTag);
            return organData;
        }
        return null;
    }

    public static EffectInstance onAddStatusEffect(ChestCavityInstance cc, EffectInstance effect) {
        return OrganAddStatusEffectCallback.organAddMobEffect(cc.owner, effect);
    }

    public static void onDeath(ChestCavityEntity entity) {
        ChestCavityInstance ccinstance = entity.getChestCavityInstance();
        ccinstance.getChestCavityType().onDeath(ccinstance);
        if (entity instanceof PlayerEntity) {
            PlayerEntity playerEntity = (PlayerEntity)entity;
            if (!ChestCavity.config.KEEP_CHEST_CAVITY) {
                HashMap<Integer, ItemStack> organsToKeep = new HashMap<Integer, ItemStack>();
                for (int i = 0; i < ccinstance.inventory.func_70302_i_(); ++i) {
                    ItemStack organ = ccinstance.inventory.func_70301_a(i);
                    if (EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)CCEnchantments.O_NEGATIVE.get()), (ItemStack)organ) < 2) continue;
                    organsToKeep.put(i, organ.func_77946_l());
                }
                ccinstance.compatibility_id = UUID.randomUUID();
                ChestCavityUtil.generateChestCavityIfOpened(ccinstance);
                for (Map.Entry entry : organsToKeep.entrySet()) {
                    ccinstance.inventory.func_70299_a((Integer)entry.getKey(), (ItemStack)entry.getValue());
                }
            }
            ChestCavityUtil.insertWelfareOrgans(ccinstance);
        }
    }

    public static float onHit(ChestCavityInstance cc, DamageSource source, LivingEntity target, float damage) {
        if (cc.opened) {
            for (OrganOnHitContext e : cc.onHitListeners) {
                damage = e.listener.onHit(source, cc.owner, target, cc, e.organ, damage);
            }
            ChestCavityUtil.organUpdate(cc);
        }
        return damage;
    }

    public static void onTick(ChestCavityInstance cc) {
        if (cc.updateInstantiated) {
            NetworkUtil.SendS2CChestCavityUpdatePacket(cc);
        }
        if (cc.opened) {
            OrganTickCallback.organTick(cc.owner, cc);
            ChestCavityUtil.organUpdate(cc);
        }
    }

    public static ChestCavityInventory openChestCavity(ChestCavityInstance cc) {
        if (!cc.opened) {
            try {
                cc.inventory.func_110132_b(cc);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            cc.opened = true;
            ChestCavityUtil.generateChestCavityIfOpened(cc);
            cc.inventory.func_110134_a(cc);
        }
        return cc.inventory;
    }

    public static void organUpdate(ChestCavityInstance cc) {
        Map<ResourceLocation, Float> organScores = cc.getOrganScores();
        if (!cc.oldOrganScores.equals(organScores)) {
            if (ChestCavity.isDebugMode() && cc.owner instanceof PlayerEntity) {
                ChestCavityUtil.outputOrganScoresString(System.out::println, cc);
            }
            OrganUpdateCallback.organUpdate(cc.owner, cc);
            cc.oldOrganScores.clear();
            cc.oldOrganScores.putAll(organScores);
            NetworkUtil.SendS2CChestCavityUpdatePacket(cc);
        }
    }

    public static void outputOrganScoresString(Consumer<String> output, ChestCavityInstance cc) {
        try {
            ITextComponent name = cc.owner.func_145748_c_();
            output.accept("[Chest Cavity] Displaying " + name.getString() + "'s organ scores:");
        }
        catch (Exception e) {
            output.accept("[Chest Cavity] Displaying organ scores:");
        }
        cc.getOrganScores().forEach((key, value) -> output.accept(key.func_110623_a() + ": " + value + " "));
    }

    public static void splashHydrophobicWithWater(PotionEntity splash) {
        AxisAlignedBB box = splash.func_174813_aQ().func_72314_b(4.0, 2.0, 4.0);
        List list = splash.field_70170_p.func_175647_a(LivingEntity.class, box, ChestCavityUtil::isHydroPhobicOrAllergic);
        if (!list.isEmpty()) {
            for (LivingEntity livingEntity : list) {
                Optional<ChestCavityEntity> optional;
                double d = splash.func_70068_e((Entity)livingEntity);
                if (!(d < 16.0) || !(optional = ChestCavityEntity.of((Entity)livingEntity)).isPresent()) continue;
                ChestCavityInstance cc = optional.get().getChestCavityInstance();
                float allergy = cc.getOrganScore(CCOrganScores.HYDROALLERGENIC);
                float phobia = cc.getOrganScore(CCOrganScores.HYDROPHOBIA);
                if (allergy > 0.0f) {
                    livingEntity.func_70097_a(DamageSource.func_76354_b((Entity)livingEntity, (Entity)splash.func_234616_v_()), allergy / 26.0f);
                }
                if (!(phobia > 0.0f)) continue;
                OrganUtil.teleportRandomly(livingEntity, phobia * 32.0f);
            }
        }
    }
}

