/*
 * Decompiled with CFR 0.152.
 */
package net.tigereye.chestcavity.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.AreaEffectCloudEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.horse.LlamaEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.DragonFireballEntity;
import net.minecraft.entity.projectile.FireballEntity;
import net.minecraft.entity.projectile.LlamaSpitEntity;
import net.minecraft.entity.projectile.ShulkerBulletEntity;
import net.minecraft.entity.projectile.SmallFireballEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.potion.PotionUtils;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.tigereye.chestcavity.ChestCavity;
import net.tigereye.chestcavity.chestcavities.instance.ChestCavityInstance;
import net.tigereye.chestcavity.interfaces.CCStatusEffectInstance;
import net.tigereye.chestcavity.interfaces.ChestCavityEntity;
import net.tigereye.chestcavity.registration.CCEnchantments;
import net.tigereye.chestcavity.registration.CCOrganScores;
import net.tigereye.chestcavity.registration.CCStatusEffects;
import net.tigereye.chestcavity.util.CCMixinThing;
import net.tigereye.chestcavity.util.ChestCavityUtil;
import net.tigereye.chestcavity.util.MathUtil;

public class OrganUtil {
    public static void displayOrganQuality(Map<ResourceLocation, Float> organQualityMap, List<ITextComponent> tooltip) {
        organQualityMap.forEach((organ, score) -> {
            String tier = organ.equals((Object)CCOrganScores.HYDROALLERGENIC) ? (score.floatValue() >= 2.0f ? "quality.chestcavity.severely" : "") : (score.floatValue() >= 1.5f ? "quality.chestcavity.supernatural" : ((double)score.floatValue() >= 1.25 ? "quality.chestcavity.exceptional" : (score.floatValue() >= 1.0f ? "quality.chestcavity.good" : (score.floatValue() >= 0.75f ? "quality.chestcavity.average" : (score.floatValue() >= 0.5f ? "quality.chestcavity.poor" : (score.floatValue() >= 0.0f ? "quality.chestcavity.pathetic" : (score.floatValue() >= -0.25f ? "quality.chestcavity.slightly_reduces" : (score.floatValue() >= -0.5f ? "quality.chestcavity.reduces" : (score.floatValue() >= -0.75f ? "quality.chestcavity.greatly_reduces" : "cripples")))))))));
            TranslationTextComponent text = new TranslationTextComponent("organscore." + organ.func_110624_b() + "." + organ.func_110623_a(), new Object[]{new TranslationTextComponent(tier)});
            tooltip.add((ITextComponent)text);
        });
    }

    public static void displayCompatibility(ItemStack itemStack, World world, List<ITextComponent> tooltip, ITooltipFlag tooltipContext) {
        String textString;
        CompoundNBT tag = itemStack.func_77978_p();
        boolean uuidMatch = false;
        int compatLevel = 0;
        ServerPlayerEntity serverPlayer = null;
        MinecraftServer server = world.func_73046_m();
        if (server == null) {
            server = Minecraft.func_71410_x().func_71401_C();
        }
        if (server != null) {
            serverPlayer = server.func_184103_al().func_177451_a(Minecraft.func_71410_x().field_71439_g.func_110124_au());
            if (serverPlayer instanceof ChestCavityEntity) {
                ChestCavityEntity ccPlayer = (ChestCavityEntity)serverPlayer;
                UUID ccID = ccPlayer.getChestCavityInstance().compatibility_id;
                compatLevel = ChestCavityUtil.getCompatibilityLevel(ccPlayer.getChestCavityInstance(), itemStack);
            }
        } else {
            compatLevel = -1;
        }
        if (EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)CCEnchantments.MALPRACTICE.get()), (ItemStack)itemStack) > 0) {
            textString = "Unsafe to use";
        } else if (tag != null && tag.func_74764_b(ChestCavity.COMPATIBILITY_TAG.toString()) && EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)CCEnchantments.O_NEGATIVE.get()), (ItemStack)itemStack) <= 0) {
            tag = tag.func_74775_l(ChestCavity.COMPATIBILITY_TAG.toString());
            String name = tag.func_74779_i("name");
            textString = "Only Compatible With: " + name;
        } else {
            textString = "Safe to Use";
        }
        StringTextComponent text = new StringTextComponent("");
        if (compatLevel > 0) {
            text.func_240699_a_(TextFormatting.GREEN);
        } else if (compatLevel == 0) {
            text.func_240699_a_(TextFormatting.RED);
        } else {
            text.func_240699_a_(TextFormatting.YELLOW);
        }
        text.func_240702_b_(textString);
        tooltip.add((ITextComponent)text);
    }

    public static void explode(LivingEntity entity, float explosionYield) {
        if (!entity.field_70170_p.field_72995_K) {
            Explosion.Mode destructionType = entity.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223599_b) ? Explosion.Mode.DESTROY : Explosion.Mode.NONE;
            entity.field_70170_p.func_217385_a(null, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), (float)Math.sqrt(explosionYield), destructionType);
            OrganUtil.spawnEffectsCloud(entity);
        }
    }

    public static List<EffectInstance> getStatusEffects(ItemStack organ) {
        CompoundNBT tag = organ.func_196082_o();
        if (!tag.func_150297_b("CustomPotionEffects", 9)) {
            return new ArrayList<EffectInstance>();
        }
        ListNBT NbtList = tag.func_150295_c("CustomPotionEffects", 10);
        ArrayList<EffectInstance> list = new ArrayList<EffectInstance>();
        for (int i = 0; i < NbtList.size(); ++i) {
            CompoundNBT compoundNBT = NbtList.func_150305_b(i);
            EffectInstance statusEffectInstance = EffectInstance.func_82722_b((CompoundNBT)compoundNBT);
            if (statusEffectInstance == null) continue;
            list.add(statusEffectInstance);
        }
        return list;
    }

    public static void milkSilk(LivingEntity entity) {
        if (!entity.func_70644_a((Effect)CCStatusEffects.SILK_COOLDOWN.get())) {
            ChestCavityEntity.of((Entity)entity).ifPresent(cce -> {
                ChestCavityInstance cc;
                float silk;
                if (cce.getChestCavityInstance().opened && (silk = (cc = cce.getChestCavityInstance()).getOrganScore(CCOrganScores.SILK)) > 0.0f && OrganUtil.spinWeb(entity, cc, silk)) {
                    entity.func_195064_c(new EffectInstance((Effect)CCStatusEffects.SILK_COOLDOWN.get(), ChestCavity.config.SILK_COOLDOWN, 0, false, false, true));
                }
            });
        }
    }

    public static void queueDragonBombs(LivingEntity entity, ChestCavityInstance cc, int bombs) {
        if (entity instanceof PlayerEntity) {
            ((PlayerEntity)entity).func_71020_j((float)bombs * 0.6f);
        }
        for (int i = 0; i < bombs; ++i) {
            cc.projectileQueue.add(OrganUtil::spawnDragonBomb);
        }
        entity.func_195064_c(new EffectInstance((Effect)CCStatusEffects.DRAGON_BOMB_COOLDOWN.get(), ChestCavity.config.DRAGON_BOMB_COOLDOWN, 0, false, false, true));
    }

    public static void queueForcefulSpit(LivingEntity entity, ChestCavityInstance cc, int projectiles) {
        if (entity instanceof PlayerEntity) {
            ((PlayerEntity)entity).func_71020_j((float)projectiles * 0.1f);
        }
        for (int i = 0; i < projectiles; ++i) {
            cc.projectileQueue.add(OrganUtil::spawnSpit);
        }
        entity.func_195064_c(new EffectInstance((Effect)CCStatusEffects.FORCEFUL_SPIT_COOLDOWN.get(), ChestCavity.config.FORCEFUL_SPIT_COOLDOWN, 0, false, false, true));
    }

    public static void queueGhastlyFireballs(LivingEntity entity, ChestCavityInstance cc, int ghastly) {
        if (entity instanceof PlayerEntity) {
            ((PlayerEntity)entity).func_71020_j((float)ghastly * 0.3f);
        }
        for (int i = 0; i < ghastly; ++i) {
            cc.projectileQueue.add(OrganUtil::spawnGhastlyFireball);
        }
        entity.func_195064_c(new EffectInstance((Effect)CCStatusEffects.GHASTLY_COOLDOWN.get(), ChestCavity.config.GHASTLY_COOLDOWN, 0, false, false, true));
    }

    public static void queuePyromancyFireballs(LivingEntity entity, ChestCavityInstance cc, int pyromancy) {
        if (entity instanceof PlayerEntity) {
            ((PlayerEntity)entity).func_71020_j((float)pyromancy * 0.1f);
        }
        for (int i = 0; i < pyromancy; ++i) {
            cc.projectileQueue.add(OrganUtil::spawnPyromancyFireball);
        }
        entity.func_195064_c(new EffectInstance((Effect)CCStatusEffects.PYROMANCY_COOLDOWN.get(), ChestCavity.config.PYROMANCY_COOLDOWN, 0, false, false, true));
    }

    public static void queueShulkerBullets(LivingEntity entity, ChestCavityInstance cc, int shulkerBullets) {
        if (entity instanceof PlayerEntity) {
            ((PlayerEntity)entity).func_71020_j((float)shulkerBullets * 0.3f);
        }
        for (int i = 0; i < shulkerBullets; ++i) {
            cc.projectileQueue.add(OrganUtil::spawnShulkerBullet);
        }
        entity.func_195064_c(new EffectInstance((Effect)CCStatusEffects.SHULKER_BULLET_COOLDOWN.get(), ChestCavity.config.SHULKER_BULLET_COOLDOWN, 0, false, false, true));
    }

    public static void setStatusEffects(ItemStack organ, ItemStack potion) {
        List potionList = PotionUtils.func_185189_a((ItemStack)potion);
        ArrayList<EffectInstance> list = new ArrayList<EffectInstance>();
        for (EffectInstance effect : potionList) {
            EffectInstance effectCopy = new EffectInstance(effect);
            ((CCStatusEffectInstance)effectCopy).CC_setDuration(Math.max(1, effectCopy.func_76459_b() / 4));
            list.add(effectCopy);
        }
        OrganUtil.setStatusEffects(organ, list);
    }

    public static void setStatusEffects(ItemStack organ, List<EffectInstance> list) {
        CompoundNBT tag = organ.func_196082_o();
        ListNBT NbtList = new ListNBT();
        for (int i = 0; i < list.size(); ++i) {
            EffectInstance effect = list.get(i);
            if (effect == null) continue;
            CompoundNBT compoundNBT = new CompoundNBT();
            NbtList.add((Object)effect.func_82719_a(compoundNBT));
        }
        tag.func_218657_a("CustomPotionEffects", (INBT)NbtList);
    }

    public static void shearSilk(LivingEntity entity) {
        ChestCavityEntity.of((Entity)entity).ifPresent(cce -> {
            float silk;
            if (cce.getChestCavityInstance().opened && (silk = cce.getChestCavityInstance().getOrganScore(CCOrganScores.SILK)) > 0.0f) {
                ItemEntity itemEntity;
                ItemStack stack;
                if (silk >= 2.0f) {
                    stack = new ItemStack((IItemProvider)Items.field_221672_ax, (int)silk / 2);
                    itemEntity = new ItemEntity(entity.field_70170_p, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), stack);
                    entity.field_70170_p.func_217376_c((Entity)itemEntity);
                }
                if (silk % 2.0f >= 1.0f) {
                    stack = new ItemStack((IItemProvider)Items.field_151007_F);
                    itemEntity = new ItemEntity(entity.field_70170_p, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), stack);
                    entity.field_70170_p.func_217376_c((Entity)itemEntity);
                }
            }
        });
    }

    public static void spawnEffectsCloud(LivingEntity entity) {
        Collection collection = entity.func_70651_bq();
        if (!collection.isEmpty()) {
            AreaEffectCloudEntity areaEffectCloudEntity = new AreaEffectCloudEntity(entity.field_70170_p, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
            areaEffectCloudEntity.func_184483_a(2.5f);
            areaEffectCloudEntity.func_184495_b(-0.5f);
            areaEffectCloudEntity.func_184485_d(10);
            areaEffectCloudEntity.func_184486_b(areaEffectCloudEntity.func_184489_o() / 2);
            areaEffectCloudEntity.func_184487_c(-areaEffectCloudEntity.func_184490_j() / (float)areaEffectCloudEntity.func_184489_o());
            for (EffectInstance statusEffectInstance : collection) {
                areaEffectCloudEntity.func_184496_a(new EffectInstance(statusEffectInstance));
            }
            entity.field_70170_p.func_217376_c((Entity)areaEffectCloudEntity);
        }
    }

    public static void spawnSilk(LivingEntity entity) {
        entity.func_199703_a((IItemProvider)Items.field_151007_F);
    }

    public static void spawnSpit(LivingEntity entity) {
        Vector3d entityFacing = entity.func_70040_Z().func_72432_b();
        LlamaEntity fakeLlama = new LlamaEntity(EntityType.field_200769_I, entity.field_70170_p);
        fakeLlama.func_70107_b(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
        fakeLlama.field_70125_A = entity.field_70125_A;
        fakeLlama.field_70177_z = entity.field_70177_z;
        fakeLlama.field_70761_aq = entity.field_70761_aq;
        LlamaSpitEntity llamaSpitEntity = new LlamaSpitEntity(entity.field_70170_p, fakeLlama);
        llamaSpitEntity.func_212361_a((Entity)entity);
        llamaSpitEntity.func_213293_j(entityFacing.field_72450_a * 2.0, entityFacing.field_72448_b * 2.0, entityFacing.field_72449_c * 2.0);
        entity.field_70170_p.func_217376_c((Entity)llamaSpitEntity);
        entityFacing = entityFacing.func_186678_a(-0.1);
        entity.func_70024_g(entityFacing.field_72450_a, entityFacing.field_72448_b, entityFacing.field_72449_c);
    }

    public static void spawnDragonBomb(LivingEntity entity) {
        Vector3d entityFacing = entity.func_70040_Z().func_72432_b();
        DragonFireballEntity fireballEntity = new DragonFireballEntity(entity.field_70170_p, entity, entityFacing.field_72450_a, entityFacing.field_72448_b, entityFacing.field_72449_c);
        fireballEntity.func_242281_f(fireballEntity.func_226277_ct_(), entity.func_226275_c_(0.5) + 0.3, fireballEntity.func_226281_cx_());
        entity.field_70170_p.func_217376_c((Entity)fireballEntity);
        entityFacing = entityFacing.func_186678_a(-0.2);
        entity.func_70024_g(entityFacing.field_72450_a, entityFacing.field_72448_b, entityFacing.field_72449_c);
    }

    public static void spawnDragonBreath(LivingEntity entity) {
        Optional<ChestCavityEntity> optional = ChestCavityEntity.of((Entity)entity);
        if (!optional.isPresent()) {
            return;
        }
        ChestCavityEntity cce = optional.get();
        ChestCavityInstance cc = cce.getChestCavityInstance();
        float breath = cc.getOrganScore(CCOrganScores.DRAGON_BREATH);
        double range = Math.sqrt(breath / 2.0f) * 5.0;
        RayTraceResult result = entity.func_213324_a(range, 0.0f, false);
        Vector3d pos = result.func_216347_e();
        double x = pos.field_72450_a;
        double y = pos.field_72448_b;
        double z = pos.field_72449_c;
        BlockPos.Mutable mutable = new BlockPos.Mutable(x, y, z);
        while (entity.field_70170_p.func_175623_d((BlockPos)mutable)) {
            if ((y -= 1.0) < 0.0) {
                return;
            }
            mutable.func_189532_c(x, y, z);
        }
        y = Math.floor(y) + 1.0;
        AreaEffectCloudEntity breathEntity = new AreaEffectCloudEntity(entity.field_70170_p, x, y, z);
        breathEntity.func_184481_a(entity);
        breathEntity.func_184483_a((float)Math.max(range / 2.0, Math.min(range, (double)MathUtil.horizontalDistanceTo((Entity)breathEntity, (Entity)entity))));
        breathEntity.func_184486_b(200);
        breathEntity.func_195059_a((IParticleData)ParticleTypes.field_197616_i);
        breathEntity.func_184496_a(new EffectInstance(Effects.field_76433_i));
        entity.field_70170_p.func_217376_c((Entity)breathEntity);
    }

    public static void spawnGhastlyFireball(LivingEntity entity) {
        Vector3d entityFacing = entity.func_70040_Z().func_72432_b();
        FireballEntity fireballEntity = new FireballEntity(entity.field_70170_p, entity, entityFacing.field_72450_a, entityFacing.field_72448_b, entityFacing.field_72449_c);
        fireballEntity.func_242281_f(fireballEntity.func_226277_ct_(), entity.func_226283_e_(0.5) + 0.3, fireballEntity.func_226281_cx_());
        entity.field_70170_p.func_217376_c((Entity)fireballEntity);
        entityFacing = entityFacing.func_186678_a(-0.8);
        entity.func_70024_g(entityFacing.field_72450_a, entityFacing.field_72448_b, entityFacing.field_72449_c);
    }

    public static void spawnPyromancyFireball(LivingEntity entity) {
        Vector3d entityFacing = entity.func_70040_Z().func_72432_b();
        SmallFireballEntity smallFireballEntity = new SmallFireballEntity(entity.field_70170_p, entity, entityFacing.field_72450_a + entity.func_70681_au().nextGaussian() * 0.1, entityFacing.field_72448_b, entityFacing.field_72449_c + entity.func_70681_au().nextGaussian() * 0.1);
        smallFireballEntity.func_242281_f(smallFireballEntity.func_226277_ct_(), entity.func_226283_e_(0.5) + 0.3, smallFireballEntity.func_226281_cx_());
        entity.field_70170_p.func_217376_c((Entity)smallFireballEntity);
        entityFacing = entityFacing.func_186678_a(-0.2);
        entity.func_70024_g(entityFacing.field_72450_a, entityFacing.field_72448_b, entityFacing.field_72449_c);
    }

    public static void spawnShulkerBullet(LivingEntity entity) {
        EntityPredicate targetPredicate = new EntityPredicate();
        targetPredicate.func_221013_a((double)(ChestCavity.config.SHULKER_BULLET_TARGETING_RANGE * 2));
        LivingEntity target = entity.field_70170_p.func_217360_a(LivingEntity.class, targetPredicate, entity, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), new AxisAlignedBB(entity.func_226277_ct_() - (double)ChestCavity.config.SHULKER_BULLET_TARGETING_RANGE, entity.func_226278_cu_() - (double)ChestCavity.config.SHULKER_BULLET_TARGETING_RANGE, entity.func_226281_cx_() - (double)ChestCavity.config.SHULKER_BULLET_TARGETING_RANGE, entity.func_226277_ct_() + (double)ChestCavity.config.SHULKER_BULLET_TARGETING_RANGE, entity.func_226278_cu_() + (double)ChestCavity.config.SHULKER_BULLET_TARGETING_RANGE, entity.func_226281_cx_() + (double)ChestCavity.config.SHULKER_BULLET_TARGETING_RANGE));
        if (target == null) {
            return;
        }
        ShulkerBulletEntity shulkerBulletEntity = new ShulkerBulletEntity(entity.field_70170_p, entity, (Entity)target, Direction.Axis.Y);
        shulkerBulletEntity.func_242281_f(shulkerBulletEntity.func_226277_ct_(), entity.func_226283_e_(0.5) + 0.3, shulkerBulletEntity.func_226281_cx_());
        entity.field_70170_p.func_217376_c((Entity)shulkerBulletEntity);
    }

    public static boolean spinWeb(LivingEntity entity, ChestCavityInstance cc, float silkScore) {
        BlockPos pos;
        int hungerCost = 0;
        PlayerEntity player = null;
        if (entity instanceof PlayerEntity && (player = (PlayerEntity)entity).func_71024_bL().func_75116_a() < 6) {
            return false;
        }
        if (silkScore >= 2.0f && entity.field_70170_p.func_180495_p(pos = ((CCMixinThing)entity).getMixinBlockPos().func_177972_a(entity.func_174811_aO().func_176734_d())).func_196958_f()) {
            if (silkScore >= 3.0f) {
                hungerCost = 16;
                silkScore -= 3.0f;
                entity.field_70170_p.func_180501_a(pos, Blocks.field_196556_aL.func_176223_P(), 2);
            } else {
                hungerCost = 8;
                silkScore -= 2.0f;
                entity.field_70170_p.func_180501_a(pos, Blocks.field_196553_aF.func_176223_P(), 2);
            }
        }
        while (silkScore >= 1.0f) {
            silkScore -= 1.0f;
            hungerCost += 4;
            cc.projectileQueue.add(OrganUtil::spawnSilk);
        }
        if (player != null) {
            player.func_71024_bL().func_75113_a((float)hungerCost);
        }
        return hungerCost > 0;
    }

    public static boolean teleportRandomly(LivingEntity entity, float range) {
        if (!entity.field_70170_p.func_201670_d() && entity.func_70089_S()) {
            for (int i = 0; i < ChestCavity.config.MAX_TELEPORT_ATTEMPTS; ++i) {
                double f;
                double e;
                double d = entity.func_226277_ct_() + (entity.func_70681_au().nextDouble() - 0.5) * (double)range;
                if (!OrganUtil.teleportTo(entity, d, e = Math.max(1.0, entity.func_226278_cu_() + (entity.func_70681_au().nextDouble() - 0.5) * (double)range), f = entity.func_226281_cx_() + (entity.func_70681_au().nextDouble() - 0.5) * (double)range)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean teleportTo(LivingEntity entity, double x, double y, double z) {
        if (entity.func_184218_aH()) {
            entity.func_184210_p();
        }
        BlockPos.Mutable targetPos = new BlockPos.Mutable(x, y, z);
        BlockState blockState = entity.field_70170_p.func_180495_p((BlockPos)targetPos);
        while (targetPos.func_177956_o() > 0 && !blockState.func_185904_a().func_76230_c() && !blockState.func_185904_a().func_76224_d()) {
            targetPos.func_189536_c(Direction.DOWN);
            blockState = entity.field_70170_p.func_180495_p((BlockPos)targetPos);
        }
        if (targetPos.func_177956_o() <= 0) {
            return false;
        }
        targetPos.func_189536_c(Direction.UP);
        blockState = entity.field_70170_p.func_180495_p((BlockPos)targetPos);
        BlockState blockState2 = entity.field_70170_p.func_180495_p(targetPos.func_177984_a());
        while (blockState.func_185904_a().func_76230_c() || blockState.func_185904_a().func_76224_d() || blockState2.func_185904_a().func_76230_c() || blockState2.func_185904_a().func_76224_d()) {
            targetPos.func_189536_c(Direction.UP);
            blockState = entity.field_70170_p.func_180495_p((BlockPos)targetPos);
            blockState2 = entity.field_70170_p.func_180495_p(targetPos.func_177984_a());
        }
        if (entity.field_70170_p.func_230315_m_().func_236037_d_() && targetPos.func_177956_o() >= entity.field_70170_p.func_234938_ad_()) {
            return false;
        }
        entity.func_70634_a(x, (double)targetPos.func_177956_o() + 0.1, z);
        if (!entity.func_174814_R()) {
            entity.field_70170_p.func_184148_a(null, entity.field_70142_S, entity.field_70137_T, entity.field_70136_U, SoundEvents.field_187534_aX, entity.func_184176_by(), 1.0f, 1.0f);
            entity.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
        }
        return true;
    }
}

