/*
 * Decompiled with CFR 0.152.
 */
package net.tigereye.chestcavity.chestcavities.organs;

import com.google.gson.Gson;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.item.Item;
import net.tigereye.chestcavity.ChestCavity;
import net.tigereye.chestcavity.chestcavities.organs.OrganData;
import net.tigereye.chestcavity.chestcavities.organs.OrganJsonFormat;
import net.tigereye.chestcavity.chestcavities.organs.OrganSerializer;
import net.tigereye.chestcavity.util.Pair;

public class OrganManager
implements ResourceManagerReloadListener {
    private static final ResourceLocation RESOURCE_LOCATION = new ResourceLocation("chestcavity", "organs");
    private final OrganSerializer SERIALIZER = new OrganSerializer();
    public static Map<ResourceLocation, OrganData> GeneratedOrganData = new HashMap<ResourceLocation, OrganData>();

    public void m_6213_(ResourceManager manager) {
        GeneratedOrganData.clear();
        ChestCavity.LOGGER.info("Loading organs.");
        for (ResourceLocation id : manager.m_6540_(RESOURCE_LOCATION.m_135815_(), path -> path.endsWith(".json"))) {
            try {
                InputStream stream = manager.m_142591_(id).m_6679_();
                try {
                    InputStreamReader reader = new InputStreamReader(stream);
                    Pair<ResourceLocation, OrganData> organDataPair = this.SERIALIZER.read(id, (OrganJsonFormat)new Gson().fromJson((Reader)reader, OrganJsonFormat.class));
                    GeneratedOrganData.put(organDataPair.getLeft(), organDataPair.getRight());
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (Exception e) {
                ChestCavity.LOGGER.error("Error occurred while loading resource json " + id.toString(), (Throwable)e);
            }
        }
        ChestCavity.LOGGER.info("Loaded " + GeneratedOrganData.size() + " organs.");
    }

    public static boolean hasEntry(Item item) {
        return GeneratedOrganData.containsKey(Registry.f_122827_.m_7981_((Object)item));
    }

    public static OrganData getEntry(Item item) {
        return GeneratedOrganData.get(Registry.f_122827_.m_7981_((Object)item));
    }

    public static boolean isTrueOrgan(Item item) {
        if (OrganManager.hasEntry(item)) {
            return !OrganManager.getEntry((Item)item).pseudoOrgan;
        }
        return false;
    }
}

