/*
 * Decompiled with CFR 0.152.
 */
package net.tigereye.chestcavity.chestcavities.organs;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.tigereye.chestcavity.ChestCavity;
import net.tigereye.chestcavity.chestcavities.organs.OrganData;
import net.tigereye.chestcavity.chestcavities.organs.OrganJsonFormat;
import net.tigereye.chestcavity.util.Pair;

public class OrganSerializer {
    public Pair<ResourceLocation, OrganData> read(ResourceLocation id, OrganJsonFormat organJson) {
        if (organJson.itemID == null) {
            throw new JsonSyntaxException("Organ " + id + " must have an item ID");
        }
        if (organJson.organScores == null) {
            throw new JsonSyntaxException("Organ " + id + " must have organScores");
        }
        OrganData organData = new OrganData();
        ResourceLocation itemID = new ResourceLocation(organJson.itemID);
        organData.pseudoOrgan = organJson.pseudoOrgan;
        organData.organScores = this.readOrganScoresFromJson(id, organJson.organScores);
        return new Pair<ResourceLocation, OrganData>(itemID, organData);
    }

    private Map<ResourceLocation, Float> readOrganScoresFromJson(ResourceLocation id, JsonArray json) {
        HashMap<ResourceLocation, Float> organScores = new HashMap<ResourceLocation, Float>();
        for (JsonElement entry : json) {
            try {
                JsonObject obj = entry.getAsJsonObject();
                if (!obj.has("id")) {
                    ChestCavity.LOGGER.error("Missing id component in " + id.toString() + "'s organ scores");
                    continue;
                }
                if (!obj.has("value")) {
                    ChestCavity.LOGGER.error("Missing value component in " + id.toString() + "'s organ scores");
                    continue;
                }
                ResourceLocation ability = new ResourceLocation(obj.get("id").getAsString());
                organScores.put(ability, Float.valueOf(obj.get("value").getAsFloat()));
            }
            catch (Exception e) {
                ChestCavity.LOGGER.error("Error parsing " + id.toString() + "'s organ scores!");
            }
        }
        return organScores;
    }
}

