/*
 * Decompiled with CFR 0.152.
 */
package net.tigereye.chestcavity.network.packets;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.tigereye.chestcavity.chestcavities.instance.ChestCavityInstance;
import net.tigereye.chestcavity.interfaces.ChestCavityEntity;

public class ChestCavityUpdatePacket {
    private boolean open;
    private int size;
    private Map<ResourceLocation, Float> organScoresMap;

    public ChestCavityUpdatePacket(boolean open, int size, Map<ResourceLocation, Float> organScoresMap) {
        this.open = open;
        this.size = size;
        this.organScoresMap = organScoresMap;
    }

    public static ChestCavityUpdatePacket decode(FriendlyByteBuf buf) {
        boolean open = buf.readBoolean();
        int size = buf.readInt();
        HashMap<ResourceLocation, Float> organScores = new HashMap<ResourceLocation, Float>();
        for (int i = 0; i < size; ++i) {
            organScores.put(new ResourceLocation(buf.m_130277_()), Float.valueOf(buf.readFloat()));
        }
        return new ChestCavityUpdatePacket(open, size, organScores);
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeBoolean(this.open);
        buf.writeInt(this.size);
        this.organScoresMap.forEach((id, value) -> {
            buf.m_130070_(id.toString());
            buf.writeFloat(value.floatValue());
        });
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        AtomicBoolean success = new AtomicBoolean(false);
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            Optional<ChestCavityEntity> optional = ChestCavityEntity.of(Minecraft.m_91087_().f_91075_);
            optional.ifPresent(chestCavityEntity -> {
                ChestCavityInstance instance = chestCavityEntity.getChestCavityInstance();
                instance.opened = this.open;
                instance.setOrganScores(this.organScoresMap);
                success.set(true);
            });
        }));
        ctx.get().setPacketHandled(true);
        return success.get();
    }
}

