/*
 * Decompiled with CFR 0.152.
 */
package net.tigereye.chestcavity.recipes;

import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.tigereye.chestcavity.registration.CCRecipes;

public class SalvageRecipe
implements CraftingRecipe {
    private final Ingredient input;
    private int required;
    private final ItemStack outputStack;
    private final ResourceLocation id;

    public SalvageRecipe(Ingredient input, int required, ItemStack outputStack, ResourceLocation id) {
        this.input = input;
        this.required = required;
        this.outputStack = outputStack;
        this.id = id;
    }

    public Ingredient getInput() {
        return this.input;
    }

    public int getRequired() {
        return this.required;
    }

    public NonNullList<Ingredient> m_7527_() {
        return NonNullList.m_122780_((int)this.required, (Object)this.input);
    }

    public boolean matches(CraftingContainer inv, Level world) {
        int count = 0;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack target = inv.m_8020_(i);
            if (target == null || target == ItemStack.f_41583_ || target.m_41720_() == Items.f_41852_) continue;
            if (this.input.test(inv.m_8020_(i))) {
                ++count;
                continue;
            }
            return false;
        }
        return count > 0 && count % this.required == 0;
    }

    public ItemStack assemble(CraftingContainer inv) {
        int count = 0;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack target = inv.m_8020_(i);
            if (target == null || target == ItemStack.f_41583_ || target.m_41720_() == Items.f_41852_) continue;
            if (this.input.test(inv.m_8020_(i))) {
                ++count;
                continue;
            }
            return ItemStack.f_41583_;
        }
        if (count == 0 || count % this.required != 0) {
            return ItemStack.f_41583_;
        }
        if ((count = count / this.required * this.outputStack.m_41613_()) > this.outputStack.m_41741_()) {
            return ItemStack.f_41583_;
        }
        ItemStack out = this.m_8043_();
        out.m_41764_(count);
        return out;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_() {
        return this.outputStack.m_41777_();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)CCRecipes.SALVAGE_RECIPE_SERIALIZER.get();
    }
}

