/*
 * Decompiled with CFR 0.152.
 */
package net.tigereye.chestcavity.recipes.json;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.tigereye.chestcavity.recipes.SalvageRecipe;
import net.tigereye.chestcavity.recipes.json.SalvageRecipeJsonFormat;
import net.tigereye.chestcavity.registration.CCRecipes;

public class SalvageRecipeSerializer
implements RecipeSerializer<SalvageRecipe> {
    public SalvageRecipe fromJson(ResourceLocation id, JsonObject json) {
        SalvageRecipeJsonFormat recipeJson = (SalvageRecipeJsonFormat)new Gson().fromJson((JsonElement)json, SalvageRecipeJsonFormat.class);
        if (recipeJson.ingredient == null || recipeJson.result == null) {
            throw new JsonSyntaxException("A required attribute is missing!");
        }
        if (recipeJson.required == 0) {
            recipeJson.required = 1;
        }
        if (recipeJson.count == 0) {
            recipeJson.count = 1;
        }
        Ingredient input = Ingredient.m_43917_((JsonElement)recipeJson.ingredient);
        Item outputItem = (Item)Registry.f_122827_.m_6612_(new ResourceLocation(recipeJson.result)).orElseThrow(() -> new JsonSyntaxException("No such item " + recipeJson.result));
        ItemStack output = new ItemStack((ItemLike)outputItem, recipeJson.count);
        return new SalvageRecipe(input, recipeJson.required, output, id);
    }

    public SalvageRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
        Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buf);
        int required = buf.readInt();
        ItemStack output = buf.m_130267_();
        return new SalvageRecipe(input, required, output, id);
    }

    public void toNetwork(FriendlyByteBuf buf, SalvageRecipe recipe) {
        recipe.getInput().m_43923_(buf);
        buf.writeInt(recipe.getRequired());
        buf.m_130055_(recipe.m_8043_());
    }

    public RecipeSerializer<?> setRegistryName(ResourceLocation name) {
        return this;
    }

    public ResourceLocation getRegistryName() {
        return CCRecipes.SALVAGE_RECIPE_ID;
    }

    public Class<RecipeSerializer<?>> getRegistryType() {
        return SalvageRecipeSerializer.castClass(RecipeSerializer.class);
    }

    private static <G> Class<G> castClass(Class<?> cls) {
        return cls;
    }
}

