/*
 * Decompiled with CFR 0.152.
 */
package net.tigereye.chestcavity.chestcavities.instance;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.tigereye.chestcavity.ChestCavity;
import net.tigereye.chestcavity.chestcavities.ChestCavityInventory;
import net.tigereye.chestcavity.chestcavities.ChestCavityType;
import net.tigereye.chestcavity.listeners.OrganOnHitContext;
import net.tigereye.chestcavity.util.ChestCavityUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChestCavityInstance
implements ContainerListener {
    public static final Logger LOGGER = LogManager.getLogger();
    protected ChestCavityType type;
    public LivingEntity owner;
    public UUID compatibility_id;
    public boolean opened = false;
    public ChestCavityInventory inventory = new ChestCavityInventory();
    public Map<ResourceLocation, Float> oldOrganScores = new HashMap<ResourceLocation, Float>();
    protected Map<ResourceLocation, Float> organScores = new HashMap<ResourceLocation, Float>();
    public List<OrganOnHitContext> onHitListeners = new ArrayList<OrganOnHitContext>();
    public LinkedList<Consumer<LivingEntity>> projectileQueue = new LinkedList();
    public int heartBleedTimer = 0;
    public int bloodPoisonTimer = 0;
    public int liverTimer = 0;
    public float metabolismRemainder = 0.0f;
    public float lungRemainder = 0.0f;
    public int projectileCooldown = 0;
    public int furnaceProgress = 0;
    public int photosynthesisProgress = 0;
    public EndCrystal connectedCrystal = null;
    public boolean updateInstantiated = false;
    public ChestCavityInstance ccBeingOpened = null;

    public ChestCavityInstance(ChestCavityType type, LivingEntity owner) {
        this.type = type;
        this.owner = owner;
        this.compatibility_id = owner.m_20148_();
        ChestCavityUtil.evaluateChestCavity(this);
    }

    public ChestCavityType getChestCavityType() {
        return this.type;
    }

    public Map<ResourceLocation, Float> getOrganScores() {
        return this.organScores;
    }

    public void setOrganScores(Map<ResourceLocation, Float> organScores) {
        this.organScores = organScores;
    }

    public float getOrganScore(ResourceLocation id) {
        return this.organScores.getOrDefault(id, Float.valueOf(0.0f)).floatValue();
    }

    public float getOldOrganScore(ResourceLocation id) {
        return this.oldOrganScores.getOrDefault(id, Float.valueOf(0.0f)).floatValue();
    }

    public void m_5757_(Container sender) {
        ChestCavityUtil.clearForbiddenSlots(this);
        ChestCavityUtil.evaluateChestCavity(this);
    }

    public void fromTag(CompoundTag tag, LivingEntity owner) {
        CompoundTag temp;
        LOGGER.debug("[Chest Cavity] Reading ChestCavityManager fromTag");
        this.owner = owner;
        if (tag.m_128441_("ChestCavity")) {
            ChestCavity.printOnDebug("Found Save Data");
            CompoundTag ccTag = tag.m_128469_("ChestCavity");
            this.opened = ccTag.m_128471_("opened");
            this.heartBleedTimer = ccTag.m_128451_("HeartTimer");
            this.bloodPoisonTimer = ccTag.m_128451_("KidneyTimer");
            this.liverTimer = ccTag.m_128451_("LiverTimer");
            this.metabolismRemainder = ccTag.m_128457_("MetabolismRemainder");
            this.lungRemainder = ccTag.m_128457_("LungRemainder");
            this.furnaceProgress = ccTag.m_128451_("FurnaceProgress");
            this.photosynthesisProgress = ccTag.m_128451_("PhotosynthesisProgress");
            this.compatibility_id = ccTag.m_128441_("compatibility_id") ? ccTag.m_128342_("compatibility_id") : owner.m_20148_();
            try {
                this.inventory.m_19181_(this);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            if (ccTag.m_128441_("Inventory")) {
                ListTag NbtList = ccTag.m_128437_("Inventory", 10);
                this.inventory.readTags(NbtList);
            } else if (this.opened) {
                LOGGER.warn("[Chest Cavity] " + owner.m_7755_().m_214077_() + "'s Chest Cavity is mangled. It will be replaced");
                ChestCavityUtil.generateChestCavityIfOpened(this);
            }
            this.inventory.m_19164_(this);
        } else if (tag.m_128441_("cardinal_components") && (temp = tag.m_128469_("cardinal_components")).m_128441_("chestcavity:inventorycomponent") && (temp = tag.m_128469_("chestcavity:inventorycomponent")).m_128441_("chestcavity")) {
            LOGGER.info("[Chest Cavity] Found " + owner.m_7755_().m_214077_() + "'s old [Cardinal Components] Chest Cavity.");
            this.opened = true;
            ListTag NbtList = temp.m_128437_("Inventory", 10);
            try {
                this.inventory.m_19181_(this);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            this.inventory.readTags(NbtList);
            this.inventory.m_19164_(this);
        }
        ChestCavityUtil.evaluateChestCavity(this);
    }

    public void toTag(CompoundTag tag) {
        ChestCavity.printOnDebug("Writing ChestCavityManager toTag");
        CompoundTag ccTag = new CompoundTag();
        ccTag.m_128379_("opened", this.opened);
        ccTag.m_128362_("compatibility_id", this.compatibility_id);
        ccTag.m_128405_("HeartTimer", this.heartBleedTimer);
        ccTag.m_128405_("KidneyTimer", this.bloodPoisonTimer);
        ccTag.m_128405_("LiverTimer", this.liverTimer);
        ccTag.m_128350_("MetabolismRemainder", this.metabolismRemainder);
        ccTag.m_128350_("LungRemainder", this.lungRemainder);
        ccTag.m_128405_("FurnaceProgress", this.furnaceProgress);
        ccTag.m_128405_("PhotosynthesisProgress", this.photosynthesisProgress);
        ccTag.m_128365_("Inventory", (Tag)this.inventory.getTags());
        tag.m_128365_("ChestCavity", (Tag)ccTag);
    }

    public void clone(ChestCavityInstance other) {
        this.opened = other.opened;
        this.type = other.type;
        this.compatibility_id = other.compatibility_id;
        try {
            this.inventory.m_19181_(this);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        for (int i = 0; i < this.inventory.m_6643_(); ++i) {
            this.inventory.m_6836_(i, other.inventory.m_8020_(i));
        }
        this.inventory.readTags(other.inventory.getTags());
        this.inventory.m_19164_(this);
        this.heartBleedTimer = other.heartBleedTimer;
        this.liverTimer = other.liverTimer;
        this.bloodPoisonTimer = other.bloodPoisonTimer;
        this.metabolismRemainder = other.metabolismRemainder;
        this.lungRemainder = other.lungRemainder;
        this.furnaceProgress = other.furnaceProgress;
        this.connectedCrystal = other.connectedCrystal;
        ChestCavityUtil.evaluateChestCavity(this);
    }
}

