/*
 * Decompiled with CFR 0.152.
 */
package net.tigereye.chestcavity.chestcavities.instance;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.registries.ForgeRegistries;
import net.tigereye.chestcavity.chestcavities.ChestCavityType;
import net.tigereye.chestcavity.chestcavities.instance.ChestCavityInstance;
import net.tigereye.chestcavity.chestcavities.types.DefaultChestCavityType;
import net.tigereye.chestcavity.chestcavities.types.json.GeneratedChestCavityAssignmentManager;
import net.tigereye.chestcavity.chestcavities.types.json.GeneratedChestCavityTypeManager;

public class ChestCavityInstanceFactory {
    private static final Map<ResourceLocation, ChestCavityType> entityResourceLocationMap = new HashMap<ResourceLocation, ChestCavityType>();
    private static final ChestCavityType DEFAULT_CHEST_CAVITY_TYPE = new DefaultChestCavityType();

    public static ChestCavityInstance newChestCavityInstance(EntityType<? extends LivingEntity> entityType, LivingEntity owner) {
        ResourceLocation chestCavityTypeID;
        ResourceLocation entityID = ForgeRegistries.ENTITY_TYPES.getKey(entityType);
        if (GeneratedChestCavityAssignmentManager.GeneratedChestCavityAssignments.containsKey(entityID) && GeneratedChestCavityTypeManager.GeneratedChestCavityTypes.containsKey(chestCavityTypeID = GeneratedChestCavityAssignmentManager.GeneratedChestCavityAssignments.get(entityID))) {
            return new ChestCavityInstance(GeneratedChestCavityTypeManager.GeneratedChestCavityTypes.get(chestCavityTypeID), owner);
        }
        if (entityResourceLocationMap.containsKey(entityID)) {
            return new ChestCavityInstance(entityResourceLocationMap.get(ForgeRegistries.ENTITY_TYPES.getKey(entityType)), owner);
        }
        return new ChestCavityInstance(DEFAULT_CHEST_CAVITY_TYPE, owner);
    }

    public static void register(EntityType<? extends LivingEntity> entityType, ChestCavityType chestCavityType) {
        entityResourceLocationMap.put(ForgeRegistries.ENTITY_TYPES.getKey(entityType), chestCavityType);
    }

    public static void register(ResourceLocation entityResourceLocation, ChestCavityType chestCavityType) {
        entityResourceLocationMap.put(entityResourceLocation, chestCavityType);
    }
}

