/*
 * Decompiled with CFR 0.152.
 */
package net.tigereye.chestcavity.chestcavities.types.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.tigereye.chestcavity.ChestCavity;
import net.tigereye.chestcavity.chestcavities.ChestCavityInventory;
import net.tigereye.chestcavity.chestcavities.types.GeneratedChestCavityType;
import net.tigereye.chestcavity.chestcavities.types.json.ChestCavityTypeJsonFormat;

public class ChestCavityTypeSerializer {
    public GeneratedChestCavityType read(ResourceLocation id, ChestCavityTypeJsonFormat cctJson) {
        if (cctJson.defaultChestCavity == null) {
            throw new JsonSyntaxException("Chest Cavity Types must have a default chest cavity!");
        }
        if (cctJson.exceptionalOrgans == null) {
            cctJson.exceptionalOrgans = new JsonArray();
        }
        if (cctJson.baseOrganScores == null) {
            cctJson.baseOrganScores = new JsonArray();
        }
        if (cctJson.forbiddenSlots == null) {
            cctJson.forbiddenSlots = new JsonArray();
        }
        GeneratedChestCavityType cct = new GeneratedChestCavityType();
        cct.setForbiddenSlots(this.readForbiddenSlotsFromJson(id, cctJson));
        cct.setDefaultChestCavity(this.readDefaultChestCavityFromJson(id, cctJson, cct.getForbiddenSlots()));
        cct.setBaseOrganScores(this.readBaseOrganScoresFromJson(id, cctJson));
        cct.setExceptionalOrganList(this.readExceptionalOrgansFromJson(id, cctJson));
        cct.setDropRateMultiplier(cctJson.dropRateMultiplier);
        cct.setPlayerChestCavity(cctJson.playerChestCavity);
        cct.setBossChestCavity(cctJson.bossChestCavity);
        return cct;
    }

    private ChestCavityInventory readDefaultChestCavityFromJson(ResourceLocation id, ChestCavityTypeJsonFormat cctJson, List<Integer> forbiddenSlots) {
        ChestCavityInventory inv = new ChestCavityInventory();
        int i = 0;
        for (JsonElement entry : cctJson.defaultChestCavity) {
            ++i;
            try {
                JsonObject obj = entry.getAsJsonObject();
                if (!obj.has("item")) {
                    ChestCavity.LOGGER.error("Missing item component in entry no." + i + " in " + id.toString() + "'s default chest cavity");
                    continue;
                }
                if (!obj.has("position")) {
                    ChestCavity.LOGGER.error("Missing position component in entry no. " + i + " in " + id.toString() + "'s default chest cavity");
                    continue;
                }
                ResourceLocation itemID = new ResourceLocation(obj.get("item").getAsString());
                Optional itemOptional = Registry.f_122827_.m_6612_(new ResourceLocation(obj.get("item").getAsString()));
                if (itemOptional.isPresent()) {
                    ItemStack stack;
                    Item item = (Item)itemOptional.get();
                    if (obj.has("count")) {
                        int count = obj.get("count").getAsInt();
                        stack = new ItemStack((ItemLike)item, count);
                    } else {
                        stack = new ItemStack((ItemLike)item, item.m_41459_());
                    }
                    int pos = obj.get("position").getAsInt();
                    if (pos >= inv.m_6643_()) {
                        ChestCavity.LOGGER.error("Position component is out of bounds in entry no. " + i + " in " + id.toString() + "'s default chest cavity");
                        continue;
                    }
                    if (forbiddenSlots.contains(pos)) {
                        ChestCavity.LOGGER.error("Position component is forbidden in entry no. " + i + " in " + id.toString() + "'s default chest cavity");
                        continue;
                    }
                    inv.m_6836_(pos, stack);
                    continue;
                }
                ChestCavity.LOGGER.error("Unknown " + itemID.toString() + " in entry no. " + i + " in " + id.toString() + "'s default chest cavity");
            }
            catch (Exception e) {
                ChestCavity.LOGGER.error("Error parsing entry no. " + i + " in " + id.toString() + "'s default chest cavity");
            }
        }
        return inv;
    }

    private Map<ResourceLocation, Float> readBaseOrganScoresFromJson(ResourceLocation id, ChestCavityTypeJsonFormat cctJson) {
        return this.readOrganScoresFromJson(id, cctJson.baseOrganScores);
    }

    private Map<Ingredient, Map<ResourceLocation, Float>> readExceptionalOrgansFromJson(ResourceLocation id, ChestCavityTypeJsonFormat cctJson) {
        HashMap<Ingredient, Map<ResourceLocation, Float>> exceptionalOrgans = new HashMap<Ingredient, Map<ResourceLocation, Float>>();
        int i = 0;
        for (JsonElement entry : cctJson.exceptionalOrgans) {
            ++i;
            try {
                JsonObject obj = entry.getAsJsonObject();
                if (!obj.has("ingredient")) {
                    ChestCavity.LOGGER.error("Missing ingredient component in entry no." + i + " in " + id.toString() + "'s exceptional organs");
                    continue;
                }
                if (!obj.has("value")) {
                    ChestCavity.LOGGER.error("Missing value component in entry no. " + i + " in " + id.toString() + "'s exceptional organs");
                    continue;
                }
                Ingredient ingredient = Ingredient.m_43917_((JsonElement)obj.get("ingredient"));
                exceptionalOrgans.put(ingredient, this.readOrganScoresFromJson(id, obj.get("value").getAsJsonArray()));
            }
            catch (Exception e) {
                ChestCavity.LOGGER.error("Error parsing entry no. " + i + " in " + id.toString() + "'s exceptional organs");
            }
        }
        return exceptionalOrgans;
    }

    private Map<ResourceLocation, Float> readOrganScoresFromJson(ResourceLocation id, JsonArray json) {
        HashMap<ResourceLocation, Float> organScores = new HashMap<ResourceLocation, Float>();
        for (JsonElement entry : json) {
            try {
                JsonObject obj = entry.getAsJsonObject();
                if (!obj.has("id")) {
                    ChestCavity.LOGGER.error("Missing id component in " + id.toString() + "'s organ scores");
                    continue;
                }
                if (!obj.has("value")) {
                    ChestCavity.LOGGER.error("Missing value component in " + id.toString() + "'s organ scores");
                    continue;
                }
                ResourceLocation ability = new ResourceLocation(obj.get("id").getAsString());
                organScores.put(ability, Float.valueOf(obj.get("value").getAsFloat()));
            }
            catch (Exception e) {
                ChestCavity.LOGGER.error("Error parsing " + id.toString() + "'s organ scores!");
            }
        }
        return organScores;
    }

    private List<Integer> readForbiddenSlotsFromJson(ResourceLocation id, ChestCavityTypeJsonFormat cctJson) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (JsonElement entry : cctJson.forbiddenSlots) {
            try {
                int slot = entry.getAsInt();
                list.add(slot);
            }
            catch (Exception e) {
                ChestCavity.LOGGER.error("Error parsing " + id.toString() + "'s organ scores!");
            }
        }
        return list;
    }
}

