/*
 * Decompiled with CFR 0.152.
 */
package net.tigereye.chestcavity.items;

import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.tigereye.chestcavity.ChestCavity;
import net.tigereye.chestcavity.chestcavities.ChestCavityInventory;
import net.tigereye.chestcavity.chestcavities.instance.ChestCavityInstance;
import net.tigereye.chestcavity.interfaces.ChestCavityEntity;
import net.tigereye.chestcavity.registration.CCItems;
import net.tigereye.chestcavity.registration.CCOrganScores;
import net.tigereye.chestcavity.ui.ChestCavityScreenHandler;
import net.tigereye.chestcavity.util.ChestCavityUtil;

public class ChestOpener
extends Item {
    public ChestOpener() {
        super(CCItems.CHEST_OPENER_PROPERTIES);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ChestCavity.printOnDebug("ChestOpener use Called!");
        Player target = player;
        if (this.openChestCavity(player, (LivingEntity)target, false)) {
            return InteractionResultHolder.m_19092_((Object)player.m_21120_(hand), (boolean)false);
        }
        return InteractionResultHolder.m_19098_((Object)player.m_21120_(hand));
    }

    public boolean openChestCavity(Player player, LivingEntity target) {
        return this.openChestCavity(player, target, true);
    }

    public boolean openChestCavity(Player player, LivingEntity target, boolean shouldKnockback) {
        Optional<ChestCavityEntity> optional = ChestCavityEntity.of((Entity)target);
        ChestCavity.printOnDebug("ChestOpener.openChestCavity() called! Optional: " + optional.isPresent());
        ChestCavity.printOnDebug("Target Entity: " + target.toString());
        if (optional.isPresent()) {
            ChestCavityEntity chestCavityEntity = optional.get();
            ChestCavityInstance cc = chestCavityEntity.getChestCavityInstance();
            if (target == player || cc.getChestCavityType().isOpenable(cc)) {
                if (cc.getOrganScore(CCOrganScores.EASE_OF_ACCESS) > 0.0f) {
                    if (player.f_19853_.f_46443_) {
                        player.m_6330_(SoundEvents.f_11749_, SoundSource.PLAYERS, 0.75f, 1.0f);
                    }
                } else if (!shouldKnockback) {
                    target.m_6469_(DamageSource.f_19318_, 4.0f);
                } else {
                    target.m_6469_(DamageSource.m_19344_((Player)player), 4.0f);
                }
                if (target.m_6084_()) {
                    String name;
                    try {
                        name = target.m_5446_().getString();
                        name = name.concat("'s ");
                    }
                    catch (Exception e) {
                        name = "";
                    }
                    ChestCavityInventory inv = ChestCavityUtil.openChestCavity(cc);
                    ((ChestCavityEntity)player).getChestCavityInstance().ccBeingOpened = cc;
                    player.m_5893_((MenuProvider)new SimpleMenuProvider((i, playerInventory, playerEntity) -> new ChestCavityScreenHandler(i, playerInventory, inv), (Component)Component.m_237115_((String)(name + "Chest Cavity"))));
                }
                return true;
            }
            if (player.f_19853_.f_46443_) {
                if (!target.m_6844_(EquipmentSlot.CHEST).m_41619_()) {
                    player.m_5661_((Component)Component.m_237113_((String)"Target's chest is obstructed"), true);
                    player.m_6330_(SoundEvents.f_11744_, SoundSource.PLAYERS, 0.75f, 1.0f);
                } else {
                    player.m_5661_((Component)Component.m_237113_((String)"Target is too healthy to open"), true);
                    player.m_6330_(SoundEvents.f_11680_, SoundSource.PLAYERS, 0.75f, 1.0f);
                }
            }
            return false;
        }
        return false;
    }
}

