/*
 * Decompiled with CFR 0.152.
 */
package net.tigereye.chestcavity.listeners;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.providers.number.BinomialDistributionGenerator;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.tigereye.chestcavity.chestcavities.instance.ChestCavityInstance;
import net.tigereye.chestcavity.chestcavities.organs.OrganManager;
import net.tigereye.chestcavity.interfaces.ChestCavityEntity;
import net.tigereye.chestcavity.recipes.SalvageRecipe;
import net.tigereye.chestcavity.registration.CCEnchantments;
import net.tigereye.chestcavity.registration.CCItems;
import net.tigereye.chestcavity.registration.CCTags;

@Mod.EventBusSubscriber(modid="chestcavity", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class LootRegister {
    private static final ResourceLocation DESERT_PYRAMID_LOOT_TABLE_ID = new ResourceLocation("minecraft", "chests/desert_pyramid");
    private static List<SalvageRecipe> salvageRecipeList;

    public static List<ItemStack> addLoot(LootContext lootContext) {
        ArrayList<ItemStack> loot = new ArrayList<ItemStack>();
        if (lootContext.m_78936_(LootContextParams.f_81456_)) {
            RandomSource random;
            int lootingLevel;
            Object object;
            Entity entity = (Entity)lootContext.m_165124_(LootContextParams.f_81455_);
            Optional<ChestCavityEntity> chestCavityEntity = ChestCavityEntity.of(entity);
            if (chestCavityEntity.isEmpty()) {
                return loot;
            }
            ChestCavityInstance cc = chestCavityEntity.get().getChestCavityInstance();
            if (cc.opened) {
                return loot;
            }
            if (lootContext.m_78936_(LootContextParams.f_81458_) && (object = lootContext.m_165124_(LootContextParams.f_81458_)) instanceof LivingEntity) {
                LivingEntity killer = (LivingEntity)object;
                if (EnchantmentHelper.m_44836_((Enchantment)((Enchantment)CCEnchantments.TOMOPHOBIA.get()), (LivingEntity)killer) > 0) {
                    return loot;
                }
                lootingLevel = EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44982_, (LivingEntity)killer);
                lootingLevel += EnchantmentHelper.m_44836_((Enchantment)((Enchantment)CCEnchantments.SURGICAL.get()), (LivingEntity)killer) * 2;
                if (killer.m_21120_(killer.m_7655_()).m_204117_(CCTags.BUTCHERING_TOOL)) {
                    lootingLevel = 10 + 10 * lootingLevel;
                }
                random = lootContext.m_230907_();
            } else {
                lootingLevel = 0;
                random = RandomSource.m_216327_();
            }
            loot.addAll(cc.getChestCavityType().generateLootDrops(random, lootingLevel));
        }
        return loot;
    }

    public static List<ItemStack> modifyLoot(List<ItemStack> loot, LootContext lootContext) {
        if (lootContext.m_78936_(LootContextParams.f_81458_)) {
            LivingEntity killer = (LivingEntity)lootContext.m_165124_(LootContextParams.f_81458_);
            if (killer.m_21120_(killer.m_7655_()).m_204117_(CCTags.BUTCHERING_TOOL)) {
                HashMap<SalvageRecipe, Integer> salvageResults = new HashMap<SalvageRecipe, Integer>();
                Iterator<ItemStack> i = loot.iterator();
                if (salvageRecipeList == null) {
                    salvageRecipeList = new ArrayList<SalvageRecipe>();
                    List recipes = killer.f_19853_.m_7465_().m_44013_(RecipeType.f_44107_);
                    for (CraftingRecipe craftingRecipe : recipes) {
                        if (!(craftingRecipe instanceof SalvageRecipe)) continue;
                        salvageRecipeList.add((SalvageRecipe)craftingRecipe);
                    }
                }
                block1: while (i.hasNext()) {
                    ItemStack stack = i.next();
                    if (!stack.m_204117_(CCTags.SALVAGEABLE)) continue;
                    for (SalvageRecipe salvageRecipe : salvageRecipeList) {
                        if (!salvageRecipe.getInput().test(stack)) continue;
                        salvageResults.put(salvageRecipe, salvageResults.getOrDefault(salvageRecipe, 0) + stack.m_41613_());
                        i.remove();
                        continue block1;
                    }
                }
                salvageResults.forEach((recipe, count) -> {
                    ItemStack out = recipe.m_8043_();
                    out.m_41764_(out.m_41613_() * (count / recipe.getRequired()));
                    loot.add(out);
                });
            }
            if (EnchantmentHelper.m_44843_((Enchantment)((Enchantment)CCEnchantments.MALPRACTICE.get()), (ItemStack)killer.m_21120_(killer.m_7655_())) > 0) {
                for (ItemStack stack : loot) {
                    if (!OrganManager.isTrueOrgan(stack.m_41720_())) continue;
                    stack.m_41663_((Enchantment)CCEnchantments.MALPRACTICE.get(), 1);
                }
            }
        }
        return loot;
    }

    @SubscribeEvent
    public static void registerDesertPyramidLoot(LootTableLoadEvent event) {
        ResourceLocation id = event.getTable().getLootTableId();
        LootTable table = event.getTable();
        if (DESERT_PYRAMID_LOOT_TABLE_ID.equals((Object)id)) {
            LootPool.Builder poolBuilder = new LootPool.Builder().m_165133_((NumberProvider)BinomialDistributionGenerator.m_165659_((int)4, (float)0.25f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)CCItems.ROTTEN_RIB.get())));
            table.addPool(poolBuilder.m_79082_());
            poolBuilder = new LootPool.Builder().m_165133_((NumberProvider)BinomialDistributionGenerator.m_165659_((int)1, (float)0.3f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)CCItems.ROTTEN_RIB.get())));
            table.addPool(poolBuilder.m_79082_());
        }
    }
}

