/*
 * Decompiled with CFR 0.152.
 */
package net.tigereye.chestcavity.listeners;

import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.tigereye.chestcavity.ChestCavity;
import net.tigereye.chestcavity.chestcavities.instance.ChestCavityInstance;
import net.tigereye.chestcavity.interfaces.CCStatusEffect;
import net.tigereye.chestcavity.interfaces.CCStatusEffectInstance;
import net.tigereye.chestcavity.registration.CCOrganScores;

public class OrganAddStatusEffectListeners {
    public static MobEffectInstance callMethods(LivingEntity livingEntity, ChestCavityInstance chestCavityInstance, MobEffectInstance mobEffectInstance) {
        OrganAddStatusEffectListeners.ApplyBuffPurging(livingEntity, chestCavityInstance, mobEffectInstance);
        OrganAddStatusEffectListeners.ApplyDetoxification(livingEntity, chestCavityInstance, mobEffectInstance);
        OrganAddStatusEffectListeners.ApplyWithered(livingEntity, chestCavityInstance, mobEffectInstance);
        return mobEffectInstance;
    }

    private static MobEffectInstance ApplyBuffPurging(LivingEntity entity, ChestCavityInstance cc, MobEffectInstance instance) {
        if (cc.getOrganScore(CCOrganScores.BUFF_PURGING) > 0.0f && ((CCStatusEffect)instance.m_19544_()).CC_IsBeneficial()) {
            CCStatusEffectInstance ccInstance = (CCStatusEffectInstance)instance;
            ccInstance.CC_setDuration((int)((float)instance.m_19557_() / (1.0f + ChestCavity.config.BUFF_PURGING_DURATION_FACTOR * cc.getOrganScore(CCOrganScores.BUFF_PURGING))));
        }
        return instance;
    }

    private static MobEffectInstance ApplyDetoxification(LivingEntity entity, ChestCavityInstance cc, MobEffectInstance instance) {
        if (cc.getChestCavityType().getDefaultOrganScore(CCOrganScores.DETOXIFICATION) <= 0.0f || cc.getOrganScore(CCOrganScores.DETOXIFICATION) == cc.getChestCavityType().getDefaultOrganScore(CCOrganScores.DETOXIFICATION)) {
            return instance;
        }
        CCStatusEffect ccStatusEffect = (CCStatusEffect)instance.m_19544_();
        if (ccStatusEffect.CC_IsHarmful()) {
            CCStatusEffectInstance ccInstance = (CCStatusEffectInstance)instance;
            float detoxRatio = cc.getOrganScore(CCOrganScores.DETOXIFICATION) / cc.getChestCavityType().getDefaultOrganScore(CCOrganScores.DETOXIFICATION);
            ccInstance.CC_setDuration((int)Math.max(1.0f, (float)(instance.m_19557_() * 2) / (1.0f + detoxRatio)));
        }
        return instance;
    }

    private static MobEffectInstance ApplyFiltration(LivingEntity entity, ChestCavityInstance cc, MobEffectInstance instance) {
        float filtrationDiff = cc.getOrganScore(CCOrganScores.FILTRATION) - cc.getChestCavityType().getDefaultOrganScore(CCOrganScores.FILTRATION);
        if (filtrationDiff > 0.0f && instance.m_19544_() == MobEffects.f_19614_) {
            CCStatusEffectInstance ccInstance = (CCStatusEffectInstance)instance;
            ccInstance.CC_setDuration((int)((float)instance.m_19557_() / (1.0f + ChestCavity.config.FILTRATION_DURATION_FACTOR * cc.getOrganScore(CCOrganScores.FILTRATION))));
        }
        return instance;
    }

    private static MobEffectInstance ApplyWithered(LivingEntity entity, ChestCavityInstance cc, MobEffectInstance instance) {
        if (cc.getOrganScore(CCOrganScores.WITHERED) > 0.0f && instance.m_19544_() == MobEffects.f_19615_) {
            CCStatusEffectInstance ccInstance = (CCStatusEffectInstance)instance;
            ccInstance.CC_setDuration((int)((float)instance.m_19557_() / (1.0f + ChestCavity.config.WITHERED_DURATION_FACTOR * cc.getOrganScore(CCOrganScores.WITHERED))));
        }
        return instance;
    }
}

