/*
 * Decompiled with CFR 0.152.
 */
package net.tigereye.chestcavity.network.packets;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.tigereye.chestcavity.ChestCavity;
import net.tigereye.chestcavity.chestcavities.organs.OrganData;
import net.tigereye.chestcavity.chestcavities.organs.OrganManager;
import net.tigereye.chestcavity.util.OrganDataPacketHelper;

public class OrganDataPacket {
    private int organCount;
    private ArrayList<OrganDataPacketHelper> helpers;

    public OrganDataPacket(int organCount, ArrayList<OrganDataPacketHelper> helpers) {
        System.out.println("ORGAN DATA PACKET MADE!");
        this.organCount = organCount;
        this.helpers = helpers;
    }

    public static OrganDataPacket decode(FriendlyByteBuf buf) {
        int organCount = buf.readInt();
        ArrayList<OrganDataPacketHelper> helpers = new ArrayList<OrganDataPacketHelper>();
        for (int i = 0; i < organCount; ++i) {
            ResourceLocation organID = buf.m_130281_();
            boolean isPseudoOrgan = buf.readBoolean();
            int organAbilityCount = buf.readInt();
            HashMap<ResourceLocation, Float> floatMap = new HashMap<ResourceLocation, Float>();
            for (int j = 0; j < organAbilityCount; ++j) {
                floatMap.put(buf.m_130281_(), Float.valueOf(buf.readFloat()));
            }
            helpers.add(new OrganDataPacketHelper(organID, isPseudoOrgan, organAbilityCount, floatMap));
        }
        return new OrganDataPacket(organCount, helpers);
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.organCount);
        this.helpers.forEach(helper -> {
            buf.m_130085_(helper.getResourceLocation());
            buf.writeBoolean(helper.getPseudoOrgan().booleanValue());
            buf.writeInt(helper.getAbilityCount());
            helper.getMap().forEach((ability, score) -> {
                buf.m_130085_(ability);
                buf.writeFloat(score.floatValue());
            });
        });
    }

    public boolean handle(Supplier<NetworkEvent.Context> contextSupplier) {
        AtomicBoolean success = new AtomicBoolean(false);
        contextSupplier.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            System.out.println("BOONELDAN TEST PACKET RECEIVED");
            OrganManager.GeneratedOrganData.clear();
            this.helpers.forEach(helper -> {
                OrganData organData = new OrganData();
                organData.pseudoOrgan = helper.getPseudoOrgan();
                organData.organScores.putAll(helper.getMap());
                OrganManager.GeneratedOrganData.put(helper.getResourceLocation(), organData);
            });
            ChestCavity.LOGGER.info("loaded " + this.organCount + " organs from server");
            success.set(true);
        }));
        contextSupplier.get().setPacketHandled(true);
        return success.get();
    }
}

