/*
 * Decompiled with CFR 0.152.
 */
package net.tigereye.chestcavity.registration;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.tigereye.chestcavity.ChestCavity;
import net.tigereye.chestcavity.registration.CCOrganScores;

@Mod.EventBusSubscriber(modid="chestcavity", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class CCKeybindings {
    private static final String ORGAN_ABILITY_KEY_CATEGORY = "organ_abilities";
    public static final ResourceLocation UTILITY_ABILITIES_ID = new ResourceLocation("chestcavity", "utility_abilities");
    public static final List<ResourceLocation> UTILITY_ABILITY_LIST = new ArrayList<ResourceLocation>();
    public static final KeyMapping UTILITY_ABILITIES = CCKeybindings.register(UTILITY_ABILITIES_ID, "organ_abilities", 86);
    public static final ResourceLocation ATTACK_ABILITIES_ID = new ResourceLocation("chestcavity", "attack_abilities");
    public static final List<ResourceLocation> ATTACK_ABILITY_LIST = new ArrayList<ResourceLocation>();
    public static final KeyMapping ATTACK_ABILITIES = CCKeybindings.register(ATTACK_ABILITIES_ID, "organ_abilities", 82);
    private static final int DEFAULT_KEY = -1;
    public static final KeyMapping CREEPY = CCKeybindings.register(CCOrganScores.CREEPY, "organ_abilities", -1, true);
    public static final KeyMapping DRAGON_BREATH = CCKeybindings.register(CCOrganScores.DRAGON_BREATH, "organ_abilities", -1, true);
    public static final KeyMapping DRAGON_BOMBS = CCKeybindings.register(CCOrganScores.DRAGON_BOMBS, "organ_abilities", -1, true);
    public static final KeyMapping FORCEFUL_SPIT = CCKeybindings.register(CCOrganScores.FORCEFUL_SPIT, "organ_abilities", -1, true);
    public static final KeyMapping FURNACE_POWERED = CCKeybindings.register(CCOrganScores.FURNACE_POWERED, "organ_abilities", -1, false);
    public static final KeyMapping IRON_REPAIR = CCKeybindings.register(CCOrganScores.IRON_REPAIR, "organ_abilities", -1, false);
    public static final KeyMapping PYROMANCY = CCKeybindings.register(CCOrganScores.PYROMANCY, "organ_abilities", -1, true);
    public static final KeyMapping GHASTLY = CCKeybindings.register(CCOrganScores.GHASTLY, "organ_abilities", -1, true);
    public static final KeyMapping GRAZING = CCKeybindings.register(CCOrganScores.GRAZING, "organ_abilities", -1, false);
    public static final KeyMapping SHULKER_BULLETS = CCKeybindings.register(CCOrganScores.SHULKER_BULLETS, "organ_abilities", -1, true);
    public static final KeyMapping SILK = CCKeybindings.register(CCOrganScores.SILK, "organ_abilities", -1, false);

    public static void init() {
    }

    public static KeyMapping register(ResourceLocation id, String category, int defaultKey) {
        return new KeyMapping("key." + id.m_135827_() + "." + id.m_135815_(), (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, defaultKey, "category." + id.m_135827_() + "." + category);
    }

    public static KeyMapping register(ResourceLocation id, String category, int defaultKey, boolean isAttack) {
        if (isAttack) {
            ATTACK_ABILITY_LIST.add(id);
        } else {
            UTILITY_ABILITY_LIST.add(id);
        }
        return CCKeybindings.register(id, category, defaultKey);
    }

    @SubscribeEvent
    public static void registerKey(RegisterKeyMappingsEvent event) {
        ChestCavity.printOnDebug("RegisterKeyMappingsEvent Fired!");
        event.register(UTILITY_ABILITIES);
        event.register(ATTACK_ABILITIES);
        event.register(CREEPY);
        event.register(DRAGON_BREATH);
        event.register(DRAGON_BOMBS);
        event.register(FORCEFUL_SPIT);
        event.register(FURNACE_POWERED);
        event.register(IRON_REPAIR);
        event.register(PYROMANCY);
        event.register(GHASTLY);
        event.register(GRAZING);
        event.register(SHULKER_BULLETS);
        event.register(SILK);
    }
}

