/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.darkmodeeverywhere;

import com.buuz135.darkmodeeverywhere.DarkConfig;
import com.buuz135.darkmodeeverywhere.DarkModeEverywhere;
import com.buuz135.darkmodeeverywhere.RenderedClassesTracker;
import com.buuz135.darkmodeeverywhere.ShaderConfig;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraftforge.client.event.RegisterShadersEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class ClientProxy {
    public static HashMap<String, Boolean> BLACKLISTED_ELEMENTS = new HashMap();
    public static List<String> MODDED_BLACKLIST = new ArrayList<String>();
    public static ShaderConfig CONFIG = new ShaderConfig();
    public static HashMap<ResourceLocation, ShaderInstance> REGISTERED_SHADERS = new HashMap();
    public static ArrayList<ResourceLocation> REGISTERED_SHADER_LOCATIONS = new ArrayList();
    public static HashMap<ResourceLocation, ShaderConfig.ShaderValue> SHADER_VALUES = new HashMap();
    public static ResourceLocation SELECTED_SHADER = null;

    public ClientProxy() {
        ShaderConfig.load();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::shaderRegister);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onConfigReload);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::imcCallback);
        MinecraftForge.EVENT_BUS.addListener(this::openGui);
    }

    @SubscribeEvent
    public void shaderRegister(RegisterShadersEvent event) {
        REGISTERED_SHADERS = new HashMap();
        REGISTERED_SHADER_LOCATIONS = new ArrayList();
        SHADER_VALUES = new HashMap();
        ArrayList<ResourceLocation> alreadyPendingShaders = new ArrayList<ResourceLocation>();
        for (ShaderConfig.ShaderValue shaderValue : CONFIG.getShaders()) {
            SHADER_VALUES.put(shaderValue.resourceLocation, shaderValue);
            if (alreadyPendingShaders.contains(shaderValue.resourceLocation)) continue;
            try {
                event.registerShader(new ShaderInstance((ResourceProvider)event.getResourceManager(), shaderValue.resourceLocation, DefaultVertexFormat.f_85817_), shaderInstance -> {
                    DarkModeEverywhere.LOGGER.debug("Registered shader " + shaderValue.resourceLocation);
                    REGISTERED_SHADERS.put(shaderValue.resourceLocation, (ShaderInstance)shaderInstance);
                    REGISTERED_SHADER_LOCATIONS.add(shaderValue.resourceLocation);
                });
                alreadyPendingShaders.add(shaderValue.resourceLocation);
            }
            catch (IOException e) {
                DarkModeEverywhere.LOGGER.trace((Object)e);
            }
        }
        if (CONFIG.getSelectedShader() != null) {
            SELECTED_SHADER = new ResourceLocation(CONFIG.getSelectedShader());
        }
        RenderedClassesTracker.start();
    }

    @SubscribeEvent
    public void onConfigReload(ModConfigEvent.Reloading reloading) {
        BLACKLISTED_ELEMENTS.clear();
    }

    private static boolean considerElementNameForBlacklist(String elementName) {
        DarkModeEverywhere.LOGGER.debug("Considering " + elementName + " for element blacklist");
        boolean result = ((List)DarkConfig.CLIENT.METHOD_SHADER_BLACKLIST.get()).stream().anyMatch(elementName::contains);
        BLACKLISTED_ELEMENTS.put(elementName, result);
        RenderedClassesTracker.add(elementName);
        return result;
    }

    public static boolean isElementNameBlacklisted(String elementName) {
        try {
            return BLACKLISTED_ELEMENTS.get(elementName);
        }
        catch (NullPointerException error) {
            return ClientProxy.considerElementNameForBlacklist(elementName);
        }
    }

    @SubscribeEvent
    public void imcCallback(InterModProcessEvent event) {
        event.getIMCStream(string -> string.equals("dme-shaderblacklist")).forEach(imcMessage -> {
            String classMethodBlacklist = (String)imcMessage.messageSupplier().get();
            MODDED_BLACKLIST.add(classMethodBlacklist);
        });
    }

    private ResourceLocation getNextShaderResourceLocation() {
        if (Screen.m_96638_()) {
            return null;
        }
        if (SELECTED_SHADER == null) {
            return REGISTERED_SHADER_LOCATIONS.get(0);
        }
        int nextShaderIndex = REGISTERED_SHADER_LOCATIONS.indexOf(SELECTED_SHADER) + 1;
        if (nextShaderIndex >= REGISTERED_SHADERS.size()) {
            return null;
        }
        return REGISTERED_SHADER_LOCATIONS.get(nextShaderIndex);
    }

    @SubscribeEvent
    public void openGui(ScreenEvent.Init event) {
        if (event.getScreen() instanceof AbstractContainerScreen || ((Boolean)DarkConfig.CLIENT.SHOW_BUTTON_IN_TITLE_SCREEN.get()).booleanValue() && event.getScreen() instanceof TitleScreen) {
            int x = (Integer)DarkConfig.CLIENT.GUI_BUTTON_X_OFFSET.get();
            int y = (Integer)DarkConfig.CLIENT.GUI_BUTTON_Y_OFFSET.get();
            if (event.getScreen() instanceof TitleScreen) {
                x = (Integer)DarkConfig.CLIENT.TITLE_SCREEN_BUTTON_X_OFFSET.get();
                y = (Integer)DarkConfig.CLIENT.TITLE_SCREEN_BUTTON_Y_OFFSET.get();
            }
            event.addListener((GuiEventListener)new Button(x, event.getScreen().f_96544_ - 24 - y, 60, 20, (Component)Component.m_237115_((String)"gui.darkmodeeverywhere.dark_mode"), button -> {
                SELECTED_SHADER = this.getNextShaderResourceLocation();
                CONFIG.setSelectedShader(SELECTED_SHADER);
            }, (button, poseStack, p_93755_, p_93756_) -> {
                ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
                tooltip.add((MutableComponent)(SELECTED_SHADER == null ? Component.m_237115_((String)"gui.darkmodeeverywhere.light_mode") : ClientProxy.SHADER_VALUES.get((Object)ClientProxy.SELECTED_SHADER).displayName));
                tooltip.add(Component.m_237115_((String)"gui.tooltip.darkmodeeverywhere.shader_switch_tooltip").m_130940_(ChatFormatting.GRAY));
                event.getScreen().m_96597_(poseStack, tooltip, p_93755_, p_93756_);
            }));
        }
    }
}

