/*
 * Decompiled with CFR 0.152.
 */
package net.brnbrd.delightful.common.block;

import com.mojang.datafixers.util.Pair;
import java.util.function.Supplier;
import net.brnbrd.delightful.Util;
import net.brnbrd.delightful.common.block.ISliceable;
import net.brnbrd.delightful.data.tags.DelightfulItemTags;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PumpkinBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SlicedPumpkinBlock
extends PumpkinBlock
implements ISliceable {
    private static final VoxelShape BITE1 = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
    private static final VoxelShape BITE2 = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    private static final VoxelShape BITE3 = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);
    public static final IntegerProperty BITES = IntegerProperty.m_61631_((String)"bites", (int)1, (int)3);
    private final Supplier<Item> sliceItem;

    public SlicedPumpkinBlock(BlockBehaviour.Properties pProperties, Supplier<Item> sliceItem) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)BITES, (Comparable)Integer.valueOf(1)));
        this.sliceItem = sliceItem;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return this.byBite(pState);
    }

    public VoxelShape m_7952_(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return this.byBite(pState);
    }

    public VoxelShape byBite(BlockState state) {
        return switch ((Integer)state.m_61143_((Property)BITES)) {
            case 2 -> BITE2;
            case 3 -> BITE3;
            default -> BITE1;
        };
    }

    @Override
    public ItemStack getSliceItem() {
        return new ItemStack((ItemLike)this.sliceItem.get());
    }

    @Override
    public int getMaxBites() {
        return 3;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return this.m_49966_();
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldStack = player.m_21120_(hand);
        if (heldStack.m_204117_(DelightfulItemTags.SCAVENGING_TOOLS)) {
            return this.cutSlice(level, pos, state, player, hand);
        }
        return this.consumeBite(level, pos, state, player);
    }

    protected InteractionResult consumeBite(Level level, BlockPos pos, BlockState state, Player playerIn) {
        if (!playerIn.m_36391_(false)) {
            return InteractionResult.PASS;
        }
        if (!level.m_5776_()) {
            int bites;
            ItemStack sliceStack = this.getSliceItem();
            Item slice = sliceStack.m_41720_();
            FoodProperties sliceFood = slice.getFoodProperties(sliceStack, (LivingEntity)playerIn);
            playerIn.m_36324_().eat(slice, sliceStack, (LivingEntity)playerIn);
            if (slice.m_41472_() && sliceFood != null) {
                for (Pair pair : sliceFood.m_38749_()) {
                    MobEffectInstance effect = (MobEffectInstance)pair.getFirst();
                    if (effect == null || !(level.f_46441_.m_188501_() < ((Float)pair.getSecond()).floatValue())) continue;
                    playerIn.m_7292_(new MobEffectInstance(effect));
                }
            }
            if ((bites = ((Integer)state.m_61143_((Property)BITES)).intValue()) == this.getMaxBites()) {
                level.m_7471_(pos, false);
            } else if (bites < this.getMaxBites()) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)BITES, (Comparable)Integer.valueOf(bites + 1)), 3);
            }
            level.m_5594_(null, pos, SoundEvents.f_11912_, SoundSource.PLAYERS, 0.8f, 0.8f);
        }
        return InteractionResult.m_19078_((boolean)level.m_5776_());
    }

    protected InteractionResult cutSlice(Level level, BlockPos pos, BlockState state, Player player, InteractionHand hand) {
        if (!level.m_5776_()) {
            int bites = (Integer)state.m_61143_((Property)BITES);
            if (bites == this.getMaxBites()) {
                level.m_7471_(pos, false);
            } else if (bites < this.getMaxBites()) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)BITES, (Comparable)Integer.valueOf(bites + 1)), 3);
            }
            Util.dropOrGive(this.getSliceItem(), level, pos, player);
            level.m_5594_(null, pos, SoundEvents.f_12634_, SoundSource.PLAYERS, 0.8f, 0.8f);
            player.m_21120_(hand).m_41622_(1, (LivingEntity)player, onBroken -> onBroken.m_21190_(hand));
        }
        return InteractionResult.m_19078_((boolean)level.m_5776_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BITES});
    }

    public int m_6782_(BlockState blockState, Level level, BlockPos pos) {
        return this.getMaxBites() - (Integer)blockState.m_61143_((Property)BITES);
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }
}

