/*
 * Decompiled with CFR 0.152.
 */
package net.brnbrd.delightful.common.crafting;

import com.google.gson.JsonObject;
import net.brnbrd.delightful.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;

public class EnabledCondition
implements ICondition {
    private static final ResourceLocation NAME = Util.rl("delightful", "enabled");
    private final String value;

    public EnabledCondition(String value) {
        this.value = value;
    }

    public ResourceLocation getID() {
        return NAME;
    }

    public boolean test(ICondition.IContext context) {
        return Util.enabled(this.value);
    }

    public String toString() {
        return "enabled(\"" + this.value + "\")";
    }

    public static class Serializer
    implements IConditionSerializer<EnabledCondition> {
        public static final Serializer INSTANCE = new Serializer();

        public void write(JsonObject json, EnabledCondition condition) {
            json.addProperty("value", condition.value);
        }

        public EnabledCondition read(JsonObject json) {
            return new EnabledCondition(GsonHelper.m_13906_((JsonObject)json, (String)"value"));
        }

        public ResourceLocation getID() {
            return NAME;
        }
    }
}

