/*
 * Decompiled with CFR 0.152.
 */
package net.brnbrd.delightful.common.item.knife;

import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.brnbrd.delightful.common.item.knife.DelightfulKnifeItem;
import net.brnbrd.delightful.compat.Mods;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class CompatKnifeItem
extends DelightfulKnifeItem {
    private final String modid;
    private final Component tool;
    private final ChatFormatting[] formatting;

    public CompatKnifeItem(String modid, TagKey<Item> tag, Tier tier, Item.Properties properties, Supplier<Ingredient> base, ChatFormatting ... formatting) {
        super(tag, tier, properties, base);
        this.modid = modid;
        this.tool = Component.m_237119_();
        this.formatting = formatting;
    }

    public CompatKnifeItem(String modid, TagKey<Item> tag, Tier tier, Item.Properties properties, Component tool, Supplier<Ingredient> base, ChatFormatting ... formatting) {
        super(tag, tier, properties, base);
        this.modid = modid;
        this.tool = tool;
        this.formatting = formatting;
    }

    public String getModid() {
        return this.modid;
    }

    public boolean isLoaded() {
        return Mods.loaded(this.modid);
    }

    @Override
    public boolean isEnabled() {
        return super.isEnabled() && this.isLoaded();
    }

    @Override
    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> tool, @NotNull TooltipFlag pIsAdvanced) {
        if (!this.config()) {
            tool.add((Component)Component.m_237115_((String)"delightful.disabled.desc").m_130940_(ChatFormatting.UNDERLINE));
        } else if (!this.isLoaded()) {
            tool.add((Component)Component.m_237115_((String)"delightful.disabled.requiresmod").m_130940_(ChatFormatting.GRAY));
            tool.add((Component)Component.m_237113_((String)this.modid).m_130940_(ChatFormatting.UNDERLINE));
        } else if (!this.tool.equals(Component.m_237119_())) {
            tool.add(this.tool);
        }
    }

    @NotNull
    public Component m_7626_(@NotNull ItemStack stack) {
        return this.isEnabled() && this.formatting.length > 0 ? super.m_7626_(stack).m_6881_().m_130944_(this.formatting) : super.m_7626_(stack);
    }

    @Override
    protected boolean m_220152_(@NotNull CreativeModeTab ct) {
        return super.m_220152_(ct) && this.isEnabled();
    }
}

