/*
 * Decompiled with CFR 0.152.
 */
package net.brnbrd.delightful.data.gen;

import java.util.Objects;
import net.brnbrd.delightful.Util;
import net.brnbrd.delightful.common.block.DelightfulBlocks;
import net.brnbrd.delightful.common.block.SalmonberryBushBlock;
import net.brnbrd.delightful.common.block.SlicedMelonBlock;
import net.brnbrd.delightful.common.block.SlicedMiniMelonBlock;
import net.brnbrd.delightful.common.block.SlicedPumpkinBlock;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import vectorwing.farmersdelight.common.block.CabinetBlock;
import vectorwing.farmersdelight.common.block.PieBlock;

public class DelightfulBlockStateProvider
extends BlockStateProvider {
    public DelightfulBlockStateProvider(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen, "delightful", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.wildCropBlock((Block)DelightfulBlocks.WILD_SALMONBERRIES.get());
        this.stageBlock((Block)DelightfulBlocks.SALMONBERRY_BUSH.get(), SalmonberryBushBlock.AGE);
        this.simpleBlock((Block)DelightfulBlocks.SALMONBERRY_SACK.get(), (ModelFile)this.models().cubeBottomTop("salmonberry_sack", Util.rl("delightful", "block/salmonberry_sack"), Util.rl("delightful", "block/salmonberry_sack_bottom"), Util.rl("delightful", "block/salmonberry_sack_top")));
        this.simpleBlock((Block)DelightfulBlocks.ACORN_SACK.get(), (ModelFile)this.models().cubeBottomTop("acorn_sack", Util.rl("delightful", "block/acorn_sack"), Util.rl("delightful", "block/acorn_sack_bottom"), Util.rl("delightful", "block/acorn_sack_top")));
        this.simpleBlock((Block)DelightfulBlocks.CANTALOUPE.get(), this.existingModel("cantaloupe"));
        this.simpleBlock((Block)DelightfulBlocks.MINI_MELON.get(), this.existingModel("mini_melon"));
        this.miniMelonBlock((SlicedMiniMelonBlock)DelightfulBlocks.SLICED_MINI_MELON.get());
        this.miniMelonBlock((SlicedMiniMelonBlock)DelightfulBlocks.SLICED_CANTALOUPE.get());
        this.melonBlock((SlicedMelonBlock)DelightfulBlocks.SLICED_MELON.get());
        this.pumpkinBlock((SlicedPumpkinBlock)DelightfulBlocks.SLICED_PUMPKIN.get());
        this.pieBlock(DelightfulBlocks.SALMONBERRY_PIE);
        this.pieBlock(DelightfulBlocks.PUMPKIN_PIE);
        this.pieBlock(DelightfulBlocks.SOURCE_BERRY_PIE);
        this.pieBlock(DelightfulBlocks.GREEN_APPLE_PIE);
        this.pieBlock(DelightfulBlocks.BLUEBERRY_PIE);
        this.pieBlock(DelightfulBlocks.CRIMSON_BERRY_PIE);
        this.pieBlock(DelightfulBlocks.NIGHTSHADE_BERRY_PIE);
        this.cabinet((Block)DelightfulBlocks.BASALT_CABINET.get());
        this.cabinet((Block)DelightfulBlocks.QUARTZ_CABINET.get());
        this.simpleBlock((Block)DelightfulBlocks.SALMONBERRY_ICE_CREAM_BLOCK.get());
        this.simpleBlock((Block)DelightfulBlocks.MATCHA_ICE_CREAM_BLOCK.get());
    }

    public void stageBlock(Block block, IntegerProperty ageProperty) {
        this.getVariantBuilder(block).forAllStates(state -> {
            String stageName = Util.name(block) + "_stage" + state.m_61143_((Property)ageProperty);
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().cross(stageName, this.resourceBlock(stageName))).renderType("cutout")).build();
        });
    }

    public void wildCropBlock(Block block) {
        this.simpleBlock(block, (ModelFile)((BlockModelBuilder)this.models().singleTexture(Util.name(block), Util.rl("farmersdelight", "bush_crop"), "crop", this.resourceBlock(Util.name(block)))).renderType("cutout"));
    }

    public ResourceLocation resourceBlock(String path) {
        return Util.rl("delightful", "block/" + path);
    }

    public void cabinet(Block block) {
        String path = Util.name(block);
        String type = path.replace("_cabinet", "").trim();
        this.horizontalBlock(block, state -> {
            String suffix = (Boolean)state.m_61143_((Property)CabinetBlock.OPEN) != false ? "_open" : "";
            return this.models().orientable(path + suffix, this.resourceBlock(type + "_cabinet_side"), this.resourceBlock(type + "_cabinet_front" + suffix), this.resourceBlock(type + "_cabinet_top"));
        });
    }

    public ModelFile existingModel(String path) {
        return new ModelFile.ExistingModelFile(this.resourceBlock(path), this.models().existingFileHelper);
    }

    public void miniMelonBlock(SlicedMiniMelonBlock block) {
        this.getVariantBuilder((Block)block).forAllStates(state -> ConfiguredModel.builder().modelFile(this.existingModel(Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)block)).m_135815_() + "_bite" + state.m_61143_((Property)SlicedMiniMelonBlock.BITES))).build());
    }

    public void melonBlock(SlicedMelonBlock block) {
        this.getVariantBuilder((Block)block).forAllStates(state -> ConfiguredModel.builder().modelFile(this.existingModel(Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)block)).m_135815_() + "_bite" + state.m_61143_((Property)SlicedMelonBlock.BITES))).build());
    }

    public void pumpkinBlock(SlicedPumpkinBlock block) {
        this.getVariantBuilder((Block)block).forAllStates(state -> ConfiguredModel.builder().modelFile(this.existingModel(Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)block)).m_135815_() + "_bite" + state.m_61143_((Property)SlicedPumpkinBlock.BITES))).build());
    }

    public void pieBlock(RegistryObject<Block> block) {
        this.getVariantBuilder((Block)block.get()).forAllStates(state -> {
            int bites = (Integer)state.m_61143_((Property)PieBlock.BITES);
            String name = Util.name(block);
            Object suffix = bites > 0 ? "_slice" + bites : "";
            BlockModelBuilder mod = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("block/" + name + (String)suffix, Util.rl("farmersdelight", "pie" + (String)suffix))).texture("top", this.resourceBlock(name + "_top"))).texture("bottom", this.resourceBlock(name + "_bottom"))).texture("side", this.resourceBlock(name + "_side"))).texture("particle", this.resourceBlock(name + "_top"));
            if (bites > 0) {
                mod.texture("inner", this.resourceBlock(name + "_inner"));
            }
            return ConfiguredModel.builder().modelFile((ModelFile)mod).rotationY(((int)((Direction)state.m_61143_((Property)PieBlock.FACING)).m_122435_() + 180) % 360).build();
        });
    }
}

