/*
 * Decompiled with CFR 0.152.
 */
package net.brdle.delightful.common.item.knife;

import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.brdle.delightful.common.item.knife.DelightfulKnifeItem;
import net.brdle.delightful.compat.Mods;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class CompatKnifeItem
extends DelightfulKnifeItem {
    private final String modid;
    private final Component tool;
    private final ChatFormatting[] formatting;

    public CompatKnifeItem(String modid, TagKey<Item> tag, Tier tier, Item.Properties properties, Supplier<Ingredient> base, ChatFormatting ... formatting) {
        super(tag, tier, properties, base);
        this.modid = modid;
        this.tool = new TextComponent("");
        this.formatting = formatting;
    }

    public CompatKnifeItem(String modid, TagKey<Item> tag, Tier tier, Item.Properties properties, Component tool, Supplier<Ingredient> base, ChatFormatting ... formatting) {
        super(tag, tier, properties, base);
        this.modid = modid;
        this.tool = tool;
        this.formatting = formatting;
    }

    public String getModid() {
        return this.modid;
    }

    public boolean isLoaded() {
        return Mods.loaded(this.modid);
    }

    @Override
    public boolean isEnabled() {
        return super.isEnabled() && this.isLoaded();
    }

    @Override
    public void m_7373_(@NotNull ItemStack pStack, @Nullable Level pLevel, @NotNull List<Component> tool, @NotNull TooltipFlag pIsAdvanced) {
        if (!this.config()) {
            tool.add((Component)new TranslatableComponent("delightful.disabled.desc").m_130940_(ChatFormatting.UNDERLINE));
        } else if (!this.isLoaded()) {
            tool.add((Component)new TranslatableComponent("delightful.disabled.requires"));
            tool.add((Component)new TextComponent(this.modid).m_130940_(ChatFormatting.UNDERLINE));
        } else if (!this.tool.getString().equals("")) {
            tool.add(this.tool);
        }
    }

    @NotNull
    public Component m_7626_(@NotNull ItemStack stack) {
        if (this.isEnabled() && this.formatting.length > 0) {
            MutableComponent comp = super.m_7626_(stack).m_6881_();
            for (ChatFormatting f : Arrays.stream(this.formatting).toList()) {
                comp = comp.m_130940_(f);
            }
            return comp;
        }
        return super.m_7626_(stack);
    }

    @Override
    protected boolean m_41389_(@NotNull CreativeModeTab pCategory) {
        return super.m_41389_(pCategory) && this.isEnabled();
    }
}

