/*
 * Decompiled with CFR 0.152.
 */
package net.brdle.delightful.common.loot;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.items.ItemHandlerHelper;

public class SmeltLootModifier
extends LootModifier {
    public SmeltLootModifier(LootItemCondition[] conditions) {
        super(conditions);
    }

    @Nonnull
    public List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        return generatedLoot.stream().map(stack -> {
            ItemStack smelted = context.m_78952_().m_7465_().m_44015_(RecipeType.f_44108_, (Container)new SimpleContainer(new ItemStack[]{stack}), (Level)context.m_78952_()).map(AbstractCookingRecipe::m_8043_).filter(itemStack -> !itemStack.m_41619_()).map(itemStack -> ItemHandlerHelper.copyStackWithSize((ItemStack)itemStack, (int)(stack.m_41613_() * itemStack.m_41613_()))).orElse((ItemStack)stack);
            if (smelted != stack) {
                ExperienceOrb.m_147082_((ServerLevel)context.m_78952_(), (Vec3)((Vec3)context.m_165124_(LootContextParams.f_81460_)), (int)(context.m_78933_().nextInt(3) + 1));
            }
            return smelted;
        }).collect(Collectors.toList());
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<SmeltLootModifier> {
        public SmeltLootModifier read(ResourceLocation name, JsonObject json, LootItemCondition[] conditions) {
            return new SmeltLootModifier(conditions);
        }

        public JsonObject write(SmeltLootModifier instance) {
            return this.makeConditions(instance.conditions);
        }
    }
}

