/*
 * Decompiled with CFR 0.152.
 */
package net.brdle.delightful.data.gen;

import java.util.Objects;
import net.brdle.delightful.Util;
import net.brdle.delightful.common.block.DelightfulBlocks;
import net.brdle.delightful.common.block.SlicedMelonBlock;
import net.brdle.delightful.common.block.SlicedMiniMelonBlock;
import net.brdle.delightful.common.block.SlicedPumpkinBlock;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import vectorwing.farmersdelight.common.block.CabinetBlock;
import vectorwing.farmersdelight.common.block.PieBlock;

public class DelightfulBlockStateProvider
extends BlockStateProvider {
    public DelightfulBlockStateProvider(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen, "delightful", exFileHelper);
    }

    protected void registerStatesAndModels() {
        DelightfulBlocks.BLOCKS.getEntries().stream().filter(entry -> entry.get() instanceof CabinetBlock).forEach(cab -> this.cabinet((Block)cab.get()));
        this.wildCropBlock((Block)DelightfulBlocks.WILD_SALMONBERRIES.get());
        this.simpleBlock((Block)DelightfulBlocks.SALMONBERRY_SACK.get(), (ModelFile)this.models().cubeBottomTop("salmonberry_sack", Util.rl("delightful", "block/salmonberry_sack"), Util.rl("delightful", "block/salmonberry_sack_bottom"), Util.rl("delightful", "block/salmonberry_sack_top")));
        this.simpleBlock((Block)DelightfulBlocks.ACORN_SACK.get(), (ModelFile)this.models().cubeBottomTop("acorn_sack", Util.rl("delightful", "block/acorn_sack"), Util.rl("delightful", "block/acorn_sack_bottom"), Util.rl("delightful", "block/acorn_sack_top")));
        this.miniMelonBlock((SlicedMiniMelonBlock)DelightfulBlocks.SLICED_MINI_MELON.get());
        this.miniMelonBlock((SlicedMiniMelonBlock)DelightfulBlocks.SLICED_CANTALOUPE.get());
        this.melonBlock((SlicedMelonBlock)DelightfulBlocks.SLICED_MELON.get());
        this.pumpkinBlock((SlicedPumpkinBlock)DelightfulBlocks.SLICED_PUMPKIN.get());
        this.pieBlock((Block)DelightfulBlocks.SALMONBERRY_PIE.get());
        this.pieBlock((Block)DelightfulBlocks.PUMPKIN_PIE.get());
        this.pieBlock((Block)DelightfulBlocks.SOURCE_BERRY_PIE.get());
        this.pieBlock((Block)DelightfulBlocks.GREEN_APPLE_PIE.get());
        this.pieBlock((Block)DelightfulBlocks.BLUEBERRY_PIE.get());
        this.pieBlock((Block)DelightfulBlocks.CRIMSON_BERRY_PIE.get());
        this.pieBlock((Block)DelightfulBlocks.NIGHTSHADE_BERRY_PIE.get());
    }

    public void wildCropBlock(Block block) {
        this.simpleBlock(block, (ModelFile)this.models().singleTexture(Util.name(block), Util.rl("farmersdelight", "bush_crop"), "crop", this.resourceBlock(Util.name(block))));
    }

    public ResourceLocation resourceBlock(String path) {
        return Util.rl("delightful", "block/" + path);
    }

    public void cabinet(Block block) {
        String path = Util.name(block);
        String type = path.replace("_cabinet", "").trim();
        this.horizontalBlock(block, state -> {
            String suffix = (Boolean)state.m_61143_((Property)CabinetBlock.OPEN) != false ? "_open" : "";
            return this.models().orientable(path + suffix, this.resourceBlock(type + "_cabinet_side"), this.resourceBlock(type + "_cabinet_front" + suffix), this.resourceBlock(type + "_cabinet_top"));
        });
    }

    public ModelFile existingModel(String path) {
        return new ModelFile.ExistingModelFile(this.resourceBlock(path), this.models().existingFileHelper);
    }

    public void miniMelonBlock(SlicedMiniMelonBlock block) {
        this.getVariantBuilder((Block)block).forAllStates(state -> ConfiguredModel.builder().modelFile(this.existingModel(Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)block)).m_135815_() + "_bite" + state.m_61143_((Property)SlicedMiniMelonBlock.BITES))).build());
    }

    public void melonBlock(SlicedMelonBlock block) {
        this.getVariantBuilder((Block)block).forAllStates(state -> ConfiguredModel.builder().modelFile(this.existingModel(Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)block)).m_135815_() + "_bite" + state.m_61143_((Property)SlicedMelonBlock.BITES))).build());
    }

    public void pumpkinBlock(SlicedPumpkinBlock block) {
        this.getVariantBuilder((Block)block).forAllStates(state -> ConfiguredModel.builder().modelFile(this.existingModel(Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)block)).m_135815_() + "_bite" + state.m_61143_((Property)SlicedPumpkinBlock.BITES))).build());
    }

    public void pieBlock(Block block) {
        this.getVariantBuilder(block).forAllStates(state -> {
            int bites = (Integer)state.m_61143_((Property)PieBlock.BITES);
            Object suffix = bites > 0 ? "_slice" + bites : "";
            return ConfiguredModel.builder().modelFile(this.existingModel(Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)block)).m_135815_() + (String)suffix)).rotationY(((int)((Direction)state.m_61143_((Property)PieBlock.FACING)).m_122435_() + 180) % 360).build();
        });
    }
}

