/*
 * Decompiled with CFR 0.152.
 */
package net.brdle.delightful.common.crafting;

import com.google.gson.JsonObject;
import net.brdle.delightful.Util;
import net.brdle.delightful.common.config.DelightfulConfig;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;

public class EnabledCondition
implements ICondition {
    private static final ResourceLocation NAME = Util.rl("delightful", "enabled");
    private final String value;

    public EnabledCondition(String value) {
        this.value = value;
    }

    public ResourceLocation getID() {
        return NAME;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean test(ICondition.IContext context) {
        if (!DelightfulConfig.stuff.containsKey(this.value)) return false;
        if ((Boolean)DelightfulConfig.stuff.get(this.value).get() == false) return false;
        return true;
    }

    public String toString() {
        return "enabled(\"" + this.value + "\")";
    }

    public static class Serializer
    implements IConditionSerializer<EnabledCondition> {
        public static final Serializer INSTANCE = new Serializer();

        public void write(JsonObject json, EnabledCondition condition) {
            json.addProperty("value", condition.value);
        }

        public EnabledCondition read(JsonObject json) {
            return new EnabledCondition(GsonHelper.m_13906_((JsonObject)json, (String)"value"));
        }

        public ResourceLocation getID() {
            return NAME;
        }
    }
}

