/*
 * Decompiled with CFR 0.152.
 */
package net.teamhollow.direbats.entity.direbat;

import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.class_1267;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1314;
import net.minecraft.class_1331;
import net.minecraft.class_1352;
import net.minecraft.class_1366;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1407;
import net.minecraft.class_1408;
import net.minecraft.class_1414;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4051;
import net.minecraft.class_4538;
import net.minecraft.class_5425;
import net.minecraft.class_7;
import net.teamhollow.direbats.init.DBGamerules;
import net.teamhollow.direbats.init.DBSoundEvents;

public class DirebatEntity
extends class_1314 {
    public static final String id = "direbat";
    private static final class_2940<Boolean> HANGING = class_2945.method_12791(DirebatEntity.class, (class_2941)class_2943.field_13323);
    private static final class_4051 CLOSE_PLAYER_PREDICATE = new class_4051().method_18418(4.0).method_18421().method_18420(livingEntity -> !livingEntity.method_5715());
    private int eatingTime;
    private static final Predicate<class_1542> PICKABLE_DROP_FILTER = item -> item != null && !item.method_6977();

    public DirebatEntity(class_1299<? extends DirebatEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6207 = new class_1331((class_1308)this, 20, true);
        this.method_5941(class_7.field_9, -1.0f);
        this.method_5941(class_7.field_18, -1.0f);
        this.method_5941(class_7.field_4, 16.0f);
        this.method_5941(class_7.field_21326, -1.0f);
        this.method_5941(class_7.field_21516, -1.0f);
        this.method_5941(class_7.field_10, -1.0f);
        this.method_5952(true);
        this.field_6194 = 5;
    }

    protected void method_5959() {
        this.field_6185.method_6277(0, (class_1352)new class_1399((class_1314)this, new Class[0]));
        this.field_6201.method_6277(1, (class_1352)new AttackGoal(this));
        this.field_6185.method_6277(1, new TargetGoal<class_1657>(this, class_1657.class));
        this.field_6201.method_6277(2, (class_1352)new PickupItemGoal());
        this.field_6201.method_6277(3, (class_1352)new WanderGoal());
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(HANGING, (Object)false);
    }

    protected class_1408 method_5965(class_1937 worldIn) {
        class_1407 nav = new class_1407((class_1308)this, worldIn){

            public boolean method_6333(class_2338 pos) {
                return !this.field_6677.method_8320(pos.method_10074()).method_26215();
            }
        };
        nav.method_6331(false);
        nav.method_6354(false);
        nav.method_6332(true);
        return nav;
    }

    public class_243 method_26318(class_243 vec3d, float f) {
        this.method_5724(this.getRelevantMoveFactor(f), vec3d);
        this.method_5784(class_1313.field_6308, this.method_18798());
        class_243 motionVector = this.method_18798();
        if ((this.field_5976 || this.field_6282) && this.method_21754()) {
            motionVector = new class_243(motionVector.field_1352, 0.2, motionVector.field_1350);
        }
        return motionVector;
    }

    private float getRelevantMoveFactor(float slipperiness) {
        return this.method_6029() * (0.21600002f / (slipperiness * slipperiness * slipperiness));
    }

    public float method_6144(class_2338 pos, class_4538 world) {
        class_2248 block = world.method_8320(pos).method_26204();
        return block == class_2246.field_10124 || block == class_2246.field_10543 || block == class_2246.field_10243 ? 10.0f * (1.0f / world.method_8597().method_28516(world.method_22339(pos))) : 0.0f;
    }

    protected float method_6107() {
        return 0.15f;
    }

    protected float method_6017() {
        return super.method_6017() * 0.95f;
    }

    public class_3414 method_5994() {
        return this.isHanging() && this.field_5974.nextInt(4) != 0 ? null : DBSoundEvents.ENTITY_DIREBAT_AMBIENT;
    }

    protected class_3414 method_6011(class_1282 source) {
        return DBSoundEvents.ENTITY_DIREBAT_HURT;
    }

    protected class_3414 method_6002() {
        return DBSoundEvents.ENTITY_DIREBAT_DEATH;
    }

    public boolean method_5810() {
        return true;
    }

    public boolean method_5931(class_1657 player) {
        return false;
    }

    protected void method_6087(class_1297 entity) {
    }

    protected void method_6070() {
    }

    public boolean method_5747(float fallDistance, float damageMultiplier) {
        return false;
    }

    protected void method_5623(double heightDifference, boolean onGround, class_2680 landedState, class_2338 landedPos) {
    }

    public boolean isHanging() {
        return (Boolean)this.field_6011.method_12789(HANGING);
    }

    public void setHanging(boolean hanging) {
        this.field_6011.method_12778(HANGING, (Object)hanging);
    }

    public void method_5773() {
        super.method_5773();
        if (this.isHanging()) {
            this.method_18799(class_243.field_1353);
        } else {
            this.method_18799(this.method_18798().method_1021(1.05));
        }
    }

    public void method_6007() {
        boolean isInDaylight = this.method_5972();
        if (isInDaylight) {
            class_1799 itemstack = this.method_6118(class_1304.field_6169);
            if (!itemstack.method_7960()) {
                if (itemstack.method_7963()) {
                    itemstack.method_7974(itemstack.method_7919() + this.field_5974.nextInt(2));
                    if (itemstack.method_7919() >= itemstack.method_7936()) {
                        this.method_20235(class_1304.field_6169);
                        this.method_5673(class_1304.field_6169, class_1799.field_8037);
                    }
                }
                isInDaylight = false;
            }
            if (isInDaylight) {
                this.method_20803(8);
            }
        }
        super.method_6007();
    }

    public void method_6091(class_243 movementInput) {
        if (this.method_6034()) {
            this.method_5724(0.1f, movementInput);
            this.method_5784(class_1313.field_6308, this.method_18798());
            this.method_18799(this.method_18798().method_1021(0.9));
        }
    }

    public void method_5958() {
        super.method_5958();
        class_2338 blockPos = this.method_24515();
        class_2338 blockPosUp = blockPos.method_10084();
        if (this.isHanging()) {
            boolean isSilent = this.method_5701();
            class_1799 mainhandStack = this.method_6118(class_1304.field_6173);
            if (!mainhandStack.method_7960() && mainhandStack.method_19267()) {
                ++this.eatingTime;
                if (this.eatingTime > 600) {
                    class_1799 newStack = mainhandStack.method_7910(this.field_6002, (class_1309)this);
                    if (!newStack.method_7960()) {
                        this.method_5673(class_1304.field_6173, newStack);
                    }
                    this.eatingTime = 0;
                } else if (this.eatingTime > 560 && this.field_5974.nextFloat() < 0.3f) {
                    this.method_5783(this.method_18869(mainhandStack), 1.0f, 1.0f);
                    if (this.field_6002.field_9236) {
                        this.spawnItemParticles(mainhandStack, 10);
                    }
                    this.field_6002.method_8421((class_1297)this, (byte)45);
                }
            }
            if (this.method_5968() != null) {
                this.setHanging(false);
            }
            if (this.field_6002.method_8320(blockPosUp).method_26234((class_1922)this.field_6002, blockPos)) {
                if (this.field_5974.nextInt(200) == 0) {
                    this.field_6241 = this.field_5974.nextInt(360);
                }
                if (this.field_6002.method_18462(CLOSE_PLAYER_PREDICATE, (class_1309)this) != null) {
                    this.setHanging(false);
                    if (!isSilent) {
                        this.field_6002.method_8444(null, 1025, blockPos, 0);
                    }
                }
            } else {
                this.setHanging(false);
                if (!isSilent) {
                    this.field_6002.method_8444(null, 1025, blockPos, 0);
                }
            }
            this.method_18800(0.0, 0.0, 0.0);
            this.method_5942().method_6340();
        } else if (this.method_5968() == null && this.field_5974.nextInt(20) == 0 && this.field_6002.method_8320(blockPosUp).method_26234((class_1922)this.field_6002, blockPosUp) && this.field_6002.method_18462(CLOSE_PLAYER_PREDICATE, (class_1309)this) == null) {
            this.setHanging(true);
        }
    }

    private void spawnItemParticles(class_1799 itemStack, int count) {
        for (int i = 0; i < count; ++i) {
            class_243 vec3d = new class_243(((double)this.field_5974.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
            vec3d = vec3d.method_1024(-this.field_5965 * ((float)Math.PI / 180));
            vec3d = vec3d.method_31033(-this.field_6031 * ((float)Math.PI / 180));
            double d = (double)(-this.field_5974.nextFloat()) * 0.6 - 0.3;
            class_243 vec3d2 = new class_243(((double)this.field_5974.nextFloat() - 0.5) * 0.3, d, 0.6);
            vec3d2 = vec3d2.method_1024(-this.field_5965 * ((float)Math.PI / 180));
            vec3d2 = vec3d2.method_31033(-this.field_6031 * ((float)Math.PI / 180));
            vec3d2 = vec3d2.method_1031(this.method_23317(), this.method_23320(), this.method_23321());
            this.field_6002.method_8406((class_2394)new class_2392(class_2398.field_11218, itemStack), vec3d2.field_1352, vec3d2.field_1351, vec3d2.field_1350, vec3d.field_1352, vec3d.field_1351 + 0.05, vec3d.field_1350);
        }
    }

    public boolean method_6121(class_1297 target) {
        if (super.method_6121(target)) {
            if (target instanceof class_1309) {
                int seconds = 5;
                if (this.field_6002.method_8407() == class_1267.field_5807) {
                    seconds = 10;
                }
                ((class_1309)target).method_6092(new class_1293(class_1294.field_5919, seconds * 20, 0));
            }
            this.method_5783(DBSoundEvents.ENTITY_DIREBAT_ATTACK, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    public boolean method_5643(class_1282 damageSource, float amount) {
        if (this.method_5679(damageSource)) {
            return false;
        }
        if (!this.field_6002.field_9236 && this.isHanging()) {
            this.setHanging(false);
        }
        this.method_16078();
        return super.method_5643(damageSource, amount);
    }

    protected void method_5949(class_1542 itemEntity) {
        class_1799 newItem = itemEntity.method_6983();
        class_1799 currentItem = this.method_6118(class_1304.field_6173);
        if (currentItem.method_7960() && this.field_6002.method_8450().method_8355(DBGamerules.DIREBAT_ITEM_PICKUP) && PICKABLE_DROP_FILTER.test(itemEntity)) {
            this.method_24834(class_1304.field_6173, newItem);
            this.method_29499(itemEntity);
            this.method_6103((class_1297)itemEntity, newItem.method_7947());
            itemEntity.method_5650();
        }
    }

    protected void method_16078() {
        super.method_16078();
        if (!this.method_5998(class_1268.field_5808).method_7960()) {
            this.method_5775(this.method_6047());
            this.method_6122(class_1268.field_5808, new class_1799((class_1935)class_1802.field_8162));
        }
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.field_6011.method_12778(HANGING, (Object)tag.method_10577("Hanging"));
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10556("Hanging", ((Boolean)this.field_6011.method_12789(HANGING)).booleanValue());
    }

    public static boolean canSpawn(class_1299<DirebatEntity> type, class_5425 world, class_3730 spawnReason, class_2338 pos, Random random) {
        if (pos.method_10264() >= world.method_8615()) {
            return world.method_8410().method_23886() && world.method_30272() == 1.0f;
        }
        int worldLight = world.method_22339(pos);
        int maximumLight = 4;
        if (DirebatEntity.isTodayAroundHalloween()) {
            maximumLight = 7;
        }
        return worldLight <= random.nextInt(maximumLight) && DirebatEntity.method_20636(type, (class_1936)world, (class_3730)spawnReason, (class_2338)pos, (Random)random);
    }

    private static boolean isTodayAroundHalloween() {
        LocalDate localDate = LocalDate.now();
        int day = localDate.get(ChronoField.DAY_OF_MONTH);
        int month = localDate.get(ChronoField.MONTH_OF_YEAR);
        return month == 10 && day >= 20 || month == 11 && day <= 3;
    }

    public boolean method_5974(double distanceSquared) {
        return this.method_6047().method_7960();
    }

    protected float method_18394(class_4050 entityPose, class_4048 dimensions) {
        return dimensions.field_18068 / 2.0f;
    }

    private boolean isWithinDistance(class_2338 pos, int distance) {
        return pos.method_19771((class_2382)this.method_24515(), (double)distance);
    }

    protected boolean method_23734() {
        return true;
    }

    static class TargetGoal<T extends class_1309>
    extends class_1400<T> {
        public TargetGoal(DirebatEntity entity, Class<T> classTarget) {
            super((class_1308)entity, classTarget, true);
        }

        public boolean method_6264() {
            float goalOwnerBrightness = this.field_6660.method_5718();
            return !(goalOwnerBrightness <= 0.5f) && super.method_6264() && !this.field_6644.method_5715();
        }
    }

    class PickupItemGoal
    extends class_1352 {
        public PickupItemGoal() {
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            if (!DirebatEntity.this.method_5998(class_1268.field_5808).method_7960()) {
                return false;
            }
            if (DirebatEntity.this.method_5968() == null) {
                List list = DirebatEntity.this.field_6002.method_8390(class_1542.class, DirebatEntity.this.method_5829().method_1009(8.0, 8.0, 8.0), PICKABLE_DROP_FILTER);
                return !list.isEmpty() && DirebatEntity.this.method_5998(class_1268.field_5808).method_7960();
            }
            return false;
        }

        public boolean method_6266() {
            return DirebatEntity.this.field_6189.method_23966();
        }

        public void method_6268() {
            List list = DirebatEntity.this.field_6002.method_8390(class_1542.class, DirebatEntity.this.method_5829().method_1009(8.0, 8.0, 8.0), PICKABLE_DROP_FILTER);
            class_1799 itemInHand = DirebatEntity.this.method_5998(class_1268.field_5808);
            if (itemInHand.method_7960() && !list.isEmpty()) {
                DirebatEntity.this.method_5942().method_6335((class_1297)list.get(0), (double)1.2f);
            }
        }

        public void method_6269() {
            List list = DirebatEntity.this.field_6002.method_8390(class_1542.class, DirebatEntity.this.method_5829().method_1009(8.0, 8.0, 8.0), PICKABLE_DROP_FILTER);
            if (!list.isEmpty()) {
                DirebatEntity.this.method_5942().method_6335((class_1297)list.get(0), (double)1.2f);
            }
            DirebatEntity.this.setHanging(false);
        }
    }

    class WanderGoal
    extends class_1352 {
        WanderGoal() {
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            return DirebatEntity.this.field_6189.method_6357() && !DirebatEntity.this.isHanging() && DirebatEntity.this.field_5974.nextInt(5) == 0;
        }

        public boolean method_6266() {
            return DirebatEntity.this.field_6189.method_23966();
        }

        public void method_6269() {
            class_243 randomLocation = this.getRandomLocation();
            if (randomLocation != null) {
                DirebatEntity.this.field_6189.method_6334(DirebatEntity.this.field_6189.method_6348(new class_2338(randomLocation), 1), 1.0);
            }
        }

        private class_243 getRandomLocation() {
            class_243 vector3d;
            if (DirebatEntity.this.method_18410() && !DirebatEntity.this.isWithinDistance(DirebatEntity.this.method_18412(), 22)) {
                class_243 vector3d1 = class_243.method_24953((class_2382)DirebatEntity.this.method_18412());
                vector3d = vector3d1.method_1020(DirebatEntity.this.method_19538()).method_1029();
            } else {
                vector3d = DirebatEntity.this.method_5828(0.0f);
            }
            class_243 vector3d2 = class_1414.method_21757((class_1314)DirebatEntity.this, (int)8, (int)7, (class_243)vector3d, (float)1.5707964f, (int)2, (int)1);
            return vector3d2 != null ? vector3d2 : class_1414.method_21756((class_1314)DirebatEntity.this, (int)8, (int)4, (int)-2, (class_243)vector3d, (double)1.5707963705062866);
        }
    }

    static class AttackGoal
    extends class_1366 {
        public AttackGoal(DirebatEntity entity) {
            super((class_1314)entity, 1.0, true);
        }

        public boolean method_6266() {
            float mobBrightness = this.field_6503.method_5718();
            if (mobBrightness <= 0.5f && this.field_6503.method_6051().nextInt(100) == 0) {
                this.field_6503.method_5980(null);
                return false;
            }
            return super.method_6266();
        }
    }
}

