/*
 * Decompiled with CFR 0.152.
 */
package net.teamhollow.direbats;

import net.minecraft.entity.EntityClassification;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.teamhollow.direbats.entity.direbat.DirebatEntityRenderer;
import net.teamhollow.direbats.entity.direbat_fang_arrow.DirebatFangArrowEntityRenderer;
import net.teamhollow.direbats.init.DBConfig;
import net.teamhollow.direbats.init.DBEntities;
import net.teamhollow.direbats.init.DBItems;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="direbats")
public class Direbats {
    public static final String MOD_ID = "direbats";
    public static final String MOD_NAME = "Direbats";
    public static final Logger LOGGER = LogManager.getLogger((String)"direbats");
    public static final ItemGroup ITEM_GROUP = new ItemGroup(new ResourceLocation("direbats", "item_group").toString()){

        @OnlyIn(value=Dist.CLIENT)
        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)DBItems.DIREBAT_FANG);
        }
    };

    public Direbats() {
        Direbats.log("Initializing");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, DBConfig.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.addListener(Direbats::onBiomesLoaded);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
        DBConfig.loadConfig();
        Direbats.log("Initialized");
    }

    public static void onBiomesLoaded(BiomeLoadingEvent event) {
        Biome.Category cat = event.getCategory();
        if (cat == Biome.Category.FOREST || cat == Biome.Category.TAIGA) {
            event.getSpawns().func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(DBEntities.DIREBAT, 200, 1, 4));
        }
    }

    private void clientSetup(FMLClientSetupEvent event) {
        Direbats.log("Initializing client");
        RenderingRegistry.registerEntityRenderingHandler(DBEntities.DIREBAT, DirebatEntityRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(DBEntities.DIREBAT_FANG_ARROW, DirebatFangArrowEntityRenderer::new);
        Direbats.log("Initialized client");
    }

    public static void log(Level level, String message) {
        LOGGER.log(level, "[Direbats] " + message);
    }

    public static void log(String message) {
        Direbats.log(Level.INFO, message);
    }

    public static ResourceLocation texture(String path) {
        return new ResourceLocation(MOD_ID, "textures/" + path + ".png");
    }
}

