/*
 * Decompiled with CFR 0.152.
 */
package net.teamhollow.direbats.entity.direbat;

import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.FlyingMovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.teamhollow.direbats.init.DBConfig;
import net.teamhollow.direbats.init.DBSoundEvents;

public class DirebatEntity
extends CreatureEntity {
    public static final String id = "direbat";
    private static final DataParameter<Boolean> HANGING = EntityDataManager.func_187226_a(DirebatEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final EntityPredicate CLOSE_PLAYER_PREDICATE = new EntityPredicate().func_221013_a(4.0).func_221011_b().func_221012_a(livingEntity -> !livingEntity.func_225608_bj_());
    private int eatingTime;
    private static final Predicate<ItemEntity> PICKABLE_DROP_FILTER = item -> item != null && !item.func_174874_s();

    public DirebatEntity(EntityType<? extends DirebatEntity> entityType, World world) {
        super(entityType, world);
        this.field_70765_h = new FlyingMovementController((MobEntity)this, 20, true);
        this.func_184644_a(PathNodeType.DANGER_FIRE, -1.0f);
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        this.func_184644_a(PathNodeType.WATER_BORDER, 16.0f);
        this.func_184644_a(PathNodeType.STICKY_HONEY, -1.0f);
        this.func_184644_a(PathNodeType.COCOA, -1.0f);
        this.func_184644_a(PathNodeType.FENCE, -1.0f);
        this.func_98053_h(true);
        this.field_70728_aV = 5;
    }

    public ILivingEntityData func_213386_a(IServerWorld world, DifficultyInstance difficulty, SpawnReason reason, ILivingEntityData entityData, CompoundNBT nbt) {
        this.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_() + 1.0E-13, this.func_226281_cx_());
        return super.func_213386_a(world, difficulty, reason, entityData, nbt);
    }

    protected void func_184651_r() {
        this.field_70715_bh.func_75776_a(0, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70714_bg.func_75776_a(1, (Goal)new AttackGoal(this));
        this.field_70715_bh.func_75776_a(1, new TargetGoal<PlayerEntity>(this, PlayerEntity.class));
        this.field_70714_bg.func_75776_a(2, (Goal)new PickupItemGoal());
        this.field_70714_bg.func_75776_a(3, (Goal)new WanderGoal());
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HANGING, (Object)false);
    }

    public static AttributeModifierMap.MutableAttribute getAttributeMap() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 16.0).func_233815_a_(Attributes.field_233822_e_, 0.22).func_233815_a_(Attributes.field_233821_d_, 0.22).func_233815_a_(Attributes.field_233823_f_, 2.0);
    }

    protected PathNavigator func_175447_b(final World worldIn) {
        FlyingPathNavigator nav = new FlyingPathNavigator((MobEntity)this, worldIn){

            public boolean func_188555_b(BlockPos pos) {
                BlockState state = this.field_75513_b.func_180495_p(pos.func_177977_b());
                BlockPos posDown = pos.func_177977_b();
                return !state.func_177230_c().isAir(state, (IBlockReader)worldIn, posDown);
            }
        };
        nav.func_192879_a(false);
        nav.func_212239_d(false);
        nav.func_192878_b(true);
        return nav;
    }

    public Vector3d func_233633_a_(Vector3d p_233633_1_, float p_233633_2_) {
        this.func_213309_a(this.getRelevantMoveFactor(p_233633_2_), p_233633_1_);
        this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        Vector3d motionVector = this.func_213322_ci();
        if ((this.field_70123_F || this.field_70703_bu) && this.func_70617_f_()) {
            motionVector = new Vector3d(motionVector.field_72450_a, 0.2, motionVector.field_72449_c);
        }
        return motionVector;
    }

    private float getRelevantMoveFactor(float slipperiness) {
        return this.func_70689_ay() * (0.20600002f / (slipperiness * slipperiness * slipperiness));
    }

    public float func_205022_a(BlockPos pos, IWorldReader worldIn) {
        Block block = worldIn.func_180495_p(pos).func_177230_c();
        return block == Blocks.field_150350_a || block == Blocks.field_201941_jj || block == Blocks.field_201940_ji ? 10.0f * (1.0f / worldIn.func_230315_m_().func_236021_a_(worldIn.func_201696_r(pos))) : 0.0f;
    }

    protected float func_70599_aP() {
        return 0.15f;
    }

    protected float func_70647_i() {
        return super.func_70647_i() * 0.95f;
    }

    public SoundEvent func_184639_G() {
        return this.isHanging() && this.field_70146_Z.nextInt(4) != 0 ? null : DBSoundEvents.ENTITY_DIREBAT_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return DBSoundEvents.ENTITY_DIREBAT_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return DBSoundEvents.ENTITY_DIREBAT_DEATH;
    }

    public boolean func_70104_M() {
        return true;
    }

    public boolean func_184652_a(PlayerEntity player) {
        return false;
    }

    protected void func_82167_n(Entity entityIn) {
    }

    protected void func_85033_bc() {
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public boolean isHanging() {
        return (Boolean)this.field_70180_af.func_187225_a(HANGING);
    }

    public void setHanging(boolean hanging) {
        this.field_70180_af.func_187227_b(HANGING, (Object)hanging);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.isHanging()) {
            this.func_213317_d(Vector3d.field_186680_a);
        }
    }

    public void func_70636_d() {
        boolean isInDaylight = this.func_204609_dp();
        if (isInDaylight) {
            ItemStack itemstack = this.func_184582_a(EquipmentSlotType.HEAD);
            if (!itemstack.func_190926_b()) {
                if (itemstack.func_77984_f()) {
                    itemstack.func_196085_b(itemstack.func_77952_i() + this.field_70146_Z.nextInt(2));
                    if (itemstack.func_77952_i() >= itemstack.func_77958_k()) {
                        this.func_213361_c(EquipmentSlotType.HEAD);
                        this.func_184201_a(EquipmentSlotType.HEAD, ItemStack.field_190927_a);
                    }
                }
                isInDaylight = false;
            }
            if (isInDaylight) {
                this.func_70015_d(8);
            }
        }
        super.func_70636_d();
    }

    public void func_213352_e(Vector3d travelVector) {
        if (this.func_70613_aW()) {
            this.func_213309_a(0.1f, travelVector);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.9));
        }
    }

    public void func_70619_bc() {
        super.func_70619_bc();
        BlockPos blockPos = this.func_233580_cy_();
        BlockPos blockPosUp = blockPos.func_177984_a();
        if (this.isHanging()) {
            boolean isSilent = this.func_174814_R();
            ItemStack mainhandStack = this.func_184582_a(EquipmentSlotType.MAINHAND);
            if (!mainhandStack.func_190926_b() && mainhandStack.func_222117_E()) {
                ++this.eatingTime;
                if (this.eatingTime > 600) {
                    ItemStack newStack = mainhandStack.func_77950_b(this.field_70170_p, (LivingEntity)this);
                    if (!newStack.func_190926_b()) {
                        this.func_184201_a(EquipmentSlotType.MAINHAND, newStack);
                    }
                    this.eatingTime = 0;
                } else if (this.eatingTime > 560 && this.field_70146_Z.nextFloat() < 0.3f) {
                    this.func_184185_a(this.func_213353_d(mainhandStack), 1.0f, 1.0f);
                    this.spawnItemParticles(mainhandStack, 10);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)45);
                }
            }
            if (this.func_70638_az() != null) {
                this.setHanging(false);
            }
            if (this.field_70170_p.func_180495_p(blockPosUp).func_215686_e((IBlockReader)this.field_70170_p, blockPos)) {
                if (this.field_70146_Z.nextInt(200) == 0) {
                    this.field_70759_as = this.field_70146_Z.nextInt(360);
                }
                if (this.field_70170_p.func_217370_a(CLOSE_PLAYER_PREDICATE, (LivingEntity)this) != null) {
                    this.setHanging(false);
                    if (!isSilent) {
                        this.field_70170_p.func_217378_a(null, 1025, blockPos, 0);
                    }
                }
            } else {
                this.setHanging(false);
                if (!isSilent) {
                    this.field_70170_p.func_217378_a(null, 1025, blockPos, 0);
                }
            }
            this.func_213293_j(0.0, 0.0, 0.0);
            this.func_70661_as().func_75499_g();
        } else if (this.func_70638_az() == null && this.field_70146_Z.nextInt(20) == 0 && this.field_70170_p.func_180495_p(blockPosUp).func_215686_e((IBlockReader)this.field_70170_p, blockPosUp) && this.field_70170_p.func_217370_a(CLOSE_PLAYER_PREDICATE, (LivingEntity)this) == null) {
            this.setHanging(true);
        }
    }

    private void spawnItemParticles(ItemStack stack, int count) {
        for (int i = 0; i < count; ++i) {
            Vector3d vec3d = new Vector3d(((double)this.field_70146_Z.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
            vec3d = vec3d.func_178789_a(-this.field_70125_A * ((float)Math.PI / 180));
            vec3d = vec3d.func_178785_b(-this.field_70177_z * ((float)Math.PI / 180));
            double d = (double)(-this.field_70146_Z.nextFloat()) * 0.6 - 0.3;
            Vector3d vec3d2 = new Vector3d(((double)this.field_70146_Z.nextFloat() - 0.5) * 0.3, d, 0.6);
            vec3d2 = vec3d2.func_178789_a(-this.field_70125_A * ((float)Math.PI / 180));
            vec3d2 = vec3d2.func_178785_b(-this.field_70177_z * ((float)Math.PI / 180));
            vec3d2 = vec3d2.func_72441_c(this.func_226277_ct_(), this.func_226280_cw_(), this.func_226281_cx_());
            this.field_70170_p.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, stack), vec3d2.field_72450_a, vec3d2.field_72448_b, vec3d2.field_72449_c, vec3d.field_72450_a, vec3d.field_72448_b + 0.05, vec3d.field_72449_c);
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        if (super.func_70652_k(entityIn)) {
            if (entityIn instanceof LivingEntity) {
                int seconds = 5;
                if (this.field_70170_p.func_175659_aa() == Difficulty.HARD) {
                    seconds = 10;
                }
                ((LivingEntity)entityIn).func_195064_c(new EffectInstance(Effects.field_76440_q, seconds * 20, 0));
            }
            this.func_184185_a(DBSoundEvents.ENTITY_DIREBAT_ATTACK, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && this.isHanging()) {
            this.setHanging(false);
        }
        this.func_213337_cE();
        return super.func_70097_a(source, amount);
    }

    protected void func_175445_a(ItemEntity entity) {
        ItemStack newItem = entity.func_92059_d();
        ItemStack currentItem = this.func_184582_a(EquipmentSlotType.MAINHAND);
        if (currentItem.func_190926_b() && ((Boolean)DBConfig.DIREBAT_ITEM_PICKUP.get()).booleanValue() && PICKABLE_DROP_FILTER.test(entity)) {
            this.func_233657_b_(EquipmentSlotType.MAINHAND, newItem);
            this.func_233630_a_(entity);
            this.func_71001_a((Entity)entity, newItem.func_190916_E());
            entity.func_70106_y();
        }
    }

    protected void func_213337_cE() {
        super.func_213337_cE();
        if (!this.func_184586_b(Hand.MAIN_HAND).func_190926_b()) {
            this.func_199701_a_(this.func_184614_ca());
            this.func_184611_a(Hand.MAIN_HAND, new ItemStack((IItemProvider)Items.field_190931_a));
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.field_70180_af.func_187227_b(HANGING, (Object)compound.func_74767_n("Hanging"));
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("Hanging", ((Boolean)this.field_70180_af.func_187225_a(HANGING)).booleanValue());
    }

    public static boolean canSpawn(EntityType<DirebatEntity> type, IServerWorld world, SpawnReason spawnReason, BlockPos pos, Random random) {
        if (pos.func_177956_o() >= world.func_181545_F()) {
            return world.func_201672_e().func_226690_K_() && world.func_242413_ae() == 1.0f;
        }
        int worldLight = world.func_201696_r(pos);
        int maximumLight = 4;
        if (DirebatEntity.isTodayAroundHalloween()) {
            maximumLight = 7;
        }
        return worldLight <= random.nextInt(maximumLight) && DirebatEntity.func_223315_a(type, (IWorld)world, (SpawnReason)spawnReason, (BlockPos)pos, (Random)random);
    }

    private static boolean isTodayAroundHalloween() {
        LocalDate localDate = LocalDate.now();
        int day = localDate.get(ChronoField.DAY_OF_MONTH);
        int month = localDate.get(ChronoField.MONTH_OF_YEAR);
        return month == 10 && day >= 20 || month == 11 && day <= 3;
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return this.func_184614_ca().func_190926_b();
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return sizeIn.field_220316_b / 2.0f;
    }

    private boolean isWithinDistance(BlockPos pos, int distance) {
        return pos.func_218141_a((Vector3i)this.func_233580_cy_(), (double)distance);
    }

    protected boolean func_225511_J_() {
        return true;
    }

    static class TargetGoal<T extends LivingEntity>
    extends NearestAttackableTargetGoal<T> {
        public TargetGoal(DirebatEntity entity, Class<T> classTarget) {
            super((MobEntity)entity, classTarget, true);
        }

        public boolean func_75250_a() {
            float goalOwnerBrightness = this.field_75299_d.func_70013_c();
            return !(goalOwnerBrightness <= 0.5f) && super.func_75250_a() && !this.field_75309_a.func_225608_bj_();
        }
    }

    class PickupItemGoal
    extends Goal {
        public PickupItemGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            if (!DirebatEntity.this.func_184586_b(Hand.MAIN_HAND).func_190926_b() || !((Boolean)DBConfig.DIREBAT_ITEM_PICKUP.get()).booleanValue()) {
                return false;
            }
            if (DirebatEntity.this.func_70638_az() == null && DirebatEntity.this.func_94060_bK() == null) {
                List list = DirebatEntity.this.field_70170_p.func_175647_a(ItemEntity.class, DirebatEntity.this.func_174813_aQ().func_72321_a(8.0, 8.0, 8.0), PICKABLE_DROP_FILTER);
                return !list.isEmpty() && DirebatEntity.this.func_184586_b(Hand.MAIN_HAND).func_190926_b();
            }
            return false;
        }

        public boolean func_75253_b() {
            return DirebatEntity.this.field_70699_by.func_226337_n_();
        }

        public void func_75246_d() {
            List list = DirebatEntity.this.field_70170_p.func_175647_a(ItemEntity.class, DirebatEntity.this.func_174813_aQ().func_72321_a(8.0, 8.0, 8.0), PICKABLE_DROP_FILTER);
            ItemStack itemInHand = DirebatEntity.this.func_184586_b(Hand.MAIN_HAND);
            if (itemInHand.func_190926_b() && !list.isEmpty()) {
                DirebatEntity.this.func_70661_as().func_75497_a((Entity)list.get(0), (double)1.2f);
            }
        }

        public void func_75249_e() {
            List list = DirebatEntity.this.field_70170_p.func_175647_a(ItemEntity.class, DirebatEntity.this.func_174813_aQ().func_72321_a(8.0, 8.0, 8.0), PICKABLE_DROP_FILTER);
            if (!list.isEmpty()) {
                DirebatEntity.this.func_70661_as().func_75497_a((Entity)list.get(0), (double)1.2f);
            }
            DirebatEntity.this.setHanging(false);
        }
    }

    class WanderGoal
    extends Goal {
        WanderGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return DirebatEntity.this.field_70699_by.func_75500_f() && !DirebatEntity.this.isHanging() && DirebatEntity.this.field_70146_Z.nextInt(5) == 0;
        }

        public boolean func_75253_b() {
            return DirebatEntity.this.field_70699_by.func_226337_n_();
        }

        public void func_75249_e() {
            Vector3d randomLocation = this.getRandomLocation();
            if (randomLocation != null) {
                DirebatEntity.this.field_70699_by.func_75484_a(DirebatEntity.this.field_70699_by.func_179680_a(new BlockPos(randomLocation), 1), 1.0);
            }
        }

        @Nullable
        private Vector3d getRandomLocation() {
            Vector3d vector3d;
            if (DirebatEntity.this.func_213394_dL() && !DirebatEntity.this.isWithinDistance(DirebatEntity.this.func_213384_dI(), 22)) {
                Vector3d vector3d1 = Vector3d.func_237489_a_((Vector3i)DirebatEntity.this.func_213384_dI());
                vector3d = vector3d1.func_178788_d(DirebatEntity.this.func_213303_ch()).func_72432_b();
            } else {
                vector3d = DirebatEntity.this.func_70676_i(0.0f);
            }
            Vector3d vector3d2 = RandomPositionGenerator.func_226340_a_((CreatureEntity)DirebatEntity.this, (int)8, (int)7, (Vector3d)vector3d, (float)1.5707964f, (int)2, (int)1);
            return vector3d2 != null ? vector3d2 : RandomPositionGenerator.func_226338_a_((CreatureEntity)DirebatEntity.this, (int)8, (int)4, (int)-2, (Vector3d)vector3d, (double)1.5707963705062866);
        }
    }

    static class AttackGoal
    extends MeleeAttackGoal {
        public AttackGoal(DirebatEntity entity) {
            super((CreatureEntity)entity, 1.0, true);
        }

        public boolean func_75253_b() {
            float attackerBrightness = this.field_75441_b.func_70013_c();
            if (attackerBrightness <= 0.5f && this.field_75441_b.func_70681_au().nextInt(100) == 0) {
                this.field_75441_b.func_70624_b(null);
                return false;
            }
            return super.func_75253_b();
        }
    }
}

