/*
 * Decompiled with CFR 0.152.
 */
package net.teamhollow.direbats.init;

import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="direbats", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DBSoundEvents {
    public static final SoundEvent ENTITY_DIREBAT_AMBIENT = DBSoundEvents.createDirebatSound("ambient");
    public static final SoundEvent ENTITY_DIREBAT_HURT = DBSoundEvents.createDirebatSound("hurt");
    public static final SoundEvent ENTITY_DIREBAT_ATTACK = DBSoundEvents.createDirebatSound("attack");
    public static final SoundEvent ENTITY_DIREBAT_DEATH = DBSoundEvents.createDirebatSound("death");

    private static SoundEvent createDirebatSound(String id) {
        return DBSoundEvents.createEntitySound("direbat", id);
    }

    private static SoundEvent register(String name) {
        ResourceLocation resourceLocation = new ResourceLocation("direbats", name);
        return (SoundEvent)new SoundEvent(resourceLocation).setRegistryName(resourceLocation);
    }

    @SubscribeEvent
    public static void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        for (SoundEvent soundEvent : new SoundEvent[]{ENTITY_DIREBAT_AMBIENT, ENTITY_DIREBAT_HURT, ENTITY_DIREBAT_ATTACK, ENTITY_DIREBAT_DEATH}) {
            event.getRegistry().register((IForgeRegistryEntry)soundEvent);
        }
    }

    private static SoundEvent createEntitySound(String entity, String id) {
        return DBSoundEvents.register("entity." + entity + "." + id);
    }
}

