/*
 * Decompiled with CFR 0.152.
 */
package net.moddingplayground.direbats.entity;

import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1267;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1314;
import net.minecraft.class_1331;
import net.minecraft.class_1352;
import net.minecraft.class_1366;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1407;
import net.minecraft.class_1408;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2346;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3726;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4538;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5530;
import net.minecraft.class_5533;
import net.minecraft.class_5635;
import net.minecraft.class_7;
import net.moddingplayground.direbats.mixin.LivingEntityInvoker;
import net.moddingplayground.direbats.sound.DirebatsSoundEvents;
import net.moddingplayground.direbats.world.DirebatsGameRules;

public class DirebatEntity
extends class_1314 {
    private static final Predicate<class_1542> PICKABLE_DROP_FILTER = i -> i != null && !i.method_6977();
    private static final class_2940<Boolean> HANGING = class_2945.method_12791(DirebatEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> EATING_TIME = class_2945.method_12791(DirebatEntity.class, (class_2941)class_2943.field_13327);
    private boolean avoidsFallingBlocks = false;
    private int hangingCooldown = 0;
    private int pickupCooldown = 0;

    public DirebatEntity(class_1299<? extends DirebatEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6207 = new class_1331((class_1308)this, 20, true);
        this.method_5941(class_7.field_9, -1.0f);
        this.method_5941(class_7.field_18, -1.0f);
        this.method_5941(class_7.field_4, 16.0f);
        this.method_5941(class_7.field_21326, -1.0f);
        this.method_5941(class_7.field_21516, -1.0f);
        this.method_5941(class_7.field_10, -1.0f);
        this.method_5952(true);
        this.field_6194 = 5;
    }

    protected void method_5959() {
        this.field_6185.method_6277(0, (class_1352)new class_1399((class_1314)this, new Class[0]));
        this.field_6185.method_6277(1, new DirebatTargetGoal<class_1657>(this, class_1657.class));
        this.field_6201.method_6277(1, (class_1352)new AttackGoal(this));
        this.field_6201.method_6277(2, (class_1352)new PickupItemGoal(this));
        this.field_6201.method_6277(3, (class_1352)new WanderGoal(this));
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(HANGING, (Object)false);
        this.field_6011.method_12784(EATING_TIME, (Object)-1);
    }

    public boolean isHanging() {
        return (Boolean)this.field_6011.method_12789(HANGING);
    }

    public void setHanging(boolean hanging) {
        this.field_6011.method_12778(HANGING, (Object)hanging);
    }

    public int getEatingTime() {
        return (Integer)this.field_6011.method_12789(EATING_TIME);
    }

    public void setEatingTime(int eatingTime) {
        this.field_6011.method_12778(EATING_TIME, (Object)eatingTime);
    }

    public static class_5132.class_5133 createDirebatAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 16.0).method_26868(class_5134.field_23720, 0.22).method_26868(class_5134.field_23719, 0.22).method_26868(class_5134.field_23721, 4.0);
    }

    protected float method_18394(class_4050 entityPose, class_4048 dimensions) {
        return dimensions.field_18068 / 2.0f;
    }

    protected class_1408 method_5965(class_1937 worldIn) {
        class_1407 nav = new class_1407((class_1308)this, worldIn){

            public boolean method_6333(class_2338 pos) {
                return !this.field_6677.method_8320(pos.method_10074()).method_26215();
            }
        };
        nav.method_6331(false);
        nav.method_6354(false);
        nav.method_6332(true);
        return nav;
    }

    public void method_5773() {
        super.method_5773();
        if (this.method_23318() <= (double)this.field_6002.method_31607()) {
            class_243 vel = this.method_18798();
            this.method_18800(vel.field_1352, 0.2, vel.field_1350);
        } else {
            this.method_18799(this.isHanging() ? class_243.field_1353 : this.method_18798().method_1021(1.05));
        }
    }

    public void method_5958() {
        super.method_5958();
        if (this.pickupCooldown > 0) {
            --this.pickupCooldown;
        }
        if (!this.field_6002.field_9236) {
            if (this.isHanging()) {
                class_1799 stack;
                if (!this.canHang()) {
                    this.setHanging(false);
                    Optional.ofNullable(this.getWakingPlayer()).ifPresent(arg_0 -> ((DirebatEntity)this).method_5980(arg_0));
                    if (!this.method_5701()) {
                        this.field_6002.method_8444(null, 1025, this.method_24515(), 0);
                    }
                }
                if (!(stack = this.method_6118(class_1304.field_6173)).method_7960() && stack.method_19267()) {
                    int eatingTime = this.getEatingTime();
                    this.setEatingTime(eatingTime + 1);
                    if (eatingTime > 600) {
                        class_1799 nu = stack.method_7910(this.field_6002, (class_1309)this);
                        if (!nu.method_7960()) {
                            this.method_5673(class_1304.field_6173, nu);
                        }
                        this.setEatingTime(-1);
                    } else if (eatingTime > 560 && this.field_5974.nextFloat() < 0.1f) {
                        this.method_5783(this.method_18869(stack), this.method_6107(), this.method_6017());
                        this.field_6002.method_8421((class_1297)this, (byte)45);
                    }
                }
            } else {
                if (this.hangingCooldown > 0) {
                    --this.hangingCooldown;
                }
                if (this.field_6002.field_9229.nextFloat() <= 0.5f && this.canHang()) {
                    this.setHanging(true);
                    this.hangingCooldown = 200;
                    this.method_5942().method_6340();
                    class_2338 hpos = this.method_24515().method_10084();
                    class_2680 hstate = this.field_6002.method_8320(hpos);
                    if (hstate.method_26204() instanceof class_2346) {
                        this.avoidsFallingBlocks = true;
                    }
                    hstate.method_30101((class_1936)this.field_6002, hpos, 3);
                }
            }
        }
    }

    public boolean canHang() {
        if (this.hangingCooldown > 0 && !this.isHanging()) {
            return false;
        }
        if (this.method_5968() != null || this.getWakingPlayer() != null) {
            return false;
        }
        return this.canHangAt(this.method_24515());
    }

    public boolean canHangAt(class_2338 pos) {
        class_2338 hpos = pos.method_10084();
        class_2680 hstate = this.field_6002.method_8320(hpos);
        if (this.avoidsFallingBlocks && hstate.method_26204() instanceof class_2346) {
            return false;
        }
        if (!hstate.method_26234((class_1922)this.field_6002, hpos)) {
            return false;
        }
        class_2338.class_2339 mutable = pos.method_25503();
        for (int i = 0; i < 2; ++i) {
            class_238 box = class_238.method_30048((class_243)class_243.method_24954((class_2382)mutable), (double)1.0, (double)1.0, (double)1.0);
            if (!this.field_6002.method_8390(DirebatEntity.class, box, entity -> entity != this && entity.isHanging()).isEmpty()) {
                return false;
            }
            if (!this.field_6002.method_8320((class_2338)mutable).method_26194((class_1922)this.field_6002, (class_2338)mutable, class_3726.method_16195((class_1297)this)).method_1110()) {
                return false;
            }
            mutable.method_10098(class_2350.field_11033);
        }
        return true;
    }

    public class_1657 getWakingPlayer() {
        return this.field_6002.method_8604(this.method_23317(), this.method_23318(), this.method_23321(), 8.0, this::wakesUpDirebat);
    }

    public boolean wakesUpDirebat(class_1297 entity) {
        class_1657 player;
        if (entity instanceof class_1657 && ((player = (class_1657)entity).method_7337() || player.method_7325())) {
            return false;
        }
        if (this.method_5858(entity) <= 6.0) {
            return true;
        }
        return !entity.method_5715();
    }

    @Environment(value=EnvType.CLIENT)
    public void method_5711(byte status) {
        if (status == 45) {
            class_1799 stack = this.method_6118(class_1304.field_6173);
            if (!stack.method_7960()) {
                for (int i = 0; i < 8; ++i) {
                    class_243 velocity = new class_243(((double)this.field_5974.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0).method_1037(-this.method_36455() * ((float)Math.PI / 180)).method_1024(-this.method_36454() * ((float)Math.PI / 180));
                    this.field_6002.method_8406((class_2394)new class_2392(class_2398.field_11218, stack), this.method_23317() + this.method_5720().field_1352 / 2.0, this.method_23318(), this.method_23321() + this.method_5720().field_1350 / 2.0, velocity.field_1352, velocity.field_1351 + 0.05, velocity.field_1350);
                }
            }
        } else {
            super.method_5711(status);
        }
    }

    public void method_6007() {
        boolean dl;
        if (this.method_5805() && (dl = this.method_5972())) {
            class_1799 stack = this.method_6118(class_1304.field_6169);
            if (!stack.method_7960()) {
                if (stack.method_7963()) {
                    stack.method_7974(stack.method_7919() + this.field_5974.nextInt(2));
                    if (stack.method_7919() >= stack.method_7936()) {
                        this.method_20235(class_1304.field_6169);
                        this.method_5673(class_1304.field_6169, class_1799.field_8037);
                    }
                }
                dl = false;
            }
            if (dl) {
                this.method_5639(8);
            }
        }
        super.method_6007();
    }

    public void method_6091(class_243 movementInput) {
        if (this.method_6034()) {
            this.method_5724(0.1f, movementInput);
            this.method_5784(class_1313.field_6308, this.method_18798());
            this.method_18799(this.method_18798().method_1021(0.9));
        }
    }

    public class_243 method_26318(class_243 input, float slipperiness) {
        this.method_5724(this.getRelevantMoveFactor(slipperiness), input);
        this.method_18799(((LivingEntityInvoker)((Object)this)).invoke_applyClimbingSpeed(this.method_18798()));
        this.method_5784(class_1313.field_6308, this.method_18798());
        class_243 motionVector = this.method_18798();
        if ((this.field_5976 || this.field_6282) && (this.method_6101() || this.method_36601().method_27852(class_2246.field_27879) && class_5635.method_32355((class_1297)this))) {
            motionVector = new class_243(motionVector.field_1352, 0.2, motionVector.field_1350);
        }
        return motionVector;
    }

    private float getRelevantMoveFactor(float slipperiness) {
        return this.method_6029() * (0.21600002f / (slipperiness * slipperiness * slipperiness));
    }

    public float method_6144(class_2338 pos, class_4538 world) {
        if (world.method_8320(pos).method_26215()) {
            float offset = 0.0f;
            if (!world.method_8320(pos.method_10074()).method_26215()) {
                offset -= 2.0f;
            }
            if (this.canHangAt(pos.method_10084())) {
                offset += 2.0f;
            }
            float brightness = world.method_8597().method_28516(world.method_22339(pos));
            return 1.0f / brightness + offset;
        }
        return 0.0f;
    }

    public boolean method_6121(class_1297 target) {
        if (super.method_6121(target)) {
            if (target instanceof class_1309) {
                class_1309 entity = (class_1309)target;
                entity.method_6092(new class_1293(class_1294.field_5919, (this.field_6002.method_8407() == class_1267.field_5807 ? 10 : 5) * 20, 0));
            }
            this.method_5783(DirebatsSoundEvents.ENTITY_DIREBAT_ATTACK, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    public boolean method_5643(class_1282 damageSource, float amount) {
        if (this.method_5679(damageSource)) {
            return false;
        }
        if (!this.field_6002.field_9236 && this.isHanging()) {
            this.setHanging(false);
        }
        this.method_16078();
        return super.method_5643(damageSource, amount);
    }

    protected void method_5949(class_1542 entity) {
        class_1799 stack = this.method_6118(class_1304.field_6173);
        if (stack.method_7960() && this.field_6002.method_8450().method_8355(DirebatsGameRules.DIREBAT_ITEM_PICKUP) && PICKABLE_DROP_FILTER.test(entity)) {
            class_1799 nu = entity.method_6983();
            this.method_24834(class_1304.field_6173, nu);
            this.method_6103((class_1297)entity, nu.method_7947());
            this.method_29499(entity);
            entity.method_31472();
        }
    }

    protected void method_16078() {
        super.method_16078();
        if (!this.method_5998(class_1268.field_5808).method_7960()) {
            this.method_5775(this.method_6047());
            this.method_6122(class_1268.field_5808, new class_1799((class_1935)class_1802.field_8162));
        }
    }

    protected float method_6107() {
        return 0.4f;
    }

    public float method_6017() {
        return super.method_6017() * 0.95f;
    }

    public class_3414 method_5994() {
        return this.isHanging() && this.field_5974.nextInt(4) != 0 ? null : DirebatsSoundEvents.ENTITY_DIREBAT_AMBIENT;
    }

    protected class_3414 method_6011(class_1282 source) {
        return DirebatsSoundEvents.ENTITY_DIREBAT_HURT;
    }

    protected class_3414 method_6002() {
        return DirebatsSoundEvents.ENTITY_DIREBAT_DEATH;
    }

    public boolean method_5810() {
        return this.isHanging();
    }

    public boolean method_5931(class_1657 player) {
        return true;
    }

    protected void method_6087(class_1297 entity) {
        if (this.isHanging()) {
            return;
        }
        super.method_6087(entity);
    }

    public boolean method_5747(float distance, float multiplier, class_1282 source) {
        return false;
    }

    protected void method_5623(double heightDifference, boolean onGround, class_2680 landedState, class_2338 landedPos) {
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10556("Hanging", this.isHanging());
        nbt.method_10556("AvoidsFallingBlocks", this.avoidsFallingBlocks);
        nbt.method_10569("EatingTime", this.getEatingTime());
        nbt.method_10569("HangingCooldown", this.hangingCooldown);
        nbt.method_10569("PickupCooldown", this.pickupCooldown);
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setHanging(nbt.method_10577("Hanging"));
        this.avoidsFallingBlocks = nbt.method_10577("AvoidsFallingBlocks");
        this.setEatingTime(nbt.method_10550("EatingTime"));
        this.hangingCooldown = nbt.method_10550("HangingCooldown");
        this.pickupCooldown = nbt.method_10550("PickupCooldown");
    }

    public static boolean canSpawn(class_1299<DirebatEntity> type, class_5425 world, class_3730 spawnReason, class_2338 pos, Random random) {
        if (pos.method_10264() >= 63) {
            return world.method_8410().method_23886() && world.method_30272() == 1.0f;
        }
        int worldLight = world.method_22339(pos);
        int maximumLight = 4;
        if (DirebatEntity.isTodayAroundHalloween()) {
            maximumLight = 7;
        }
        return worldLight <= random.nextInt(maximumLight) && DirebatEntity.method_20636(type, (class_1936)world, (class_3730)spawnReason, (class_2338)pos, (Random)random);
    }

    private static boolean isTodayAroundHalloween() {
        LocalDate localDate = LocalDate.now();
        int day = localDate.get(ChronoField.DAY_OF_MONTH);
        int month = localDate.get(ChronoField.MONTH_OF_YEAR);
        return month == 10 && day >= 20 || month == 11 && day <= 3;
    }

    public boolean method_17326() {
        return super.method_17326() || !this.method_6047().method_7960();
    }

    protected boolean method_23734() {
        return true;
    }

    public Optional<class_1542> getItemToPickUp() {
        List list = this.field_6002.method_8390(class_1542.class, this.method_5829().method_1009(8.0, 8.0, 8.0), PICKABLE_DROP_FILTER);
        if (list.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of((class_1542)list.get(0));
    }

    public static class DirebatTargetGoal<T extends class_1309>
    extends class_1400<T> {
        public DirebatTargetGoal(DirebatEntity mob, Class<T> classTarget) {
            super((class_1308)mob, classTarget, true);
        }

        public boolean method_6264() {
            boolean sup = super.method_6264();
            if (this.field_6644 == null) {
                return false;
            }
            return sup && this.field_6660.method_5718() >= 0.5f && !this.field_6644.method_5715();
        }
    }

    public static class AttackGoal
    extends class_1366 {
        public AttackGoal(DirebatEntity entity) {
            super((class_1314)entity, 1.0, true);
        }

        public boolean method_6266() {
            if (this.field_6503.method_5718() <= 0.5f && this.field_6503.method_6051().nextInt(100) == 0) {
                this.field_6503.method_5980(null);
                return false;
            }
            return super.method_6266();
        }
    }

    public static class PickupItemGoal
    extends class_1352 {
        private final DirebatEntity mob;

        public PickupItemGoal(DirebatEntity mob) {
            this.mob = mob;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            if (this.mob.pickupCooldown > 0) {
                return false;
            }
            if (!this.mob.method_5998(class_1268.field_5808).method_7960()) {
                return false;
            }
            if (this.mob.method_5968() != null) {
                return false;
            }
            return this.mob.getItemToPickUp().isPresent();
        }

        public boolean method_6266() {
            return this.mob.field_6189.method_23966();
        }

        public void method_6268() {
            class_1799 itemInHand = this.mob.method_5998(class_1268.field_5808);
            if (itemInHand.method_7960()) {
                this.mob.getItemToPickUp().ifPresent(entity -> this.mob.method_5942().method_6335((class_1297)entity, 1.2));
            }
        }

        public void method_6269() {
            this.mob.getItemToPickUp().ifPresent(entity -> this.mob.method_5942().method_6335((class_1297)entity, 1.2));
            this.mob.pickupCooldown = 60;
        }
    }

    public static class WanderGoal
    extends class_1352 {
        private final DirebatEntity mob;

        WanderGoal(DirebatEntity mob) {
            this.mob = mob;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            return this.mob.field_6189.method_6357() && !this.mob.isHanging() && this.mob.field_5974.nextInt(5) == 0;
        }

        public boolean method_6266() {
            return this.mob.field_6189.method_23966();
        }

        public void method_6269() {
            Optional.ofNullable(this.getRandomLocation()).ifPresent(pos -> this.mob.field_6189.method_6334(this.mob.field_6189.method_6348(new class_2338(pos), 1), 1.0));
        }

        private class_243 getRandomLocation() {
            class_243 rotation;
            if (this.mob.method_18410() && !this.mob.method_18412().method_19769((class_2374)this.mob.method_19538(), 22.0)) {
                class_243 pos = class_243.method_24953((class_2382)this.mob.method_18412());
                rotation = pos.method_1020(this.mob.method_19538()).method_1029();
            } else {
                rotation = this.mob.method_5828(0.0f);
            }
            return Optional.ofNullable(class_5533.method_31524((class_1314)this.mob, (int)8, (int)7, (double)rotation.field_1352, (double)rotation.field_1350, (float)1.5707964f, (int)2, (int)1)).orElseGet(() -> class_5530.method_31504((class_1314)this.mob, (int)8, (int)4, (int)-2, (double)rotation.field_1352, (double)rotation.field_1350, (double)1.5707963705062866));
        }
    }
}

