/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.dynamiccrosshair.config;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import mod.crend.dynamiccrosshair.config.BlockCrosshairPolicy;
import mod.crend.dynamiccrosshair.config.Config;
import mod.crend.dynamiccrosshair.config.CrosshairColor;
import mod.crend.dynamiccrosshair.config.CrosshairMode;
import mod.crend.dynamiccrosshair.config.CrosshairModifier;
import mod.crend.dynamiccrosshair.config.CrosshairPolicy;
import mod.crend.dynamiccrosshair.config.CrosshairStyle;
import mod.crend.dynamiccrosshair.config.InteractableCrosshairPolicy;
import mod.crend.dynamiccrosshair.config.UsableCrosshairPolicy;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_437;
import net.minecraft.class_7922;
import net.minecraft.class_7923;

public class ConfigHandler {
    Config config;
    List<class_1792> additionalTools = null;
    List<class_1792> additionalMeleeWeapons = null;
    List<class_1792> additionalRangedWeapons = null;
    List<class_1792> additionalThrowables = null;
    List<class_1792> additionalUsableItems = null;

    public static class_437 getScreen(class_437 parent) {
        return (class_437)AutoConfig.getConfigScreen(Config.class, (class_437)parent).get();
    }

    public ConfigHandler() {
        AutoConfig.register(Config.class, JanksonConfigSerializer::new);
        this.config = (Config)AutoConfig.getConfigHolder(Config.class).getConfig();
    }

    public boolean isDynamicCrosshair() {
        return this.config.dynamicCrosshair != CrosshairMode.Disabled;
    }

    public boolean isDynamicCrosshairSimple() {
        return this.config.dynamicCrosshair == CrosshairMode.Simple;
    }

    public boolean isDisableDebugCrosshair() {
        return this.config.disableDebugCrosshair;
    }

    public boolean isThirdPersonCrosshair() {
        return this.config.thirdPersonCrosshair;
    }

    public boolean isHideWithScreen() {
        return this.config.hideWithScreen;
    }

    public InteractableCrosshairPolicy dynamicCrosshairOnBlock() {
        return this.config.crosshairConfig.onBlock;
    }

    public boolean dynamicCrosshairOnEntity() {
        return this.config.crosshairConfig.onEntity;
    }

    public CrosshairPolicy dynamicCrosshairHoldingTool() {
        return this.config.crosshairConfig.holdingTool;
    }

    public boolean dynamicCrosshairHoldingMeleeWeapon() {
        return this.config.crosshairConfig.holdingMeleeWeapon;
    }

    public UsableCrosshairPolicy dynamicCrosshairHoldingRangedWeapon() {
        return this.config.crosshairConfig.holdingRangedWeapon;
    }

    public UsableCrosshairPolicy dynamicCrosshairHoldingThrowable() {
        return this.config.crosshairConfig.holdingThrowable;
    }

    public boolean dynamicCrosshairHoldingShield() {
        return this.config.crosshairConfig.holdingShield;
    }

    public BlockCrosshairPolicy dynamicCrosshairHoldingBlock() {
        return this.config.crosshairConfig.holdingBlock;
    }

    public UsableCrosshairPolicy dynamicCrosshairHoldingUsableItem() {
        return this.config.crosshairConfig.holdingUsableItem;
    }

    public CrosshairColor getColor() {
        return new CrosshairColor(this.config.color.crosshairColor, this.config.color.customColor, this.config.color.forceColor);
    }

    public boolean isDynamicCrosshairStyle() {
        return this.config.dynamicCrosshairStyle;
    }

    public CrosshairStyle getCrosshairStyleRegular() {
        return new CrosshairStyle(this.config.crosshairStyle.regular);
    }

    public CrosshairStyle getCrosshairStyleOnBlock() {
        return new CrosshairStyle(this.config.crosshairStyle.onBlock);
    }

    public CrosshairStyle getCrosshairStyleOnEntity() {
        return new CrosshairStyle(this.config.crosshairStyle.onEntity);
    }

    public CrosshairStyle getCrosshairStyleHoldingTool() {
        return new CrosshairStyle(this.config.crosshairStyle.holdingTool);
    }

    public CrosshairStyle getCrosshairStyleHoldingMeleeWeapon() {
        return new CrosshairStyle(this.config.crosshairStyle.holdingMeleeWeapon);
    }

    public CrosshairStyle getCrosshairStyleHoldingRangedWeapon() {
        return new CrosshairStyle(this.config.crosshairStyle.holdingRangedWeapon);
    }

    public CrosshairStyle getCrosshairStyleHoldingThrowable() {
        return new CrosshairStyle(this.config.crosshairStyle.holdingThrowable);
    }

    public CrosshairStyle getCrosshairStyleHoldingBlock() {
        return new CrosshairStyle(this.config.crosshairStyle.holdingBlock);
    }

    public CrosshairModifier getCrosshairModifierInteractable() {
        return new CrosshairModifier(this.config.crosshairModifiers.modInteractable);
    }

    public CrosshairModifier getCrosshairModifierCorrectTool() {
        return new CrosshairModifier(this.config.crosshairModifiers.modCorrectTool);
    }

    public CrosshairModifier getCrosshairModifierIncorrectTool() {
        return new CrosshairModifier(this.config.crosshairModifiers.modIncorrectTool);
    }

    public CrosshairModifier getCrosshairModifierUsableItem() {
        return new CrosshairModifier(this.config.crosshairModifiers.modUsableItem);
    }

    public CrosshairModifier getCrosshairModifierShield() {
        return new CrosshairModifier(this.config.crosshairModifiers.modShield);
    }

    public boolean isTweaksEnabled() {
        return this.config.enableTweaks;
    }

    private List<class_1792> buildAdditionalItemList(String configString) {
        return Arrays.stream(configString.split(";")).filter(s -> !s.isBlank()).map(class_2960::method_12829).filter(Objects::nonNull).map(arg_0 -> ((class_7922)class_7923.field_41178).method_10223(arg_0)).collect(Collectors.toList());
    }

    public List<class_1792> getAdditionalTools() {
        if (!this.isTweaksEnabled()) {
            return Collections.emptyList();
        }
        if (this.additionalTools == null) {
            this.additionalTools = this.buildAdditionalItemList(this.config.additionalTools);
        }
        return this.additionalTools;
    }

    public List<class_1792> getAdditionalMeleeWeapons() {
        if (!this.isTweaksEnabled()) {
            return Collections.emptyList();
        }
        if (this.additionalMeleeWeapons == null) {
            this.additionalMeleeWeapons = this.buildAdditionalItemList(this.config.additionalMeleeWeapons);
        }
        return this.additionalMeleeWeapons;
    }

    public List<class_1792> getAdditionalRangedWeapons() {
        if (!this.isTweaksEnabled()) {
            return Collections.emptyList();
        }
        if (this.additionalRangedWeapons == null) {
            this.additionalRangedWeapons = this.buildAdditionalItemList(this.config.additionalRangedWeapons);
        }
        return this.additionalRangedWeapons;
    }

    public List<class_1792> getAdditionalThrowables() {
        if (!this.isTweaksEnabled()) {
            return Collections.emptyList();
        }
        if (this.additionalThrowables == null) {
            this.additionalThrowables = this.buildAdditionalItemList(this.config.additionalThrowables);
        }
        return this.additionalThrowables;
    }

    public List<class_1792> getAdditionalUsableItems() {
        if (!this.isTweaksEnabled()) {
            return Collections.emptyList();
        }
        if (this.additionalUsableItems == null) {
            this.additionalUsableItems = this.buildAdditionalItemList(this.config.additionalUsableItems);
        }
        return this.additionalUsableItems;
    }
}

