/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.dynamiccrosshair.handler;

import mod.crend.dynamiccrosshair.api.CrosshairContext;
import mod.crend.dynamiccrosshair.api.DynamicCrosshairApi;
import mod.crend.dynamiccrosshair.api.ItemCategory;
import mod.crend.dynamiccrosshair.component.Crosshair;
import mod.crend.dynamiccrosshair.handler.VanillaBlockHandler;
import mod.crend.dynamiccrosshair.handler.VanillaEntityHandler;
import mod.crend.dynamiccrosshair.handler.VanillaItemHandler;
import mod.crend.dynamiccrosshair.handler.VanillaUsableItemHandler;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.ChiseledBookShelfBlock;
import net.minecraft.world.level.block.state.BlockState;

public class VanillaApiImpl
implements DynamicCrosshairApi {
    private boolean fishHookStatus;

    @Override
    public String getNamespace() {
        return "minecraft";
    }

    @Override
    public boolean forceCheck() {
        return true;
    }

    @Override
    public boolean forceInvalidate(CrosshairContext context) {
        if (context.isWithEntity() && context.getEntity().m_6095_() == EntityType.f_20529_) {
            return true;
        }
        if (context.isWithBlock() && context.getBlock() instanceof ChiseledBookShelfBlock) {
            return true;
        }
        if (context.getItem() instanceof FishingRodItem) {
            boolean newFishHookStatus;
            boolean bl = newFishHookStatus = context.player.f_36083_ != null;
            if (newFishHookStatus != this.fishHookStatus) {
                this.fishHookStatus = newFishHookStatus;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isAlwaysUsableItem(ItemStack itemStack) {
        return VanillaUsableItemHandler.isAlwaysUsableItem(itemStack);
    }

    @Override
    public boolean isUsableItem(ItemStack itemStack) {
        return VanillaUsableItemHandler.isUsableItem(itemStack);
    }

    @Override
    public ItemCategory getItemCategory(ItemStack itemStack) {
        if (VanillaUsableItemHandler.isAlwaysUsableItem(itemStack) || VanillaUsableItemHandler.isUsableItem(itemStack)) {
            return ItemCategory.USABLE;
        }
        if (VanillaItemHandler.isMeleeWeapon(itemStack)) {
            return ItemCategory.MELEE_WEAPON;
        }
        if (VanillaItemHandler.isTool(itemStack)) {
            return ItemCategory.TOOL;
        }
        if (VanillaItemHandler.isRangedWeapon(itemStack)) {
            return ItemCategory.RANGED_WEAPON;
        }
        if (VanillaItemHandler.isThrowable(itemStack)) {
            return ItemCategory.THROWABLE;
        }
        if (VanillaItemHandler.isShield(itemStack)) {
            return ItemCategory.SHIELD;
        }
        if (VanillaItemHandler.isBlockItem(itemStack)) {
            return ItemCategory.BLOCK;
        }
        return ItemCategory.NONE;
    }

    @Override
    public boolean isInteractableEntity(Entity entity) {
        return VanillaEntityHandler.isEntityInteractable(entity);
    }

    @Override
    public boolean isAlwaysInteractableBlock(BlockState blockState) {
        return VanillaBlockHandler.isAlwaysInteractableBlock(blockState);
    }

    @Override
    public boolean isInteractableBlock(BlockState blockState) {
        return VanillaBlockHandler.isInteractableBlock(blockState);
    }

    @Override
    public Crosshair computeFromEntity(CrosshairContext context) {
        return VanillaEntityHandler.checkEntity(context);
    }

    @Override
    public Crosshair computeFromBlock(CrosshairContext context) {
        return VanillaBlockHandler.checkBlockInteractable(context);
    }

    @Override
    public Crosshair computeFromItem(CrosshairContext context) {
        Crosshair toolCrosshair;
        Crosshair crosshair = null;
        if (context.includeUsableItem()) {
            crosshair = VanillaUsableItemHandler.checkUsableItem(context);
        }
        if (context.includeRangedWeapon() && crosshair == null && (crosshair = VanillaItemHandler.checkRangedWeapon(context)) != null) {
            return crosshair;
        }
        if (context.includeMeleeWeapon() && crosshair == null && (crosshair = VanillaItemHandler.checkMeleeWeapon(context)) != null) {
            return crosshair;
        }
        if (context.includeTool() && (toolCrosshair = VanillaItemHandler.checkTool(context)) != null) {
            if (context.isWithBlock()) {
                toolCrosshair = Crosshair.combine(toolCrosshair, VanillaBlockHandler.checkToolWithBlock(context));
            }
            crosshair = Crosshair.combine(crosshair, toolCrosshair);
        }
        if (crosshair != null) {
            return crosshair;
        }
        if (context.includeThrowable() && (crosshair = VanillaItemHandler.checkThrowable(context)) != null) {
            return crosshair;
        }
        if (context.includeShield() && (crosshair = VanillaItemHandler.checkShield(context)) != null) {
            return crosshair;
        }
        if (context.includeHoldingBlock()) {
            crosshair = VanillaItemHandler.checkBlockItem(context);
        }
        return crosshair;
    }
}

