/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.dynamiccrosshair.mixin;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import mod.crend.dynamiccrosshair.DynamicCrosshair;
import mod.crend.dynamiccrosshair.component.Crosshair;
import mod.crend.dynamiccrosshair.component.CrosshairHandler;
import mod.crend.dynamiccrosshair.config.CrosshairColor;
import mod.crend.dynamiccrosshair.config.CrosshairModifier;
import mod.crend.dynamiccrosshair.config.CrosshairStyle;
import net.minecraft.client.CameraType;
import net.minecraft.client.Options;
import net.minecraft.client.gui.Gui;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Gui.class}, priority=1010)
public class InGameHudMixin {
    @Inject(method={"renderCrosshair"}, at={@At(value="HEAD")}, cancellable=true)
    private void dynamiccrosshair$preCrosshair(PoseStack matrixStack, CallbackInfo ci) {
        if (!CrosshairHandler.shouldShowCrosshair()) {
            ci.cancel();
        }
    }

    private void dynamiccrosshair$setColor(CrosshairColor color) {
        int argb = color.getColor();
        RenderSystem.m_157429_((float)((float)(argb >> 16 & 0xFF) / 255.0f), (float)((float)(argb >> 8 & 0xFF) / 255.0f), (float)((float)(argb & 0xFF) / 255.0f), (float)((float)(argb >> 24 & 0xFF) / 255.0f));
        if (color.forced()) {
            RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        } else {
            RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        }
    }

    @Redirect(method={"renderCrosshair"}, at=@At(value="FIELD", target="Lnet/minecraft/client/option/GameOptions;debugEnabled:Z", opcode=180), require=0)
    private boolean dynamiccrosshair$debugCrosshair(Options instance) {
        if (DynamicCrosshair.config.isDisableDebugCrosshair()) {
            return false;
        }
        return instance.f_92063_;
    }

    @Redirect(method={"renderCrosshair"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/hud/InGameHud;drawTexture(Lnet/minecraft/client/util/math/MatrixStack;IIIIII)V", ordinal=0), require=0)
    private void dynamiccrosshair$drawCrosshair(Gui instance, PoseStack matrixStack, int x, int y, int u, int v, int width, int height) {
        this.dynamiccrosshair$setColor(DynamicCrosshair.config.getColor());
        if (DynamicCrosshair.config.isDynamicCrosshairStyle()) {
            Crosshair crosshair = CrosshairHandler.getActiveCrosshair();
            RenderSystem.m_157456_((int)0, (ResourceLocation)CrosshairHandler.crosshairTexture);
            if (crosshair.hasStyle()) {
                CrosshairStyle crosshairStyle = crosshair.getCrosshairStyle();
                this.dynamiccrosshair$setColor(crosshairStyle.getColor());
                instance.m_93228_(matrixStack, x, y, crosshairStyle.getStyle().getX(), crosshairStyle.getStyle().getY(), 15, 15);
            }
            for (CrosshairModifier modifier : crosshair.getModifiers()) {
                this.dynamiccrosshair$setColor(modifier.getColor());
                instance.m_93228_(matrixStack, x, y, modifier.getStyle().getX(), modifier.getStyle().getY(), 15, 15);
            }
            RenderSystem.m_157456_((int)0, (ResourceLocation)Gui.f_93098_);
        } else {
            instance.m_93228_(matrixStack, x, y, u, v, width, height);
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
    }

    @Redirect(method={"renderCrosshair"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/option/GameOptions;getPerspective()Lnet/minecraft/client/option/Perspective;"), require=0)
    private CameraType dynamiccrosshair$thirdPersonCrosshair(Options gameOptions) {
        CameraType originalPerspective = gameOptions.m_92176_();
        if (originalPerspective == CameraType.THIRD_PERSON_BACK && DynamicCrosshair.config.isThirdPersonCrosshair()) {
            return CameraType.FIRST_PERSON;
        }
        return originalPerspective;
    }

    @Inject(method={"tick()V"}, at={@At(value="TAIL")})
    private void dynamiccrosshair$tickDynamicCrosshair(CallbackInfo ci) {
        CrosshairHandler.tick();
    }
}

