/*
 * Decompiled with CFR 0.152.
 */
package com.baguchan.enchantwithmob;

import com.baguchan.enchantwithmob.EnchantConfig;
import com.baguchan.enchantwithmob.EnchantWithMob;
import com.baguchan.enchantwithmob.capability.ItemMobEnchantCapability;
import com.baguchan.enchantwithmob.capability.MobEnchantCapability;
import com.baguchan.enchantwithmob.capability.MobEnchantHandler;
import com.baguchan.enchantwithmob.message.MobEnchantedMessage;
import com.baguchan.enchantwithmob.mobenchant.MobEnchant;
import com.baguchan.enchantwithmob.registry.MobEnchants;
import com.baguchan.enchantwithmob.registry.ModItems;
import com.baguchan.enchantwithmob.utils.MobEnchantUtils;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.SnowGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.GameRules;
import net.minecraft.world.IWorld;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="enchantwithmob")
public class CommonEventHandler {
    @SubscribeEvent
    public static void onAttachEntityCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof LivingEntity) {
            event.addCapability(new ResourceLocation("enchantwithmob", "mob_enchant"), (ICapabilityProvider)new MobEnchantCapability());
        }
        if (event.getObject() instanceof ProjectileEntity) {
            event.addCapability(new ResourceLocation("enchantwithmob", "item_mob_enchant"), new ItemMobEnchantCapability());
        }
    }

    @SubscribeEvent
    public static void onSpawnEntity(LivingSpawnEvent.CheckSpawn event) {
        LivingEntity livingEntity;
        IWorld world;
        if (event.getEntity() instanceof LivingEntity && (world = event.getWorld()).func_72912_H().func_82574_x().func_223586_b(GameRules.field_223599_b) && ((Boolean)EnchantConfig.COMMON.naturalSpawnEnchantedMob.get()).booleanValue() && (!((livingEntity = (LivingEntity)event.getEntity()) instanceof AnimalEntity) || ((Boolean)EnchantConfig.COMMON.spawnEnchantedAnimal.get()).booleanValue()) && event.getSpawnReason() != SpawnReason.BREEDING && event.getSpawnReason() != SpawnReason.CONVERSION && event.getSpawnReason() != SpawnReason.STRUCTURE && event.getSpawnReason() != SpawnReason.MOB_SUMMONED && world.func_201674_k().nextFloat() < 0.005f * (float)world.func_175659_aa().func_151525_a() + world.func_175649_E(livingEntity.func_233580_cy_()).func_180168_b() * 0.025f && !world.func_201670_d()) {
            livingEntity.getCapability(EnchantWithMob.MOB_ENCHANT_CAP).ifPresent(cap -> {
                int i = 0;
                float difficultScale = world.func_175649_E(livingEntity.func_233580_cy_()).func_180168_b() - 0.2f;
                switch (world.func_175659_aa()) {
                    case EASY: {
                        i = (int)MathHelper.func_76131_a((float)((float)(5 + world.func_201674_k().nextInt(5)) * difficultScale), (float)1.0f, (float)20.0f);
                        MobEnchantUtils.addRandomEnchantmentToEntity(livingEntity, cap, world.func_201674_k(), i, true);
                        break;
                    }
                    case NORMAL: {
                        i = (int)MathHelper.func_76131_a((float)((float)(5 + world.func_201674_k().nextInt(5)) * difficultScale), (float)1.0f, (float)40.0f);
                        MobEnchantUtils.addRandomEnchantmentToEntity(livingEntity, cap, world.func_201674_k(), i, true);
                        break;
                    }
                    case HARD: {
                        i = (int)MathHelper.func_76131_a((float)((float)(5 + world.func_201674_k().nextInt(10)) * difficultScale), (float)1.0f, (float)50.0f);
                        MobEnchantUtils.addRandomEnchantmentToEntity(livingEntity, cap, world.func_201674_k(), i, true);
                    }
                }
                livingEntity.func_70606_j(livingEntity.func_110138_aP());
            });
        }
    }

    @SubscribeEvent
    public static void onEntitySpawn(LivingSpawnEvent event) {
        LivingEntity livingEntity = event.getEntityLiving();
        if (!livingEntity.field_70170_p.field_72995_K) {
            livingEntity.getCapability(EnchantWithMob.MOB_ENCHANT_CAP).ifPresent(cap -> {
                if (cap.hasEnchant()) {
                    for (int i = 0; i < cap.getMobEnchants().size(); ++i) {
                        MobEnchantedMessage message = new MobEnchantedMessage((Entity)livingEntity, cap.getMobEnchants().get(i));
                        EnchantWithMob.CHANNEL.send(PacketDistributor.TRACKING_ENTITY.with(() -> livingEntity), (Object)message);
                    }
                }
                if (cap.isFromOwner() && (!cap.hasOwner() || cap.hasOwner() && livingEntity.func_70068_e((Entity)cap.getEnchantOwner().get()) > 512.0)) {
                    cap.removeMobEnchantFromOwner(livingEntity);
                    livingEntity.func_184185_a(SoundEvents.field_187635_cQ, 1.5f, 1.6f);
                }
            });
        }
    }

    @SubscribeEvent
    public static void onUpdateEnchanted(LivingEvent.LivingUpdateEvent event) {
        LivingEntity livingEntity = event.getEntityLiving();
        if (!livingEntity.field_70170_p.field_72995_K) {
            livingEntity.getCapability(EnchantWithMob.MOB_ENCHANT_CAP).ifPresent(cap -> {
                for (MobEnchantHandler enchantHandler : cap.getMobEnchants()) {
                    enchantHandler.getMobEnchant().tick(livingEntity, enchantHandler.getEnchantLevel());
                }
            });
        }
    }

    @SubscribeEvent
    public static void onEntityHurt(LivingHurtEvent event) {
        LivingEntity livingEntity = event.getEntityLiving();
        if (event.getSource().func_76346_g() instanceof LivingEntity) {
            LivingEntity attaker = (LivingEntity)event.getSource().func_76346_g();
            attaker.getCapability(EnchantWithMob.MOB_ENCHANT_CAP).ifPresent(cap -> {
                if (cap.hasEnchant() && MobEnchantUtils.findMobEnchantFromHandler(cap.getMobEnchants(), MobEnchants.STRONG)) {
                    if (event.getSource().func_76346_g() != null && event.getSource().func_76346_g() instanceof SnowGolemEntity && event.getAmount() == 0.0f) {
                        event.setAmount(CommonEventHandler.getDamageAddition(1.0f, cap));
                    } else if (event.getAmount() > 0.0f) {
                        event.setAmount(CommonEventHandler.getDamageAddition(event.getAmount(), cap));
                    }
                }
            });
            livingEntity.getCapability(EnchantWithMob.MOB_ENCHANT_CAP).ifPresent(cap -> {
                if (cap.hasEnchant() && MobEnchantUtils.findMobEnchantFromHandler(cap.getMobEnchants(), MobEnchants.THORN)) {
                    int i = MobEnchantUtils.getMobEnchantLevelFromHandler(cap.getMobEnchants(), MobEnchants.THORN);
                    if (livingEntity.func_70681_au().nextFloat() < (float)i * 0.1f) {
                        attaker.func_70097_a(DamageSource.func_92087_a((Entity)livingEntity), CommonEventHandler.getThornDamage(event.getAmount(), cap));
                    }
                }
            });
        }
        livingEntity.getCapability(EnchantWithMob.MOB_ENCHANT_CAP).ifPresent(cap -> {
            if (cap.hasEnchant() && MobEnchantUtils.findMobEnchantFromHandler(cap.getMobEnchants(), MobEnchants.PROTECTION)) {
                event.setAmount(CommonEventHandler.getDamageReduction(event.getAmount(), cap));
            }
        });
    }

    public static float getDamageAddition(float damage, MobEnchantCapability cap) {
        int level = MobEnchantUtils.getMobEnchantLevelFromHandler(cap.getMobEnchants(), MobEnchants.STRONG);
        if (level > 0) {
            damage += 1.0f + (float)Math.max(0, level - 1) * 1.0f;
        }
        return damage;
    }

    public static float getDamageReduction(float damage, MobEnchantCapability cap) {
        int i = MobEnchantUtils.getMobEnchantLevelFromHandler(cap.getMobEnchants(), MobEnchants.PROTECTION);
        if (i > 0) {
            damage = (float)((double)damage - (double)MathHelper.func_76128_c((double)((double)damage * (double)((float)i * 0.15f))));
        }
        return damage;
    }

    public static float getThornDamage(float damage, MobEnchantCapability cap) {
        int i = MobEnchantUtils.getMobEnchantLevelFromHandler(cap.getMobEnchants(), MobEnchants.THORN);
        if (i > 0) {
            damage = MathHelper.func_76128_c((double)((double)damage * (double)((float)i * 0.15f)));
        }
        return damage;
    }

    @SubscribeEvent
    public static void onRightClick(PlayerInteractEvent.EntityInteract event) {
        LivingEntity target;
        ItemStack stack = event.getItemStack();
        Entity entityTarget = event.getTarget();
        if (stack.func_77973_b() == ModItems.MOB_ENCHANT_BOOK && !event.getPlayer().func_184811_cZ().func_185141_a(stack.func_77973_b()) && entityTarget instanceof LivingEntity) {
            target = (LivingEntity)entityTarget;
            if (MobEnchantUtils.hasMobEnchant(stack)) {
                target.getCapability(EnchantWithMob.MOB_ENCHANT_CAP).ifPresent(cap -> {
                    MobEnchantUtils.addItemMobEnchantToEntity(stack, target, cap);
                    event.getPlayer().func_184185_a(SoundEvents.field_190021_aL, 1.0f, 1.0f);
                    stack.func_222118_a(1, (LivingEntity)event.getPlayer(), entity -> entity.func_213334_d(event.getHand()));
                    event.getPlayer().func_184811_cZ().func_185145_a(stack.func_77973_b(), 60);
                    event.setCancellationResult(ActionResultType.SUCCESS);
                    event.setCanceled(true);
                });
            }
        }
        if (stack.func_77973_b() == ModItems.MOB_UNENCHANT_BOOK && !event.getPlayer().func_184811_cZ().func_185141_a(stack.func_77973_b()) && entityTarget instanceof LivingEntity) {
            target = (LivingEntity)entityTarget;
            target.getCapability(EnchantWithMob.MOB_ENCHANT_CAP).ifPresent(cap -> {
                MobEnchantUtils.removeMobEnchantToEntity(target, cap);
                event.getPlayer().func_184185_a(SoundEvents.field_190021_aL, 1.0f, 1.0f);
                stack.func_222118_a(1, (LivingEntity)event.getPlayer(), entity -> entity.func_213334_d(event.getHand()));
                event.getPlayer().func_184811_cZ().func_185145_a(stack.func_77973_b(), 80);
                event.setCancellationResult(ActionResultType.SUCCESS);
                event.setCanceled(true);
            });
        }
    }

    @SubscribeEvent
    public static void onAnvilUpdate(AnvilUpdateEvent event) {
        ItemStack stack1 = event.getLeft();
        ItemStack stack2 = event.getRight();
        if (stack1.func_77973_b() == ModItems.MOB_ENCHANT_BOOK && stack2.func_77973_b() == ModItems.MOB_ENCHANT_BOOK) {
            Map<MobEnchant, Integer> map = MobEnchantUtils.getEnchantments(stack1);
            Map<MobEnchant, Integer> map1 = MobEnchantUtils.getEnchantments(stack2);
            boolean flag2 = false;
            boolean flag3 = false;
            for (MobEnchant enchantment1 : map1.keySet()) {
                int j2;
                if (enchantment1 == null) continue;
                int i2 = map.getOrDefault((Object)enchantment1, 0);
                j2 = i2 == (j2 = map1.get((Object)enchantment1).intValue()) ? j2 + 1 : Math.max(j2, i2);
                boolean flag1 = true;
                for (MobEnchant enchantment : map.keySet()) {
                    if (enchantment == enchantment1 || enchantment1.isCompatibleWith(enchantment)) continue;
                    flag1 = false;
                }
                if (!flag1) {
                    flag3 = true;
                    continue;
                }
                flag2 = true;
                if (j2 > enchantment1.getMaxLevel()) {
                    j2 = enchantment1.getMaxLevel();
                }
                map.put(enchantment1, j2);
                int k3 = 0;
                switch (enchantment1.getRarity()) {
                    case COMMON: {
                        k3 = 1;
                        break;
                    }
                    case UNCOMMON: {
                        k3 = 2;
                        break;
                    }
                    case RARE: {
                        k3 = 4;
                        break;
                    }
                    case VERY_RARE: {
                        k3 = 8;
                    }
                }
            }
            if (!stack1.func_190926_b()) {
                int k2 = stack1.func_82838_A();
                if (!stack2.func_190926_b() && k2 < stack2.func_82838_A()) {
                    k2 = stack2.func_82838_A();
                }
                ItemStack stack3 = new ItemStack((IItemProvider)stack1.func_77973_b());
                MobEnchantUtils.setEnchantments(map, stack3);
                stack3.func_82841_c(4 + k2);
                event.setOutput(stack3);
                event.setCost(4 + k2);
                event.setMaterialCost(1);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        PlayerEntity player = event.getPlayer();
        if (player instanceof ServerPlayerEntity) {
            player.getCapability(EnchantWithMob.MOB_ENCHANT_CAP).ifPresent(handler -> {
                for (int i = 0; i < handler.getMobEnchants().size(); ++i) {
                    EnchantWithMob.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new MobEnchantedMessage((Entity)player, handler.getMobEnchants().get(i)));
                }
            });
        }
    }

    @SubscribeEvent
    public static void onExpDropped(LivingExperienceDropEvent event) {
        LivingEntity entity = event.getEntityLiving();
        entity.getCapability(EnchantWithMob.MOB_ENCHANT_CAP).ifPresent(cap -> {
            if (cap.hasEnchant()) {
                event.setDroppedExperience(event.getDroppedExperience() + MobEnchantUtils.getExperienceFromMob(cap));
            }
        });
    }

    @SubscribeEvent
    public static void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        PlayerEntity playerEntity = event.getPlayer();
        playerEntity.getCapability(EnchantWithMob.MOB_ENCHANT_CAP).ifPresent(handler -> {
            for (int i = 0; i < handler.getMobEnchants().size(); ++i) {
                EnchantWithMob.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> playerEntity), (Object)new MobEnchantedMessage((Entity)playerEntity, handler.getMobEnchants().get(i)));
            }
        });
    }
}

