/*
 * Decompiled with CFR 0.152.
 */
package com.baguchan.enchantwithmob;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="enchantwithmob", bus=Mod.EventBusSubscriber.Bus.MOD)
public class EnchantConfig {
    public static final Common COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final Client CLIENT;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static boolean naturalSpawnEnchantedMob;
    public static boolean spawnEnchantedAnimal;
    public static boolean enchantYourSelf;
    public static boolean changeSizeWhenEnchant;
    public static boolean showEnchantedMobHud;
    public static List<? extends String> ENCHANT_ON_SPAWN_EXCLUSION_MOBS;
    public static List<? extends String> ALWAY_ENCHANTABLE_MOBS;

    public static void bakeConfig() {
        naturalSpawnEnchantedMob = (Boolean)EnchantConfig.COMMON.naturalSpawnEnchantedMob.get();
        spawnEnchantedAnimal = (Boolean)EnchantConfig.COMMON.spawnEnchantedAnimal.get();
        enchantYourSelf = (Boolean)EnchantConfig.COMMON.enchantYourSelf.get();
        changeSizeWhenEnchant = (Boolean)EnchantConfig.COMMON.changeSizeWhenEnchant.get();
        ENCHANT_ON_SPAWN_EXCLUSION_MOBS = (List)EnchantConfig.COMMON.ENCHANT_ON_SPAWN_EXCLUSION_MOBS.get();
        ALWAY_ENCHANTABLE_MOBS = (List)EnchantConfig.COMMON.ALWAY_ENCHANTABLE_MOBS.get();
    }

    public static void bakeConfigClient() {
        showEnchantedMobHud = (Boolean)EnchantConfig.CLIENT.showEnchantedMobHud.get();
    }

    @SubscribeEvent
    public static void onModConfigEvent(ModConfigEvent.Loading configEvent) {
        if (configEvent.getConfig().getSpec() == COMMON_SPEC) {
            EnchantConfig.bakeConfig();
        }
        if (configEvent.getConfig().getSpec() == CLIENT_SPEC) {
            EnchantConfig.bakeConfigClient();
        }
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
        Pair specPair2 = new ForgeConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (ForgeConfigSpec)specPair2.getRight();
        CLIENT = (Client)specPair2.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.BooleanValue naturalSpawnEnchantedMob;
        public final ForgeConfigSpec.BooleanValue spawnEnchantedAnimal;
        public final ForgeConfigSpec.BooleanValue enchantYourSelf;
        public final ForgeConfigSpec.BooleanValue changeSizeWhenEnchant;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> ENCHANT_ON_SPAWN_EXCLUSION_MOBS;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> ALWAY_ENCHANTABLE_MOBS;

        public Common(ForgeConfigSpec.Builder builder) {
            this.naturalSpawnEnchantedMob = builder.comment("Enable the the spawning of enchanted mobs. [true / false]").translation("enchantwithmob.config.naturalSpawnEnchantedMob").define("Enchanted Mob can Spawn Natural", true);
            this.ENCHANT_ON_SPAWN_EXCLUSION_MOBS = builder.comment("Disables specific mob from receiveing enchantments on spawn. Use the full name, eg: minecraft:ender_dragon.").define("enchantOnSpawnExclusionMobs", (Object)Lists.newArrayList((Object[])new String[]{"minecraft:wither", "minecraft:ender_dragon"}));
            this.ALWAY_ENCHANTABLE_MOBS = builder.comment("Allow the specific mob from alway receiveing enchantments on spawn. Use the full name, eg: minecraft:zombie.").define("alwayEnchantableMobs", (Object)Lists.newArrayList());
            this.spawnEnchantedAnimal = builder.comment("Enable the the spawning of enchanted animal mobs. [true / false]").translation("enchantwithmob.config.spawnEnchantedAnimal").define("Enchanted Animal can Spawn Natural", false);
            this.enchantYourSelf = builder.comment("Enable enchanting yourself. [true / false]").translation("enchantwithmob.config.enchantYourSelf").define("Enchant yourself", true);
            this.changeSizeWhenEnchant = builder.comment("Change Size When Enchanted. [true / false]").translation("enchantwithmob.config.changeSizeWhenEnchant").define("Change Size When Enchanted", true);
        }
    }

    public static class Client {
        public final ForgeConfigSpec.BooleanValue showEnchantedMobHud;

        public Client(ForgeConfigSpec.Builder builder) {
            this.showEnchantedMobHud = builder.translation("enchantwithmob.config.showEnchantedMobHud").define("Show Enchanted Mob Hud", true);
        }
    }
}

