/*
 * Decompiled with CFR 0.152.
 */
package com.baguchan.enchantwithmob.capability;

import com.baguchan.enchantwithmob.EnchantWithMob;
import com.baguchan.enchantwithmob.capability.MobEnchantHandler;
import com.baguchan.enchantwithmob.message.MobEnchantFromOwnerMessage;
import com.baguchan.enchantwithmob.message.MobEnchantedMessage;
import com.baguchan.enchantwithmob.message.RemoveAllMobEnchantMessage;
import com.baguchan.enchantwithmob.message.RemoveMobEnchantOwnerMessage;
import com.baguchan.enchantwithmob.mobenchant.MobEnchant;
import com.baguchan.enchantwithmob.utils.MobEnchantUtils;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fmllegacy.network.PacketDistributor;

public class MobEnchantCapability
implements ICapabilityProvider,
INBTSerializable<CompoundTag> {
    private List<MobEnchantHandler> mobEnchants = Lists.newArrayList();
    private Optional<LivingEntity> enchantOwner = Optional.empty();
    private boolean fromOwner;

    public void addMobEnchant(LivingEntity entity, MobEnchant mobEnchant, int enchantLevel) {
        this.mobEnchants.add(new MobEnchantHandler(mobEnchant, enchantLevel));
        this.onNewEnchantEffect(entity, mobEnchant, enchantLevel);
        if (!entity.f_19853_.f_46443_) {
            MobEnchantedMessage message = new MobEnchantedMessage((Entity)entity, mobEnchant, enchantLevel);
            EnchantWithMob.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)message);
        }
        entity.m_6210_();
    }

    public void addMobEnchantFromOwner(LivingEntity entity, MobEnchant mobEnchant, int enchantLevel, LivingEntity owner) {
        this.mobEnchants.add(new MobEnchantHandler(mobEnchant, enchantLevel));
        this.onNewEnchantEffect(entity, mobEnchant, enchantLevel);
        if (!entity.f_19853_.f_46443_) {
            MobEnchantedMessage message = new MobEnchantedMessage((Entity)entity, mobEnchant, enchantLevel);
            EnchantWithMob.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)message);
        }
        entity.m_6210_();
    }

    public void addOwner(LivingEntity entity, @Nullable LivingEntity owner) {
        this.fromOwner = true;
        this.enchantOwner = Optional.ofNullable(owner);
        if (!entity.f_19853_.f_46443_) {
            MobEnchantFromOwnerMessage message = new MobEnchantFromOwnerMessage((Entity)entity, (Entity)owner);
            EnchantWithMob.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)message);
        }
    }

    public void removeOwner(LivingEntity entity) {
        this.fromOwner = false;
        this.enchantOwner = Optional.empty();
        if (!entity.f_19853_.f_46443_) {
            RemoveMobEnchantOwnerMessage message = new RemoveMobEnchantOwnerMessage((Entity)entity);
            EnchantWithMob.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)message);
        }
    }

    public void removeAllMobEnchant(LivingEntity entity) {
        for (int i = 0; i < this.mobEnchants.size(); ++i) {
            this.onRemoveEnchantEffect(entity, this.mobEnchants.get(i).getMobEnchant());
        }
        if (!entity.f_19853_.f_46443_) {
            RemoveAllMobEnchantMessage message = new RemoveAllMobEnchantMessage((Entity)entity);
            EnchantWithMob.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)message);
        }
        this.mobEnchants.removeAll(this.mobEnchants);
        entity.m_6210_();
    }

    public void removeMobEnchantFromOwner(LivingEntity entity) {
        for (int i = 0; i < this.mobEnchants.size(); ++i) {
            this.onRemoveEnchantEffect(entity, this.mobEnchants.get(i).getMobEnchant());
        }
        if (!entity.f_19853_.f_46443_) {
            RemoveAllMobEnchantMessage message = new RemoveAllMobEnchantMessage((Entity)entity);
            EnchantWithMob.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)message);
        }
        this.mobEnchants.removeAll(this.mobEnchants);
        this.removeOwner(entity);
        entity.m_6210_();
    }

    public void onNewEnchantEffect(LivingEntity entity, MobEnchant enchant, int enchantLevel) {
        if (!entity.f_19853_.f_46443_) {
            enchant.applyAttributesModifiersToEntity(entity, entity.m_21204_(), enchantLevel);
        }
    }

    protected void onChangedEnchantEffect(LivingEntity entity, MobEnchant enchant, int enchantLevel) {
        if (!entity.f_19853_.f_46443_) {
            enchant.applyAttributesModifiersToEntity(entity, entity.m_21204_(), enchantLevel);
        }
    }

    protected void onRemoveEnchantEffect(LivingEntity entity, MobEnchant enchant) {
        if (!entity.f_19853_.m_5776_()) {
            enchant.removeAttributesModifiersFromEntity(entity, entity.m_21204_());
        }
    }

    public List<MobEnchantHandler> getMobEnchants() {
        return this.mobEnchants;
    }

    public boolean hasEnchant() {
        return !this.mobEnchants.isEmpty();
    }

    public Optional<LivingEntity> getEnchantOwner() {
        return this.enchantOwner;
    }

    public boolean hasOwner() {
        return this.enchantOwner.isPresent() && this.enchantOwner.get().m_6084_();
    }

    public boolean isFromOwner() {
        return this.fromOwner;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        return capability == EnchantWithMob.MOB_ENCHANT_CAP ? LazyOptional.of(() -> this).cast() : LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        ListTag listnbt = new ListTag();
        for (int i = 0; i < this.mobEnchants.size(); ++i) {
            listnbt.add((Object)this.mobEnchants.get(i).writeNBT());
        }
        nbt.m_128365_("StoredMobEnchants", (Tag)listnbt);
        nbt.m_128379_("FromOwner", this.fromOwner);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        ListTag list = MobEnchantUtils.getEnchantmentListForNBT(nbt);
        this.mobEnchants.clear();
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag compoundnbt = list.m_128728_(i);
            this.mobEnchants.add(new MobEnchantHandler(MobEnchantUtils.getEnchantFromNBT(compoundnbt), MobEnchantUtils.getEnchantLevelFromNBT(compoundnbt)));
        }
        this.fromOwner = nbt.m_128471_("FromOwner");
    }
}

