/*
 * Decompiled with CFR 0.152.
 */
package com.baguchan.enchantwithmob.event;

import com.baguchan.enchantwithmob.EnchantConfig;
import com.baguchan.enchantwithmob.EnchantWithMob;
import com.baguchan.enchantwithmob.registry.MobEnchants;
import com.baguchan.enchantwithmob.utils.MobEnchantUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="enchantwithmob")
public class EntitySizeEvent {
    @SubscribeEvent
    public static void onSetSize(EntityEvent.Size event) {
        Entity entity = event.getEntity();
        LazyOptional capLazy = entity.getCapability(EnchantWithMob.MOB_ENCHANT_CAP);
        capLazy.ifPresent(cap -> {
            if (cap.hasEnchant()) {
                if (MobEnchantUtils.findMobEnchantFromHandler(cap.getMobEnchants(), MobEnchants.HUGE)) {
                    int level = MobEnchantUtils.getMobEnchantLevelFromHandler(cap.getMobEnchants(), MobEnchants.HUGE);
                    float totalWidth = entity.m_6972_((Pose)entity.m_20089_()).f_20377_ * (1.0f + (float)level * 0.15f);
                    float totalHeight = entity.m_6972_((Pose)entity.m_20089_()).f_20378_ * (1.0f + (float)level * 0.15f);
                    event.setNewEyeHeight(entity.m_20236_(entity.m_20089_()) * (1.0f + (float)level * 0.15f));
                    event.setNewSize(EntityDimensions.m_20398_((float)totalWidth, (float)totalHeight));
                } else if (((Boolean)EnchantConfig.COMMON.changeSizeWhenEnchant.get()).booleanValue()) {
                    float totalWidth = entity.m_6972_((Pose)entity.m_20089_()).f_20377_ * 1.025f;
                    float totalHeight = entity.m_6972_((Pose)entity.m_20089_()).f_20378_ * 1.025f;
                    event.setNewEyeHeight(entity.m_20236_(entity.m_20089_()) * 1.025f);
                    event.setNewSize(EntityDimensions.m_20398_((float)totalWidth, (float)totalHeight));
                }
            }
        });
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onRenderWorld(RenderWorldLastEvent event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        float scale = player.m_20206_() / 1.8f;
        switch (Minecraft.m_91087_().f_91066_.m_92176_()) {
            case THIRD_PERSON_BACK: {
                if (!(player.m_20206_() > 1.8f)) break;
                event.getMatrixStack().m_85837_(0.0, 0.0, (double)(-scale * 2.0f));
                break;
            }
            case THIRD_PERSON_FRONT: {
                if (!(player.m_20206_() > 1.8f)) break;
                event.getMatrixStack().m_85837_(0.0, 0.0, (double)(scale * 2.0f));
            }
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onEntityRenderPre(RenderLivingEvent.Pre<LivingEntity, EntityModel<LivingEntity>> event) {
        LivingEntity entity = event.getEntity();
        LazyOptional capLazy = entity.getCapability(EnchantWithMob.MOB_ENCHANT_CAP);
        capLazy.ifPresent(cap -> {
            if (cap.hasEnchant()) {
                event.getMatrixStack().m_85836_();
                if (MobEnchantUtils.findMobEnchantFromHandler(cap.getMobEnchants(), MobEnchants.HUGE)) {
                    int level = MobEnchantUtils.getMobEnchantLevelFromHandler(cap.getMobEnchants(), MobEnchants.HUGE);
                    event.getMatrixStack().m_85841_(1.0f + 0.15f * (float)level, 1.0f + 0.15f * (float)level, 1.0f + 0.15f * (float)level);
                } else if (((Boolean)EnchantConfig.COMMON.changeSizeWhenEnchant.get()).booleanValue()) {
                    event.getMatrixStack().m_85841_(1.05f, 1.05f, 1.05f);
                }
            }
        });
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onLivingRenderPost(RenderLivingEvent.Post<LivingEntity, EntityModel<LivingEntity>> event) {
        LivingEntity entity = event.getEntity();
        LazyOptional capLazy = entity.getCapability(EnchantWithMob.MOB_ENCHANT_CAP);
        capLazy.ifPresent(cap -> {
            if (cap.hasEnchant()) {
                event.getMatrixStack().m_85849_();
            }
        });
    }
}

