/*
 * Decompiled with CFR 0.152.
 */
package com.baguchan.enchantwithmob.message;

import com.baguchan.enchantwithmob.EnchantWithMob;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class MobEnchantFromOwnerMessage {
    private int entityId;
    private int ownerID;

    public MobEnchantFromOwnerMessage(Entity entity, Entity ownerEntity) {
        this.entityId = entity.m_142049_();
        this.ownerID = ownerEntity.m_142049_();
    }

    public MobEnchantFromOwnerMessage(int id, int ownerID) {
        this.entityId = id;
        this.ownerID = ownerID;
    }

    public void serialize(FriendlyByteBuf buffer) {
        buffer.writeInt(this.entityId);
        buffer.writeInt(this.ownerID);
    }

    public static MobEnchantFromOwnerMessage deserialize(FriendlyByteBuf buffer) {
        int entityId = buffer.readInt();
        int ownerId = buffer.readInt();
        return new MobEnchantFromOwnerMessage(entityId, ownerId);
    }

    public static boolean handle(MobEnchantFromOwnerMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide() == LogicalSide.CLIENT) {
            context.enqueueWork(() -> {
                Entity entity = Minecraft.m_91087_().f_91074_.f_19853_.m_6815_(message.entityId);
                Entity ownerEntity = Minecraft.m_91087_().f_91074_.f_19853_.m_6815_(message.ownerID);
                if (entity != null && entity instanceof LivingEntity && ownerEntity != null && ownerEntity instanceof LivingEntity) {
                    entity.getCapability(EnchantWithMob.MOB_ENCHANT_CAP, null).ifPresent(enchantCap -> enchantCap.addOwner((LivingEntity)entity, (LivingEntity)ownerEntity));
                }
            });
        }
        return true;
    }
}

